/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.undo;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.undo.JAXFrontUndoManager;
import com.jaxfront.core.util.undo.JAXFrontUndoableEditWrapper;
import java.io.PrintWriter;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ChoiceChangeUndoableEditWrapper
extends JAXFrontUndoableEditWrapper {
    private String _oldVType = null;
    private String _newVType = null;

    public ChoiceChangeUndoableEditWrapper(JAXFrontUndoManager manager, Object eventSource, Type target, Type newValue, Type oldValue, boolean isTemporary) {
        super(manager, target);
        this._sourceType = eventSource;
        this._oldVType = oldValue == null ? null : oldValue.getXPathLocation();
        this._newVType = newValue == null ? null : newValue.getXPathLocation();
    }

    public ChoiceChangeUndoableEditWrapper(JAXFrontUndoManager manager, Object eventSource, String target, String newValueXPath, String oldValueXPath) {
        super(manager, target);
        this._sourceType = eventSource;
        this._oldVType = oldValueXPath;
        this._newVType = newValueXPath;
    }

    public void die() {
        super.die();
        this._oldVType = null;
        this._newVType = null;
    }

    public String getPresentationName() {
        return "Shit";
    }

    public void redo() throws CannotRedoException {
        super.redo();
        Type tt = this.evalTargetType();
        if (tt != null) {
            this.startBlocking();
            Type nvT = TypePathExecuter.getInstance().getTypeForXPath(this._targetDOM.getRootType(), this._newVType, false, false, false, false, true);
            if (nvT == null && LogRegistry.getInstance().logWarnings()) {
                LogRegistry.getInstance().warn(this.getClass(), "redo cant find new choicetype:" + this._newVType);
            }
            ((AbstractType)tt).setChoosenType(JAXFrontUndoManager.class, nvT, false, true);
            this.stopBlocking();
            this.visualizeRedo(tt);
            this._manager.fireUndoableEditUpdate(new UndoableEditEvent(tt, this));
        }
    }

    public void undo() throws CannotUndoException {
        super.undo();
        Type tt = this.evalTargetType();
        if (tt != null) {
            this.startBlocking();
            Type nvT = TypePathExecuter.getInstance().getTypeForXPath(this._targetDOM.getRootType(), this._oldVType, false, false, false, false, true);
            if (nvT == null && JAXFrontProperties.LOG_ENABLED) {
                LogRegistry.getInstance().warn(this.getClass(), "undo cant find old choicetype:" + this._oldVType);
            }
            ((AbstractType)tt).setChoosenType(JAXFrontUndoManager.class, nvT, false, true);
            this.stopBlocking();
            this.visualizeUndo(tt);
            this._manager.fireUndoableEditUpdate(new UndoableEditEvent(tt, this));
        }
    }

    public void serialize(PrintWriter writer) {
        super.serialize(writer);
        if (this._oldVType != null) {
            writer.print(this._oldVType);
        }
        writer.print(";");
        if (this._newVType != null) {
            writer.print(this._newVType);
        }
    }
}

