/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.stringSearch;

import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.stringSearch.CharIntMap;
import com.jaxfront.core.util.stringSearch.MismatchSearch;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class StringSearch {
    private static final int CROSSOVER_IBM_1_3 = 68;
    private static final int CROSSOVER_SUN_PRE_1_4 = 90;
    private static final int CROSSOVER_SUN_1_4 = 12;
    protected static boolean useNative = false;
    private static int crossover = 0;
    protected static Dispatch activeDispatch;

    public static boolean usesReflection() {
        return activeDispatch instanceof ReflectionDispatch;
    }

    protected StringSearch() {
    }

    public boolean usesNative() {
        return useNative;
    }

    public abstract Object processBytes(byte[] var1);

    public abstract Object processChars(char[] var1);

    public final Object processString(String pattern) {
        return this.processChars(activeDispatch.charsOf(pattern));
    }

    public static ArrayList getAllOccurences(String text, String find, boolean matchCase, boolean useAsRegex) {
        Pattern p = null;
        if (!useAsRegex) {
            char[] escape = new char[]{'^', '$', '.', '*', '+', '?', '=', '!', ':', '|', '/', '(', ')', '[', ']', '{', '}'};
            String[] escapeTo = new String[]{"\\^", "\\$", "\\.", "\\*", "\\+", "\\?", "\\=", "\\!", "\\:", "\\|", "\\/", "\\(", "\\)", "\\[", "\\]", "\\{", "\\}"};
            find = StringUtil.replace(find, escape, escapeTo);
        }
        p = matchCase ? Pattern.compile(find) : Pattern.compile(find, 2);
        Matcher m = p.matcher(text);
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (m.find()) {
            result.add(new Integer(m.start()));
        }
        return result;
    }

    public final int searchBytes(byte[] text, byte[] pattern) {
        return this.searchBytes(text, 0, text.length, pattern, this.processBytes(pattern));
    }

    public final int searchBytes(byte[] text, byte[] pattern, Object processed) {
        return this.searchBytes(text, 0, text.length, pattern, processed);
    }

    public final int searchBytes(byte[] text, int textStart, byte[] pattern) {
        return this.searchBytes(text, textStart, text.length, pattern, this.processBytes(pattern));
    }

    public final int searchBytes(byte[] text, int textStart, byte[] pattern, Object processed) {
        return this.searchBytes(text, textStart, text.length, pattern, processed);
    }

    public final int searchBytes(byte[] text, int textStart, int textEnd, byte[] pattern) {
        return this.searchBytes(text, textStart, textEnd, pattern, this.processBytes(pattern));
    }

    public abstract int searchBytes(byte[] var1, int var2, int var3, byte[] var4, Object var5);

    public final int searchChars(char[] text, char[] pattern) {
        return this.searchChars(text, 0, text.length, pattern, this.processChars(pattern));
    }

    public final int searchChars(char[] text, char[] pattern, Object processed) {
        return this.searchChars(text, 0, text.length, pattern, processed);
    }

    public final int searchChars(char[] text, int textStart, char[] pattern) {
        return this.searchChars(text, textStart, text.length, pattern, this.processChars(pattern));
    }

    public final int searchChars(char[] text, int textStart, char[] pattern, Object processed) {
        return this.searchChars(text, textStart, text.length, pattern, processed);
    }

    public final int searchChars(char[] text, int textStart, int textEnd, char[] pattern) {
        return this.searchChars(text, textStart, textEnd, pattern, this.processChars(pattern));
    }

    public abstract int searchChars(char[] var1, int var2, int var3, char[] var4, Object var5);

    public final int searchString(String text, String pattern) {
        return this.searchString(text, 0, text.length(), pattern);
    }

    public final int searchString(String text, String pattern, Object processed) {
        return this.searchString(text, 0, text.length(), pattern, processed);
    }

    public final int searchString(String text, int textStart, String pattern) {
        return this.searchString(text, textStart, text.length(), pattern);
    }

    public final int searchString(String text, int textStart, String pattern, Object processed) {
        return this.searchString(text, textStart, text.length(), pattern, processed);
    }

    public final int searchString(String text, int textStart, int textEnd, String pattern) {
        return activeDispatch.searchString(text, textStart, textEnd, pattern, this);
    }

    public final int searchString(String text, int textStart, int textEnd, String pattern, Object processed) {
        return activeDispatch.searchString(text, textStart, textEnd, pattern, processed, this);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass().getName().equals(obj.getClass().getName());
    }

    public final int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public final String toString() {
        return this.toStringBuffer(null).toString();
    }

    public StringBuffer toStringBuffer(StringBuffer in) {
        if (in == null) {
            in = new StringBuffer();
        }
        in.append("{ ");
        int idx = this.getClass().getName().lastIndexOf(".");
        if (idx > -1) {
            in.append(this.getClass().getName().substring(++idx));
        } else {
            in.append(this.getClass().getName());
        }
        in.append(" }");
        return in;
    }

    protected CharIntMap createCharIntMap(char[] pattern) {
        return this.createCharIntMap(pattern, 0);
    }

    protected CharIntMap createCharIntMap(char[] pattern, int defaultValue) {
        char min = '\uffff';
        char max = '\u0000';
        for (int i = 0; i < pattern.length; ++i) {
            max = max > pattern[i] ? max : pattern[i];
            min = min < pattern[i] ? min : pattern[i];
        }
        return new CharIntMap(max - min + 1, min, defaultValue);
    }

    protected final int index(byte idx) {
        return idx < 0 ? 256 + idx : idx;
    }

    static {
        String shortString = " ";
        " ".hashCode();
        String s = null;
        try {
            s = System.getProperty("com.eaio.stringsearch.native");
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (s == null || "true".equalsIgnoreCase(s)) {
            try {
                Runtime.getRuntime().loadLibrary("NativeSearch");
                useNative = true;
            }
            catch (SecurityException ex) {
            }
            catch (UnsatisfiedLinkError ex) {
                // empty catch block
            }
        }
        Field value = null;
        Field offset = null;
        Field[] stringFields = null;
        try {
            stringFields = " ".getClass().getDeclaredFields();
        }
        catch (SecurityException ex) {
            try {
                stringFields = (Field[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return " ".getClass().getDeclaredFields();
                    }
                });
            }
            catch (SecurityException ex2) {
                // empty catch block
            }
        }
        if (stringFields != null) {
            Class<?> charArray = new char[0].getClass();
            for (int i = 0; i < stringFields.length; ++i) {
                if (stringFields[i].getType() == charArray) {
                    final Field v = stringFields[i];
                    try {
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                v.setAccessible(true);
                                return null;
                            }
                        });
                        value = v;
                    }
                    catch (SecurityException ex) {}
                    continue;
                }
                if (stringFields[i].getType() != Integer.TYPE) continue;
                final Field o = stringFields[i];
                try {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            o.setAccessible(true);
                            return null;
                        }
                    });
                    if (o.getInt(" ") != 0) continue;
                    offset = o;
                    break;
                }
                catch (SecurityException ex) {
                    continue;
                }
                catch (IllegalAccessException ex) {
                    // empty catch block
                }
            }
        }
        if (value != null && offset != null) {
            activeDispatch = new ReflectionDispatch(value, offset);
            String vendor = System.getProperty("java.vendor");
            String version = System.getProperty("java.version");
            char v = vendor.charAt(0);
            int ver = version.charAt(2) - 48;
            if (v == 'I') {
                if (ver < 4) {
                    crossover = 68;
                }
            } else if (v == 'S') {
                crossover = ver > 3 ? 12 : 90;
            }
        } else {
            activeDispatch = new Dispatch();
        }
    }

    protected static class ReflectionDispatch
    extends Dispatch {
        private Field value;
        private Field offset;

        private ReflectionDispatch(Field value, Field offset) {
            this.value = value;
            this.offset = offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int searchString(String text, int textStart, int textEnd, String pattern, Object processed, StringSearch instance) {
            int l = text.length();
            if (l > crossover) {
                try {
                    int o = this.offset.getInt(text);
                    char[] t = (char[])this.value.get(text);
                    return instance.searchChars(t, textStart + o, textEnd + o, this.charsOf(pattern), processed) - o;
                }
                catch (IllegalAccessException ex) {
                    Dispatch dispatch = activeDispatch;
                    synchronized (dispatch) {
                        activeDispatch = new Dispatch();
                    }
                }
            }
            return super.searchString(text, textStart, textEnd, pattern, processed, instance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int searchString(String text, int textStart, int textEnd, String pattern, StringSearch instance) {
            int l = text.length();
            if (l > crossover) {
                try {
                    int o = this.offset.getInt(text);
                    char[] t = (char[])this.value.get(text);
                    return instance.searchChars(t, textStart + o, textEnd + o, this.charsOf(pattern)) - o;
                }
                catch (IllegalAccessException ex) {
                    Dispatch dispatch = activeDispatch;
                    synchronized (dispatch) {
                        activeDispatch = new Dispatch();
                    }
                }
            }
            return super.searchString(text, textStart, textEnd, pattern, instance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int[] searchString(String text, int textStart, int textEnd, String pattern, int k, MismatchSearch instance) {
            int l = text.length();
            if (l > crossover) {
                try {
                    int o = this.offset.getInt(text);
                    char[] t = (char[])this.value.get(text);
                    int[] r = instance.searchChars(t, textStart + o, textEnd + o, this.charsOf(pattern), k);
                    if (r[0] != -1) {
                        r[0] = r[0] - o;
                    }
                    return r;
                }
                catch (IllegalAccessException ex) {
                    Dispatch dispatch = activeDispatch;
                    synchronized (dispatch) {
                        activeDispatch = new Dispatch();
                    }
                }
            }
            return super.searchString(text, textStart, textEnd, pattern, k, instance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int[] searchString(String text, int textStart, int textEnd, String pattern, Object processed, int k, MismatchSearch instance) {
            int l = text.length();
            if (l > crossover) {
                try {
                    int o = this.offset.getInt(text);
                    char[] t = (char[])this.value.get(text);
                    int[] r = instance.searchChars(t, textStart + o, textEnd + o, this.charsOf(pattern), processed, k);
                    if (r[0] != -1) {
                        r[0] = r[0] - o;
                    }
                    return r;
                }
                catch (IllegalAccessException ex) {
                    Dispatch dispatch = activeDispatch;
                    synchronized (dispatch) {
                        activeDispatch = new Dispatch();
                    }
                }
            }
            return super.searchString(text, textStart, textEnd, pattern, processed, k, instance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected char[] charsOf(String s) {
            int l = s.length();
            if (l > crossover) {
                try {
                    if (this.offset.getInt(s) != 0) {
                        return super.charsOf(s);
                    }
                    char[] c = (char[])this.value.get(s);
                    if (c.length != l) {
                        return super.charsOf(s);
                    }
                    return c;
                }
                catch (IllegalAccessException ex) {
                    Dispatch dispatch = activeDispatch;
                    synchronized (dispatch) {
                        activeDispatch = new Dispatch();
                    }
                }
            }
            return super.charsOf(s);
        }
    }

    protected static class Dispatch {
        private Dispatch() {
        }

        protected int searchString(String text, int textStart, int textEnd, String pattern, Object processed, StringSearch instance) {
            return instance.searchChars(text.toCharArray(), textStart, textEnd, pattern.toCharArray(), processed);
        }

        protected int searchString(String text, int textStart, int textEnd, String pattern, StringSearch instance) {
            return instance.searchChars(text.toCharArray(), textStart, textEnd, pattern.toCharArray());
        }

        protected int[] searchString(String text, int textStart, int textEnd, String pattern, int k, MismatchSearch instance) {
            return instance.searchChars(text.toCharArray(), textStart, textEnd, pattern.toCharArray(), k);
        }

        protected int[] searchString(String text, int textStart, int textEnd, String pattern, Object processed, int k, MismatchSearch instance) {
            return instance.searchChars(text.toCharArray(), textStart, textEnd, pattern.toCharArray(), processed, k);
        }

        protected char[] charsOf(String s) {
            return s.toCharArray();
        }
    }
}

