/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.rule.Action;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.ResourceInfo;
import com.jaxfront.core.util.io.FileHelper;
import java.net.URL;

public class ShowSourceCodeAction
implements Action {
    public void perform(Type eventSource, Type target) {
        try {
            URL lookupUrl = eventSource.getDOM().getFingerPrint().getXSDURL();
            boolean showXUISourceCode = target.getName().indexOf("xui") != -1;
            String content = null;
            if (lookupUrl != null) {
                if (showXUISourceCode) {
                    lookupUrl = eventSource.getDOM().getFingerPrint().getXUIURL();
                }
                content = FileHelper.readFileAsString(lookupUrl);
            } else {
                Document jaxformsDOM = eventSource.getDOM().getFingerPrint().getJAXDOM();
                if (jaxformsDOM != null) {
                    ResourceInfo info = (ResourceInfo)jaxformsDOM.getClientProperty("resourceInfo");
                    content = info != null ? (showXUISourceCode ? FileHelper.readFileAsString(info.getXuiInput()) : FileHelper.readFileAsString(info.getXsdInput())) : (showXUISourceCode ? jaxformsDOM.getFingerPrint().getXUIJAXContent() : jaxformsDOM.getFingerPrint().getXSDJAXContent());
                }
            }
            ((SimpleType)target).setValue(content);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

