/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class SMTPMXLookup {
    private static int hear(BufferedReader in) throws IOException {
        String line = null;
        int res = 0;
        while ((line = in.readLine()) != null) {
            String pfx = line.substring(0, 3);
            try {
                res = Integer.parseInt(pfx);
            }
            catch (Exception ex) {
                res = -1;
            }
            if (line.charAt(3) == '-') continue;
            break;
        }
        return res;
    }

    private static void say(BufferedWriter wr, String text) throws IOException {
        wr.write(text + "\r\n");
        wr.flush();
    }

    private static ArrayList getMX(String hostName) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        InitialDirContext ictx = new InitialDirContext(env);
        Attributes attrs = ictx.getAttributes(hostName, new String[]{"MX"});
        Attribute attr = attrs.get("MX");
        if ((attr == null || attr.size() == 0) && (attr = (attrs = ictx.getAttributes(hostName, new String[]{"A"})).get("A")) == null) {
            throw new NamingException("No match for name '" + hostName + "'");
        }
        ArrayList<String> res = new ArrayList<String>();
        NamingEnumeration<?> en = attr.getAll();
        while (en.hasMore()) {
            String x = (String)en.next();
            String[] f = x.split(" ");
            String mailhost = f.length == 1 ? f[0] : (f[1].endsWith(".") ? f[1].substring(0, f[1].length() - 1) : f[1]);
            res.add(mailhost);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAddressValid(String address) {
        int pos = address.indexOf(64);
        if (pos == -1) {
            return false;
        }
        String domain = address.substring(++pos);
        ArrayList mxList = null;
        try {
            mxList = SMTPMXLookup.getMX(domain);
        }
        catch (NamingException ex) {
            return false;
        }
        if (mxList.size() == 0) {
            return false;
        }
        for (int mx = 0; mx < mxList.size(); ++mx) {
            boolean valid = false;
            try {
                Socket skt = new Socket((String)mxList.get(mx), 25);
                BufferedReader rdr = new BufferedReader(new InputStreamReader(skt.getInputStream()));
                BufferedWriter wtr = new BufferedWriter(new OutputStreamWriter(skt.getOutputStream()));
                int res = SMTPMXLookup.hear(rdr);
                if (res != 220) {
                    throw new Exception("Invalid header");
                }
                SMTPMXLookup.say(wtr, "EHLO rgagnon.com");
                res = SMTPMXLookup.hear(rdr);
                if (res != 250) {
                    throw new Exception("Not ESMTP");
                }
                SMTPMXLookup.say(wtr, "MAIL FROM: <tim@orbaker.com>");
                res = SMTPMXLookup.hear(rdr);
                if (res != 250) {
                    throw new Exception("Sender rejected");
                }
                SMTPMXLookup.say(wtr, "RCPT TO: <" + address + ">");
                res = SMTPMXLookup.hear(rdr);
                SMTPMXLookup.say(wtr, "RSET");
                SMTPMXLookup.hear(rdr);
                SMTPMXLookup.say(wtr, "QUIT");
                SMTPMXLookup.hear(rdr);
                if (res != 250) {
                    throw new Exception("Address is not valid!");
                }
                valid = true;
                rdr.close();
                wtr.close();
                skt.close();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (!valid) continue;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        String[] testData = new String[]{"martin.kraeuchi@bit.admin.ch", "spo@jaxfront.com", "thomas.staufer@gmail.com", "thomas.stauffer@gmail.com", "test@ibm.com"};
        for (int ctr = 0; ctr < testData.length; ++ctr) {
            System.out.println(testData[ctr] + " is valid? " + SMTPMXLookup.isAddressValid(testData[ctr]));
        }
    }
}

