/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.xui.GlobalDefinition;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;

public class Locale {
    private static Hashtable _locale = null;
    private String _dateFormat;
    private String _dateTimeFormat;
    private String _shortDateTimeFormat;
    private String _timeFormat;
    private String _shortTimeFormat;
    private String _language;
    private DateFormat _dateDFormat;
    private DateFormat _dateTimeDFormat;
    private DateFormat _dateTimeDFormatShort;
    private DateFormat _timeDFormat;

    public Locale(String language) {
        this._language = language;
        this._shortDateTimeFormat = GlobalDefinition.getDefaultDateTimeFormatShortStringPattern(language);
        this._shortTimeFormat = GlobalDefinition.getDefaultTimeFormatShortStringPattern(language);
        this._dateTimeFormat = GlobalDefinition.getDefaultDateTimeFormatStringPattern(language);
        this._dateFormat = GlobalDefinition.getDefaultDateFormatStringPattern(language);
        this._timeFormat = GlobalDefinition.getDefaultTimeFormatStringPattern(language);
    }

    public String getDateFormat() {
        return this._dateFormat;
    }

    public void setDateFormat(String format) {
        this._dateFormat = format;
    }

    public String getDateTimeFormat() {
        return this._dateTimeFormat;
    }

    public void setDateTimeFormat(String format) {
        this._dateTimeFormat = format;
    }

    public String getDateTimeFormatShort() {
        return this._shortDateTimeFormat;
    }

    public String getTimeFormatShort() {
        return this._shortTimeFormat;
    }

    public void setDateTimeFormatShort(String format) {
        this._shortDateTimeFormat = format;
    }

    public String getTimeFormat() {
        return this._timeFormat;
    }

    public void setTimeFormat(String format) {
        this._timeFormat = format;
    }

    public String getLanguage() {
        return this._language;
    }

    public void setLanguage(String language) {
        this._language = language;
    }

    private static Hashtable getLocale() {
        if (_locale == null) {
            _locale = new Hashtable();
        }
        return _locale;
    }

    public static Locale getLocale(String lang) {
        Locale loc;
        if (lang == null) {
            lang = "en";
        }
        if ((loc = (Locale)Locale.getLocale().get(lang)) == null) {
            loc = new Locale(lang);
            Locale.getLocale().put(lang, loc);
        }
        return loc;
    }

    public String formatDate(Date date) {
        if (this._dateDFormat == null) {
            this._dateDFormat = new SimpleDateFormat(this.getDateFormat());
        }
        return this._dateDFormat.format(date);
    }

    public String formatTime(Date date) {
        if (this._timeDFormat == null) {
            this._timeDFormat = new SimpleDateFormat(this.getTimeFormat());
        }
        return this._timeDFormat.format(date);
    }

    public String formatDateTime(Date date) {
        if (this._dateTimeDFormat == null) {
            this._dateTimeDFormat = new SimpleDateFormat(this.getDateTimeFormat());
        }
        return this._dateTimeDFormat.format(date);
    }

    public String formatDateTimeShort(Date date) {
        if (this._dateTimeDFormatShort == null) {
            this._dateTimeDFormatShort = new SimpleDateFormat(this.getDateTimeFormatShort());
        }
        return this._dateTimeDFormatShort.format(date);
    }
}

