/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.URLHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;

public class LastFile {
    private URL _xsdURL;
    private URL _xmlURL;
    private URL _xuiURL;
    private String _rootName;
    private int _counter = 0;

    public LastFile(String urls) {
        if (urls != null) {
            StringTokenizer tokenizer = new StringTokenizer(urls, ",");
            try {
                this._xsdURL = tokenizer.hasMoreTokens() ? this.makeURL(tokenizer.nextToken()) : null;
                this._xmlURL = tokenizer.hasMoreTokens() ? this.makeURL(tokenizer.nextToken()) : null;
                this._xuiURL = tokenizer.hasMoreTokens() ? this.makeURL(tokenizer.nextToken()) : null;
                this._rootName = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.makeControll();
    }

    public LastFile(URL xsdURL, URL xmlURL, URL xuiURL, String rootName) {
        this._xsdURL = xsdURL;
        this._xmlURL = xmlURL;
        this._xuiURL = xuiURL;
        this._rootName = rootName;
        this.makeControll();
    }

    public String getRootName() {
        return this._rootName;
    }

    public URL getXmlURL() {
        return this._xmlURL;
    }

    public URL getXsdURL() {
        return this._xsdURL;
    }

    public URL getXuiURL() {
        return this._xuiURL;
    }

    public int hits() {
        return this._counter;
    }

    private void makeControll() {
        if (this._xsdURL != null) {
            InputStream connection = null;
            try {
                if (this._xsdURL.getProtocol().equals("file")) {
                    connection = JAXFrontProperties.getInstance().getURLResolver().resolveURL(this._xsdURL);
                }
            }
            catch (IOException ex) {
                if (LogRegistry.getInstance().logInfos()) {
                    LogRegistry.getInstance().info(this.getClass(), "File for lastFiles not exist:" + this._xsdURL.toExternalForm());
                }
                this._xsdURL = null;
                this._xmlURL = null;
                this._xuiURL = null;
                this._rootName = null;
            }
            if (this._xmlURL != null) {
                try {
                    if (this._xsdURL.getProtocol().equals("file")) {
                        connection = JAXFrontProperties.getInstance().getURLResolver().resolveURL(this._xmlURL);
                    }
                }
                catch (IOException ex) {
                    if (LogRegistry.getInstance().logInfos()) {
                        LogRegistry.getInstance().info(this.getClass(), "File for lastFiles not exist:" + this._xmlURL.toExternalForm());
                    }
                    this._xmlURL = null;
                }
            }
            if (this._xuiURL != null) {
                try {
                    if (this._xsdURL.getProtocol().equals("file")) {
                        connection = JAXFrontProperties.getInstance().getURLResolver().resolveURL(this._xuiURL);
                    }
                }
                catch (IOException ex) {
                    if (this._xuiURL != null && LogRegistry.getInstance().logInfos()) {
                        LogRegistry.getInstance().info(this.getClass(), "File for lastFiles not exist:" + this._xuiURL.toExternalForm());
                    }
                    this._xuiURL = null;
                }
            }
        } else {
            this._xsdURL = null;
            this._xmlURL = null;
            this._xuiURL = null;
            this._rootName = null;
        }
    }

    private URL makeURL(String url) {
        URL tempURL = null;
        if (url != null && url.length() > 1) {
            tempURL = this.getClass().getClassLoader().getResource(url);
            if (tempURL != null && tempURL.toExternalForm().indexOf("%20") != -1) {
                String temp = TextTools.replace(tempURL.toExternalForm(), "%20", " ");
                tempURL = this.getClass().getClassLoader().getResource(temp);
            }
            if (tempURL == null) {
                if (url.startsWith(".")) {
                    tempURL = URLHelper.getInternalURL(url.substring(1, url.length()));
                    tempURL = URLHelper.getUserURL(url);
                } else {
                    tempURL = URLHelper.getUserURL(url);
                }
            }
        }
        return tempURL;
    }

    private String formatUrl(String url) {
        return url;
    }

    public String toString() {
        String aString = (this.getXsdURL() != null ? this.formatUrl(this.getXsdURL().toExternalForm()) : " ") + "," + (this.getXmlURL() != null ? this.formatUrl(this.getXmlURL().toExternalForm()) : " ") + "," + (this.getXuiURL() != null ? this.formatUrl(this.getXuiURL().toExternalForm()) : " ") + "," + (this.getRootName() != null ? this.getRootName() : " ") + ",";
        return aString;
    }

    public void upCounter() {
        ++this._counter;
    }

    public String getID() {
        String key = this.getXuiURL() != null ? this.getXuiURL().toExternalForm() : (this.getXmlURL() != null ? this.getXmlURL().toExternalForm() : (this.getXsdURL() != null ? this.getXsdURL().toExternalForm() : "unknown"));
        return key;
    }
}

