/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.ui.tableModel;

import com.jaxfront.core.ui.tableModel.FlippableListTypeTableModel;
import com.jaxfront.core.ui.tableModel.HeaderStrategy;
import com.jaxfront.core.ui.tableModel.StackableTableModel;
import com.jaxfront.core.util.IntroSpectionHelper;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class RowLeadedListModel
implements TableModel,
TableModelListener,
StackableTableModel {
    private TableModel theRealTableModel;
    private int rowColOffset = 1;
    private HeaderStrategy _strategy = null;

    public RowLeadedListModel(TableModel aRealModel) {
        this.theRealTableModel = aRealModel;
        this.theRealTableModel.addTableModelListener(this);
    }

    public int getColumnCount() {
        return this.theRealTableModel.getColumnCount() + this.rowColOffset;
    }

    public int getRowCount() {
        return this.theRealTableModel.getRowCount();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return false;
        }
        return this.theRealTableModel.isCellEditable(rowIndex, columnIndex - this.rowColOffset);
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Integer.class;
        }
        return this.theRealTableModel.getColumnClass(columnIndex - this.rowColOffset);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0 && this.rowColOffset != 0) {
            return this.getRowName(rowIndex);
        }
        return this.theRealTableModel.getValueAt(rowIndex, columnIndex - this.rowColOffset);
    }

    public int getViewToModel(int rowIndex) {
        if (rowIndex >= 0 && this.theRealTableModel != null && this.theRealTableModel instanceof StackableTableModel) {
            return ((StackableTableModel)this.theRealTableModel).getViewToModel(rowIndex);
        }
        return rowIndex;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            this.theRealTableModel.setValueAt(aValue, rowIndex, columnIndex - this.rowColOffset);
        }
    }

    private String getRowName(int rowIndex) {
        return this.getStrategy().getRowHeader(rowIndex);
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == 0 && this.rowColOffset != 0) {
            return " ";
        }
        return this.theRealTableModel.getColumnName(columnIndex - this.rowColOffset);
    }

    public void addTableModelListener(TableModelListener l) {
        this.theRealTableModel.addTableModelListener(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.theRealTableModel.removeTableModelListener(l);
    }

    public void showRowColumn(boolean showRowCol) {
        this.rowColOffset = showRowCol ? 1 : 0;
    }

    public HeaderStrategy getStrategy() {
        if (this._strategy == null) {
            this._strategy = new RowNumberStrategy();
        }
        return this._strategy;
    }

    public void setStrategy(HeaderStrategy strategy) {
        this._strategy = strategy;
    }

    public int modelIndex(int rowindex) {
        try {
            Object result = IntroSpectionHelper.callFunktion(this.theRealTableModel, "modelIndex", new Class[]{Integer.TYPE}, new Object[]{new Integer(rowindex)});
            if (result != null) {
                return Integer.parseInt(result.toString());
            }
            return -1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public void tableChanged(TableModelEvent e) {
    }

    public class ListTypeHeaderStrategy
    implements HeaderStrategy {
        FlippableListTypeTableModel _tm;

        public ListTypeHeaderStrategy(FlippableListTypeTableModel tm) {
            this._tm = tm;
        }

        public String getRowHeader(int row) {
            return this._tm.getRowName(row);
        }

        public int getWidth() {
            return 35;
        }

        public boolean shouldSwitchHeadersOnMove() {
            return false;
        }
    }

    public class RowNumberStrategy
    implements HeaderStrategy {
        private int _base = 1;

        public String getRowHeader(int row) {
            return "" + (this._base + row);
        }

        public int getWidth() {
            return 35;
        }

        public boolean shouldSwitchHeadersOnMove() {
            return false;
        }

        public int getBase() {
            return this._base;
        }

        public void setBase(int base) {
            this._base = base;
        }
    }
}

