/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.type;

import [Lcom.jaxfront.core.type.Type;;
import [Ljava.lang.Integer;;
import [Ljava.lang.String;;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.URLHelper;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class MethodParameter
implements Serializable {
    private Type _type;
    private String _className;
    private String _value;
    public static final String TYPE_BOOLEAN = "Boolean";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_STRING_ARRAY = "String[]";
    public static final String TYPE_INTEGER = "Integer";
    public static final String TYPE_BOOLEAN_PRIMITIVE = "boolean";
    public static final String TYPE_INTEGER_PRIMITIVE = "int";
    public static final String TYPE_COLOR = "Color";
    public static final String TYPE_VISUALIZER = "Visualizer";
    public static final String TYPE_TYPE = "Type";
    public static final String TYPE_SIMPLE_TYPE = "SimpleType";
    public static final String TYPE_TYPE_ARRAY = "Type[]";
    public static final String TYPE_URL = "URL";
    public static final String TYPE_INT_ARRAY = "int[]";
    public static final String TYPE_INTEGER_ARRAY = "Integer[]";
    public static final String TYPE_LIST_TYPE = "ListType";

    public MethodParameter(Type type, String className, String value) {
        this._type = type;
        this._className = className;
        if (value != null) {
            if (type != null && LogRegistry.getInstance().logInfos() && value.indexOf("${") >= 0) {
                LogRegistry.getInstance().info(this.getClass(), "caution var is used in constructor translate it in bean:" + value);
            }
            this._value = value;
        }
    }

    private Color createColor(String rgbValues) {
        Color color;
        StringTokenizer st = new StringTokenizer(rgbValues, ",");
        if (st.countTokens() != 3) {
            color = Color.black;
        } else {
            int r = new Integer(st.nextToken());
            int g = new Integer(st.nextToken());
            int b = new Integer(st.nextToken());
            color = new Color(r, g, b);
        }
        return color;
    }

    private Object createIntArray(String intArrayString) {
        StringTokenizer st = new StringTokenizer(intArrayString, ",");
        int[] intArray = new int[st.countTokens()];
        int counter = 0;
        while (st.hasMoreElements()) {
            String intString = st.nextToken();
            intArray[counter] = new Integer(intString);
            ++counter;
        }
        return intArray;
    }

    public static String[] createStringArray(String stringArrayString) {
        String[] stringArray = StringUtil.splitString(stringArrayString, ",", ",,");
        for (int s = 0; s < stringArray.length; ++s) {
            stringArray[s] = StringUtil.replace(stringArray[s], ",,", ",");
        }
        return stringArray;
    }

    public Class getParameterClass() {
        if (this._className != null) {
            if (this._className.equals(TYPE_BOOLEAN)) {
                return Boolean.class;
            }
            if (this._className.equals(TYPE_BOOLEAN_PRIMITIVE)) {
                return Boolean.TYPE;
            }
            if (this._className.equals(TYPE_STRING)) {
                return String.class;
            }
            if (this._className.equals(TYPE_STRING_ARRAY)) {
                return String;.class;
            }
            if (this._className.equals(TYPE_INTEGER)) {
                return Integer.class;
            }
            if (this._className.equals(TYPE_INTEGER_PRIMITIVE)) {
                return Integer.TYPE;
            }
            if (this._className.equals(TYPE_INT_ARRAY)) {
                return [I.class;
            }
            if (this._className.equals(TYPE_INTEGER_ARRAY)) {
                return Integer;.class;
            }
            if (this._className.equals(TYPE_COLOR)) {
                return Color.class;
            }
            if (this._className.equals(TYPE_VISUALIZER)) {
                return Visualizer.class;
            }
            if (this._className.equals(TYPE_TYPE)) {
                return Type.class;
            }
            if (this._className.equals(TYPE_SIMPLE_TYPE)) {
                return SimpleType.class;
            }
            if (this._className.equals(TYPE_URL)) {
                return URL.class;
            }
            if (this._className.equals(TYPE_TYPE_ARRAY)) {
                return Type;.class;
            }
            if (this._className.equals(TYPE_LIST_TYPE)) {
                return ListType.class;
            }
        }
        return null;
    }

    public static String removePackages(String className) {
        if (className == null) {
            return null;
        }
        String cutClassName = "";
        StringTokenizer tokenizer = new StringTokenizer(className, ".");
        while (tokenizer.hasMoreTokens()) {
            String tempClassName = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) continue;
            cutClassName = tempClassName;
            if (!className.startsWith("[")) continue;
            cutClassName = TextTools.replace(tempClassName, ";", "") + "[]";
        }
        return cutClassName;
    }

    public static String convertParameterClassToExternal(String param) {
        if (param != null) {
            if (param.equals(MethodParameter.removePackages(Boolean.class.getName()))) {
                return TYPE_BOOLEAN;
            }
            if (param.equals(MethodParameter.removePackages(Boolean.TYPE.getName()))) {
                return TYPE_BOOLEAN_PRIMITIVE;
            }
            if (param.equals(MethodParameter.removePackages(String.class.getName()))) {
                return TYPE_STRING;
            }
            if (param.equals(MethodParameter.removePackages(String;.class.getName()))) {
                return TYPE_STRING_ARRAY;
            }
            if (param.equals(MethodParameter.removePackages(Integer.class.getName()))) {
                return TYPE_INTEGER;
            }
            if (param.equals(MethodParameter.removePackages(Integer.TYPE.getName()))) {
                return TYPE_INTEGER_PRIMITIVE;
            }
            if (param.equals(MethodParameter.removePackages([I.class.getName()))) {
                return TYPE_INT_ARRAY;
            }
            if (param.equals(MethodParameter.removePackages(Integer;.class.getName()))) {
                return TYPE_INTEGER_ARRAY;
            }
            if (param.equals(MethodParameter.removePackages(Color.class.getName()))) {
                return TYPE_COLOR;
            }
            if (param.equals(MethodParameter.removePackages(Visualizer.class.getName()))) {
                return TYPE_VISUALIZER;
            }
            if (param.equals(MethodParameter.removePackages(Type.class.getName()))) {
                return TYPE_TYPE;
            }
            if (param.equals(MethodParameter.removePackages(SimpleType.class.getName()))) {
                return TYPE_SIMPLE_TYPE;
            }
            if (param.equals(MethodParameter.removePackages(URL.class.getName()))) {
                return TYPE_URL;
            }
            if (param.equals(MethodParameter.removePackages(Type;.class.getName()))) {
                return TYPE_TYPE_ARRAY;
            }
            if (param.equals(MethodParameter.removePackages(Component.class.getName()))) {
                return TYPE_VISUALIZER;
            }
            return param;
        }
        return param;
    }

    public Object getParameterValue() {
        return this.getParameterValue(null);
    }

    public Object getParameterValue(Type type) {
        Object returnValue = null;
        if (this._className != null) {
            if (this._value != null) {
                if (this._className.equals(TYPE_BOOLEAN)) {
                    returnValue = new Boolean(this._value);
                } else if (this._className.equals(TYPE_BOOLEAN_PRIMITIVE)) {
                    returnValue = new Boolean(this._value);
                } else if (this._className.equals(TYPE_STRING_ARRAY)) {
                    returnValue = MethodParameter.createStringArray(this._value);
                } else if (this._className.equals(TYPE_STRING)) {
                    returnValue = this._value.equals("$xpath") ? this._type.getXPathLocation() : (this._value.equals("NULL") ? null : new String(this._value));
                } else if (this._className.equals(TYPE_INTEGER)) {
                    returnValue = new Integer(this._value);
                } else if (this._className.equals(TYPE_INTEGER_PRIMITIVE)) {
                    returnValue = new Integer(this._value);
                } else if (this._className.equals(TYPE_INT_ARRAY)) {
                    returnValue = this.createIntArray(this._value);
                } else if (this._className.equals(TYPE_COLOR)) {
                    returnValue = this.createColor(this._value);
                } else if (this._className.equals(TYPE_VISUALIZER)) {
                    returnValue = this.getVisualizer(this._value, type);
                } else if (this._className.equals(TYPE_TYPE)) {
                    returnValue = this.getType(this._value, type);
                } else if (this._className.equals(TYPE_SIMPLE_TYPE)) {
                    returnValue = this.getSimpleType(this._value, type);
                } else if (this._className.equals(TYPE_TYPE_ARRAY)) {
                    returnValue = this.getTypeArray(this._value, type);
                } else if (this._className.equals(TYPE_URL)) {
                    returnValue = URLHelper.getUserURL(this._value);
                } else if (this._className.equals(TYPE_LIST_TYPE)) {
                    returnValue = this.getType(this._value, type);
                }
            } else if (this._className.equals(TYPE_BOOLEAN)) {
                returnValue = Boolean.FALSE;
            } else if (this._className.equals(TYPE_BOOLEAN_PRIMITIVE)) {
                returnValue = Boolean.FALSE;
            } else if (this._className.equals(TYPE_STRING_ARRAY)) {
                returnValue = new String[]{};
            } else if (this._className.equals(TYPE_STRING)) {
                returnValue = new String("");
            } else if (this._className.equals(TYPE_INTEGER)) {
                returnValue = new Integer(0);
            } else if (this._className.equals(TYPE_INTEGER_PRIMITIVE)) {
                returnValue = new Integer(0);
            } else if (this._className.equals(TYPE_INT_ARRAY)) {
                returnValue = new int[0];
            } else if (this._className.equals(TYPE_COLOR)) {
                returnValue = Color.black;
            } else if (this._className.equals(TYPE_TYPE)) {
                returnValue = null;
            } else if (this._className.equals(TYPE_LIST_TYPE)) {
                returnValue = null;
            }
        }
        return returnValue;
    }

    private SimpleType getSimpleType(String xpath, Type type) {
        return (SimpleType)this.getType(xpath, type);
    }

    private Type getType(String xpath, Type type) {
        List list;
        if (type == null) {
            type = this._type;
        }
        if (xpath != null && xpath.length() > 0 && (list = TypePathExecuter.getInstance().processXPath(type, xpath, false, true)).size() > 0) {
            return (Type)list.get(0);
        }
        return null;
    }

    private Type[] getTypeArray(String xpath, Type type) {
        List found = this._type.getDOM().getTypes(xpath, type);
        Iterator iterator = found.iterator();
        Type[] types = new Type[found.size()];
        int counter = 0;
        while (iterator.hasNext()) {
            types[counter] = (Type)iterator.next();
            ++counter;
        }
        return types;
    }

    private Visualizer getVisualizer(String xpath, Type type) {
        return TypeVisualizerFactory.getInstance().getVisualizer(this.getType(xpath, type));
    }
}

