/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.schema.impl;

import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.SchemaComplexType;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.schema.impl.SchemaComplexTypeImpl;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.ComplexGroup;
import com.jaxfront.core.type.ComplexGroupList;
import com.jaxfront.core.type.SimpleGroup;
import com.jaxfront.core.type.SimpleGroupList;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.SimpleTypeList;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypeComparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;

public class TreeWalkingElementAnalyser {
    private SchemaNode _context;
    private Vector _currentTypesToResolve;
    private Stack _callStack;
    private short[] _id;
    private boolean _isAnalysingGlobalType = false;
    private TreeMap _levelTree;
    private Hashtable _instanceCounter;
    private static final String SIMPLE_TYPE = "com.jaxfront.core.type.SimpleType";
    private static final String COMPLEX_GROUP = "com.jaxfront.core.type.ComplexGroup";
    private static final String COMPLEX_GROUP_LIST = "com.jaxfront.core.type.ComplexGroupList";
    private static final String SIMPLE_GROUP_LIST = "com.jaxfront.core.type.SimpleGroupList";

    public TreeWalkingElementAnalyser(SchemaNode schemaElement) {
        this.setContext(schemaElement);
        this.init();
    }

    void addCurrentTypeToResolve(SchemaNode schemaElement) {
        if (schemaElement.isGlobal()) {
            String name = schemaElement.getQName();
            this.getCurrentTypesToResolve().add(name);
        } else if (schemaElement.getRefName() != null && schemaElement.isReferenceWithNoExtension()) {
            this.getCurrentTypesToResolve().add(SchemaComplexTypeImpl.createQName(schemaElement.getTargetNS(), schemaElement.getRefName()));
        }
    }

    Type analyse() {
        return this.analyse(false);
    }

    Type analyse(boolean hasRecursion) {
        Vector smartTypes = this.getRelevantTypes();
        int smartTypeCount = smartTypes.size();
        AbstractType newType = null;
        boolean isAbstract = this._context.getSchemaType().isAbstract();
        if (LogRegistry.getInstance().logInfos()) {
            LogRegistry.getInstance().info(this.getClass(), "ANALYSE: " + this._context.getName() + " --> " + smartTypes.size() + "; " + this.printId(this.getCurrentId()));
        }
        if (this._context.getMaxOccurs() > 1 || this._context.getMaxOccurs() == -1) {
            if (hasRecursion || isAbstract) {
                ComplexGroup complexGroup = new ComplexGroup(this._context, smartTypes);
                newType = new ComplexGroupList(this._context, complexGroup);
            } else if (smartTypeCount == 1) {
                Type firstElement = (Type)smartTypes.firstElement();
                if (firstElement.isSimple()) {
                    if (firstElement.isAttribute() || this._context.getSchemaType().isEmptyComplexType()) {
                        SimpleGroup sg = new SimpleGroup(this._context, smartTypes);
                        newType = new SimpleGroupList(this._context, sg);
                    } else if (!firstElement.getName().equals(this._context.getName())) {
                        SimpleGroup sg = new SimpleGroup(this._context, smartTypes);
                        newType = new SimpleGroupList(this._context, sg);
                    } else {
                        newType = new SimpleTypeList(this._context, firstElement);
                    }
                } else if (firstElement.getTypeClassification() == 66) {
                    ComplexGroup editingType = new ComplexGroup(this._context, smartTypes);
                    newType = new ComplexGroupList(this._context, editingType);
                } else if (firstElement.getTypeClassification() == 193) {
                    ComplexGroup editingType = new ComplexGroup(this._context, smartTypes);
                    newType = new ComplexGroupList(this._context, editingType);
                } else if (firstElement.getTypeClassification() == 194) {
                    ComplexGroup editingType = new ComplexGroup(this._context, smartTypes);
                    newType = new ComplexGroupList(this._context, editingType);
                } else if (firstElement.getTypeClassification() == 128) {
                    SimpleGroup editingType = new SimpleGroup(this._context, smartTypes);
                    newType = new SimpleGroupList(this._context, editingType);
                } else if (firstElement.getTypeClassification() == 65) {
                    SimpleGroup editingType = new SimpleGroup(this._context, smartTypes);
                    newType = new SimpleGroupList(this._context, editingType);
                }
            } else if (smartTypeCount == 0) {
                if (this._context.getSchemaType().isEmptyComplexType()) {
                    SimpleGroup sg = new SimpleGroup(this._context, smartTypes);
                    newType = new SimpleGroupList(this._context, sg);
                } else {
                    SimpleType simpleType = new SimpleType(this._context);
                    newType = new SimpleTypeList(this._context, simpleType);
                }
            } else if (this.areAllSimpleTypes(smartTypes)) {
                Vector newList = new Vector();
                newList.addAll(smartTypes);
                SimpleGroup group = new SimpleGroup(this._context, newList);
                newType = new SimpleGroupList(this._context, group);
            } else {
                ComplexGroup complexGroup = new ComplexGroup(this._context, smartTypes);
                newType = new ComplexGroupList(this._context, complexGroup);
            }
        } else if (hasRecursion || isAbstract) {
            newType = new ComplexGroup(this._context, smartTypes);
        } else if (smartTypeCount == 0) {
            newType = this._context.getSchemaType().isEmptyComplexType() ? new SimpleGroup(this._context, smartTypes) : new SimpleType(this._context);
        } else if (this.isComplexGroup()) {
            newType = new ComplexGroup(this._context, smartTypes);
        } else {
            Vector newList = new Vector(smartTypes);
            newType = new SimpleGroup(this._context, newList);
        }
        newType.setId(this.getCurrentId());
        this.put(this._context, newType);
        this._context.getSchemaType().setType(newType);
        return newType;
    }

    public Vector analyseAttributes() {
        if (!(this._context.getSchemaType() instanceof SchemaComplexType)) {
            return null;
        }
        Vector<SimpleType> smartTypes = new Vector<SimpleType>();
        SchemaNode[] attributes = ((SchemaComplexType)this._context.getSchemaType()).getAttributeSet();
        if (attributes != null && attributes.length > 0) {
            for (int i = 0; i < attributes.length; ++i) {
                SimpleType simpleType = new SimpleType(attributes[i]);
                simpleType.setIsAttribute(true);
                this.increaseCounter();
                simpleType.setId(this.getCurrentId());
                smartTypes.add(simpleType);
            }
        }
        Iterator iterator = smartTypes.iterator();
        Type smartType = null;
        while (iterator.hasNext()) {
            smartType = (Type)iterator.next();
            this.getLevelTree().put(smartType.getId(), smartType);
        }
        return smartTypes;
    }

    private boolean areAllSimpleTypes(List smartTypes) {
        for (int i = 0; i < smartTypes.size(); ++i) {
            if (((Type)smartTypes.get(i)).getTypeClassification() == 128 || ((Type)smartTypes.get(i)).isSimple()) continue;
            return false;
        }
        return true;
    }

    boolean containsCurrentTypeToResolve(SchemaNode schemaElement) {
        boolean hasExtension = schemaElement.isReferenceWithNoExtension();
        if (schemaElement.isGlobal()) {
            return this.getCurrentTypesToResolve().contains(schemaElement.getQName());
        }
        if (schemaElement.getRefName() != null && this.getCurrentTypesToResolve().contains(schemaElement.getRefName())) {
            return true;
        }
        if (schemaElement.isReferenceToGlobalType() && schemaElement.getNode().getType() == 2) {
            XSComplexTypeDecl xsdTypeDecl = (XSComplexTypeDecl)((XSElementDecl)schemaElement.getNode()).getTypeDefinition();
            String ns = xsdTypeDecl.getNamespace();
            String name = xsdTypeDecl.getName();
            if (name != null) {
                return this.getCurrentTypesToResolve().contains((ns == null ? "" : ns + ":") + name);
            }
        }
        return false;
    }

    public Vector getCurrentTypesToResolve() {
        if (this._currentTypesToResolve == null) {
            this._currentTypesToResolve = new Vector();
        }
        return this._currentTypesToResolve;
    }

    public void resetCurrentTypesToResolve() {
        this._currentTypesToResolve = new Vector();
    }

    public void setCurrentTypesToResolve(Vector types) {
        this._currentTypesToResolve = types;
    }

    private Hashtable getInstanceCounter() {
        if (this._instanceCounter == null) {
            this._instanceCounter = new Hashtable();
        }
        return this._instanceCounter;
    }

    private TreeMap getLevelTree() {
        if (this._levelTree == null) {
            this._levelTree = new TreeMap(new TypeComparator());
        }
        return this._levelTree;
    }

    private Vector getRelevantTypes() {
        Vector types = new Vector();
        Set aEntrySet = this.getLevelTree().entrySet();
        Iterator iterator = aEntrySet.iterator();
        int es = aEntrySet.size();
        int currentLevel = this.getCurrentId().length;
        for (int i = 0; i < es; ++i) {
            Map.Entry aEntry = iterator.next();
            short[] key = (short[])aEntry.getKey();
            int keyLevel = key.length;
            if (keyLevel != currentLevel + 1 || !this.startsWith(key, this.getCurrentId())) continue;
            types.add(aEntry.getValue());
        }
        return types;
    }

    private void handleInstanceCounter(Type smartType) {
        int counter = 0;
        if (this.getInstanceCounter().get(smartType.getClass().getName()) != null) {
            counter = (Integer)this.getInstanceCounter().get(smartType.getClass().getName());
        }
        this.getInstanceCounter().put(smartType.getClass().getName(), new Integer(++counter));
    }

    private void handleInstanceCounter(List smartTypes) {
        this.getInstanceCounter().clear();
        Iterator iterator = smartTypes.iterator();
        while (iterator.hasNext()) {
            this.handleInstanceCounter((Type)iterator.next());
        }
    }

    short[] getCurrentId() {
        return this._id;
    }

    private boolean isComplexGroup() {
        this.handleInstanceCounter(this.getRelevantTypes());
        int complexGroupListCounter = 0;
        int complexGroupCounter = 0;
        if (this.getInstanceCounter().get(COMPLEX_GROUP_LIST) != null) {
            complexGroupListCounter = (Integer)this.getInstanceCounter().get(COMPLEX_GROUP_LIST);
        }
        if (this.getInstanceCounter().get(SIMPLE_GROUP_LIST) != null) {
            complexGroupListCounter = (Integer)this.getInstanceCounter().get(SIMPLE_GROUP_LIST);
        }
        if (this.getInstanceCounter().get(COMPLEX_GROUP) != null) {
            complexGroupCounter = (Integer)this.getInstanceCounter().get(COMPLEX_GROUP);
        }
        return complexGroupCounter > 0 || complexGroupListCounter > 0;
    }

    void put(SchemaNode element, Type type) {
        this.getLevelTree().put(type.getId(), type);
    }

    void removeCurrentTypeToResolve(SchemaNode schemaElement) {
        if (schemaElement.isGlobal()) {
            this.getCurrentTypesToResolve().remove(schemaElement.getQName());
        } else if (schemaElement.getRefName() != null) {
            this.getCurrentTypesToResolve().remove(SchemaComplexTypeImpl.createQName(schemaElement.getTargetNS(), schemaElement.getRefName()));
        }
    }

    void setContext(SchemaNode schemaElement) {
        this._context = schemaElement;
    }

    public String toString() {
        return "ContextTreeWalkingElement: " + this._context.getQName() + "\n" + "AnalyserXPath: " + this.printId(this.getCurrentId());
    }

    void decreaseLevel() {
        if (this.getCurrentId().length >= 1) {
            int cLen = this.getCurrentId().length - 1;
            short[] tid = new short[cLen];
            System.arraycopy(this.getCurrentId(), 0, tid, 0, cLen);
            this.setCurrentId(tid);
        }
    }

    private void setCurrentId(short[] sId) {
        this._id = sId;
    }

    public static short[] increaseArray(short[] values) {
        int cLen = values.length;
        short[] tid = new short[values.length];
        System.arraycopy(values, 0, tid, 0, cLen);
        short cCV = tid[cLen - 1];
        tid[cLen - 1] = cCV = (short)(cCV + 1);
        return tid;
    }

    public boolean startsWith(short[] source, short[] width) {
        boolean result = false;
        if (source.length >= width.length) {
            for (int w = 0; w < width.length; ++w) {
                if (width[w] != source[w]) {
                    result = false;
                    break;
                }
                result = true;
            }
        }
        return result;
    }

    public Stack getCallStack() {
        if (this._callStack == null) {
            this._callStack = new Stack();
        }
        return this._callStack;
    }

    public String printId(short[] id) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < id.length; ++i) {
            result.append(id[i] + "_");
        }
        return result.toString();
    }

    synchronized void increaseCounter() {
        this.setCurrentId(TreeWalkingElementAnalyser.increaseArray(this.getCurrentId()));
    }

    void increaseLevel() {
        this.setCurrentId(TreeWalkingElementAnalyser.addLevel(this.getCurrentId()));
    }

    static short[] addLevel(short[] source) {
        int cLen = source.length;
        short[] tid = new short[cLen + 1];
        System.arraycopy(source, 0, tid, 0, cLen);
        tid[cLen] = 1;
        return tid;
    }

    static short[] removeLevel(short[] source) {
        int cLen = source.length - 1;
        short[] tid = new short[cLen];
        System.arraycopy(source, 0, tid, 0, cLen);
        return tid;
    }

    private void init() {
        this.setCurrentId(new short[]{1, 1});
    }

    public void setIsAnalysingGlobalType(boolean isAnalysingGlobalType) {
        this._isAnalysingGlobalType = isAnalysingGlobalType;
    }

    public boolean isAnalysingGlobalType() {
        return this._isAnalysingGlobalType;
    }
}

