/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.schema.impl;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.keyRef.KeyContextWrapper;
import com.jaxfront.core.keyRef.KeyKeyRefManager;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.KeyRefException;
import com.jaxfront.core.schema.SchemaKey;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.schema.ValidationException;
import com.jaxfront.core.type.EmptyType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.xpath.XPathExecuterImpl;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class KeyContainer {
    public static final Type[] _defaultContext = new Type[0];
    public static final Type[] _wrongContext = new Type[0];
    public static final KeyContextWrapper _defaultContextWrapper = new KeyContextWrapper(_defaultContext);
    public static final KeyContextWrapper _globalContextWrapper = new KeyContextWrapper(_defaultContext);
    Hashtable _keys = new Hashtable();
    Hashtable _keyRefs = new Hashtable();
    KeyContextWrapper _context = null;
    String _keyName = null;
    SchemaKey _schemaKey = null;
    ListType _holderList;
    int _lastUniqueID = -1;
    private Document _dom;

    protected KeyContainer(String keyName) {
        this._keyName = keyName;
    }

    public KeyContainer(String keyName, SchemaKey schemaKey, Document document) {
        this(keyName);
        this._schemaKey = schemaKey;
        this._dom = document;
    }

    public static Type[] createContext(Type startType, SchemaNode schemaElement) {
        Type[] context = _defaultContext;
        Type contextStart = null;
        while (startType != null && startType.getSchemaElement() != schemaElement) {
            startType = startType.getParent();
        }
        contextStart = startType;
        if (startType != null) {
            while (startType.getParent() != null) {
                Type parent = startType.getParent();
                if (parent.isList()) {
                    context = ArrayUtil.addToArray(context, startType);
                }
                startType = parent;
            }
        } else {
            context = _wrongContext;
        }
        return context;
    }

    public SchemaKey getSchemaKey() {
        return this._schemaKey;
    }

    public static boolean isSelectorParentByXPath(SchemaKey sKey, Type type) {
        String[] normalizedSelectorXPath = sKey.getNormalizedSelectorXPath();
        for (int n = 0; n < normalizedSelectorXPath.length; ++n) {
            Type upType = DOMHelper.walkNormalizedXpathUp(normalizedSelectorXPath[n], type);
            if (upType == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isSelectorRefParent(SchemaKey sKey, SchemaNode schemaParent, Type type) {
        return KeyContainer.isSelectorKeyParent(sKey, schemaParent, type);
    }

    public static boolean isSelectorKeyParent(SchemaKey sKey, SchemaNode schemaParent, Type type) {
        if (type.getSchemaElement().getSchemaType() == schemaParent.getSchemaType()) {
            return KeyContainer.isSelectorParentByXPath(sKey, type);
        }
        Type parentType = type;
        while ((parentType = parentType.getParent()) != null) {
            if (parentType.getSchemaElement().getSchemaType() != schemaParent.getSchemaType()) continue;
            return KeyContainer.isSelectorParentByXPath(sKey, type);
        }
        return false;
    }

    public static boolean isSelectorParent(SchemaNode schemaParent, Type type) {
        if (type.getSchemaElement().getSchemaType() == schemaParent.getSchemaType()) {
            return true;
        }
        Type parentType = type;
        while ((parentType = parentType.getParent()) != null) {
            if (parentType.getSchemaElement().getSchemaType() != schemaParent.getSchemaType()) continue;
            return true;
        }
        return false;
    }

    public static Type getSelectorParent(SchemaNode schemaParent, Type type) {
        if (type.getSchemaElement() == schemaParent) {
            return type;
        }
        Type parentType = type;
        while ((parentType = parentType.getParent()) != null) {
            if (parentType.getSchemaElement() != schemaParent) continue;
            return parentType;
        }
        return null;
    }

    public static Type getFirstSelectorChild(SchemaNode schemaParent, Type type) {
        if (type.getSchemaElement() == schemaParent) {
            return type;
        }
        Type parentType = type;
        Type oldChildType = type;
        while ((parentType = parentType.getParent()) != null) {
            if (parentType.getSchemaElement() == schemaParent) {
                return oldChildType;
            }
            if (parentType.isList()) continue;
            oldChildType = parentType;
        }
        return null;
    }

    public void addKeyType(SimpleType type) throws KeyRefException {
        this.addKeyType(type, false);
    }

    public void addKeyType(SimpleType type, boolean createID) throws KeyRefException {
        String value = type.getPlainValue();
        if (value == null && createID) {
            type.setValue(this.getClass(), this.createUniqueID(), false, true);
        }
        if (!this._keys.contains(type)) {
            this._keys.put(type, new ArrayList());
        } else if (LogRegistry.getInstance().logWarnings()) {
            LogRegistry.getInstance().warn(this.getClass(), "key already registered for:" + type.getXPathLocation() + " with value:" + type.getPlainValue());
        }
    }

    public void addKeyRefType(String refName, SimpleType type) {
        Hashtable<SimpleType, EmptyType> refsForRefName = (Hashtable<SimpleType, EmptyType>)this._keyRefs.get(refName);
        if (refsForRefName == null) {
            refsForRefName = new Hashtable<SimpleType, EmptyType>();
            this._keyRefs.put(refName, refsForRefName);
        }
        EmptyType referencedKeyType = KeyKeyRefManager.DUMMY_KEY_TYPE;
        refsForRefName.put(type, referencedKeyType);
    }

    public void removeKeyType(SimpleType type) throws KeyRefException {
        this.removeKeyType(type, false);
    }

    public void removeKeyType(SimpleType type, boolean force) throws KeyRefException {
        this.removeKeyType(null, type, force);
    }

    public void removeKeyType(Type deletionStart, SimpleType type, boolean force) throws KeyRefException {
        if (!force) {
            Vector<SimpleType> openKeyReferences = new Vector<SimpleType>();
            Iterator keyRefHashEntries = this._keyRefs.values().iterator();
            while (keyRefHashEntries.hasNext()) {
                Hashtable refsHash = (Hashtable)keyRefHashEntries.next();
                Enumeration refEntries = refsHash.keys();
                while (refEntries.hasMoreElements()) {
                    SimpleType element = (SimpleType)refEntries.nextElement();
                    if (type.getPlainValue() == null || !type.getPlainValue().equals(element.getPlainValue())) continue;
                    if (deletionStart == null) {
                        openKeyReferences.add(element);
                        continue;
                    }
                    if (element.isDerivedFrom(deletionStart)) continue;
                    openKeyReferences.add(element);
                }
            }
            if (openKeyReferences.size() > 0) {
                throw new KeyRefException("can't remove key", openKeyReferences);
            }
        }
        this._keys.remove(type);
    }

    public boolean isKeyTypeRemoveable(Type deletionStart, SimpleType type) throws KeyRefException {
        Vector<SimpleType> openKeyReferences = new Vector<SimpleType>();
        Iterator keyRefHashEntries = this._keyRefs.values().iterator();
        while (keyRefHashEntries.hasNext()) {
            Hashtable refsHash = (Hashtable)keyRefHashEntries.next();
            Enumeration refEntries = refsHash.keys();
            while (refEntries.hasMoreElements()) {
                SimpleType element = (SimpleType)refEntries.nextElement();
                if (type.getPlainValue() == null || !type.getPlainValue().equals(element.getPlainValue())) continue;
                if (deletionStart == null) {
                    openKeyReferences.add(element);
                    continue;
                }
                if (element.isDerivedFrom(deletionStart)) continue;
                openKeyReferences.add(element);
            }
            if (openKeyReferences.size() <= 0) continue;
            throw new KeyRefException("can't remove key", openKeyReferences);
        }
        return true;
    }

    public void removeKeyRefType(String refName, SimpleType type) {
        Hashtable refsForRefName = (Hashtable)this._keyRefs.get(refName);
        if (refsForRefName != null) {
            Type referencedKeyType = (Type)refsForRefName.remove(type);
            if (refsForRefName.size() == 0) {
                this._keyRefs.remove(refName);
            }
        }
    }

    public List getKeyTypes() {
        Vector<SimpleType> result = new Vector<SimpleType>(this._keys.size());
        Iterator it = this._keys.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry aEntry = it.next();
            SimpleType st = (SimpleType)aEntry.getKey();
            if (st.unChoosenBranch()) continue;
            result.add(st);
        }
        return result;
    }

    public Type getKeyTypeForValue(String value) {
        Iterator it = this._keys.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry aEntry = it.next();
            SimpleType st = (SimpleType)aEntry.getKey();
            if (st.getPlainValue() != value && (st.getPlainValue() == null || !st.getPlainValue().equals(value)) || st.unChoosenBranch()) continue;
            return st;
        }
        return null;
    }

    public List getKeyTypesForValue(String value) {
        Vector<SimpleType> result = new Vector<SimpleType>(2);
        Iterator it = this._keys.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry aEntry = it.next();
            SimpleType st = (SimpleType)aEntry.getKey();
            if (st.getPlainValue() != value && (st.getPlainValue() == null || !st.getPlainValue().equals(value)) || st.unChoosenBranch()) continue;
            result.add(st);
        }
        return result;
    }

    public boolean isKeyRemovable(Type deletionStart, SimpleType type) {
        Vector<SimpleType> openKeyReferences = new Vector<SimpleType>();
        Iterator keyRefHashEntries = this._keyRefs.values().iterator();
        while (keyRefHashEntries.hasNext()) {
            Hashtable refsHash = (Hashtable)keyRefHashEntries.next();
            Iterator refEntries = refsHash.values().iterator();
            while (refEntries.hasNext()) {
                SimpleType element = (SimpleType)refEntries.next();
                if (type.getPlainValue() == null || !type.getPlainValue().equals(element.getPlainValue()) || element.unChoosenBranch()) continue;
                if (deletionStart == null) {
                    openKeyReferences.add(element);
                    continue;
                }
                if (element.isDerivedFrom(deletionStart)) continue;
                openKeyReferences.add(element);
            }
        }
        return openKeyReferences.size() > 0;
    }

    public boolean keyValueExist(String value) {
        Iterator it = this._keys.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry aEntry = it.next();
            SimpleType st = (SimpleType)aEntry.getKey();
            if (!st.getPlainValue().equals(value) || st.unChoosenBranch()) continue;
            return true;
        }
        return false;
    }

    public boolean areAllKeysValid() throws KeyRefException {
        Vector<ValidationException> doubleKeys = new Vector<ValidationException>();
        Hashtable<String, SimpleType> allKeyValuesCache = new Hashtable<String, SimpleType>(this._keys.size());
        Iterator it = this._keys.entrySet().iterator();
        while (it.hasNext()) {
            SimpleType oldKey;
            Map.Entry aEntry = it.next();
            SimpleType st = (SimpleType)aEntry.getKey();
            String value = st.getPlainValue();
            if (value == null || st.unChoosenBranch() || (oldKey = allKeyValuesCache.put(value, st)) == null) continue;
            doubleKeys.add(ValidationException.createDuplicateKeyException(st, value));
            doubleKeys.add(ValidationException.createDuplicateKeyException(oldKey, value));
        }
        if (doubleKeys.size() > 0) {
            throw new KeyRefException("ambiguous keys found in:" + this._keyName, doubleKeys);
        }
        return true;
    }

    public List getReleased() throws KeyRefException {
        Iterator it = this._keys.entrySet().iterator();
        Vector<SimpleType> released = new Vector<SimpleType>();
        while (it.hasNext()) {
            Map.Entry aEntry = it.next();
            SimpleType st = (SimpleType)aEntry.getKey();
            if (!st.isReleased()) continue;
            released.add(st);
        }
        return released;
    }

    public boolean areAllReferencesValid() throws KeyRefException {
        Hashtable<String, SimpleType> allKeyValuesCache = new Hashtable<String, SimpleType>(this._keys.size());
        Iterator it = this._keys.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry aEntry = it.next();
            SimpleType st = (SimpleType)aEntry.getKey();
            String value = st.getPlainValue();
            if (value == null || st.unChoosenBranch()) continue;
            allKeyValuesCache.put(value, st);
        }
        Vector<ValidationException> missingKeyReferences = new Vector<ValidationException>();
        Iterator keyRefHashEntries = this._keyRefs.values().iterator();
        while (keyRefHashEntries.hasNext()) {
            Hashtable refsHash = (Hashtable)keyRefHashEntries.next();
            Iterator refEntries = refsHash.entrySet().iterator();
            while (refEntries.hasNext()) {
                Map.Entry aEntry = refEntries.next();
                Object refObject = aEntry.getKey();
                SimpleType element = (SimpleType)refObject;
                String refKeyValue = element.getPlainValue();
                if (refKeyValue == null || element.unChoosenBranch() || allKeyValuesCache.containsKey(refKeyValue)) continue;
                missingKeyReferences.add(ValidationException.createMissingKeyException(element, refKeyValue));
            }
        }
        if (missingKeyReferences.size() > 0) {
            throw new KeyRefException("Keyref without valid key:" + this._keyName, missingKeyReferences);
        }
        return true;
    }

    public String createUniqueID() {
        int highestID = -1;
        if (this._keys.size() > 0) {
            Iterator it = this._keys.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry aEntry = it.next();
                SimpleType st = (SimpleType)aEntry.getKey();
                String id = st.getPlainValue();
                if (id == null || id.length() <= 0) continue;
                try {
                    int tempID;
                    if (!StringUtil.isNumeric(id) || (tempID = Integer.parseInt(id)) <= highestID) continue;
                    highestID = tempID;
                }
                catch (NumberFormatException ex) {
                    if (!LogRegistry.getInstance().logWarnings()) continue;
                    LogRegistry.getInstance().warn(this.getClass(), "Could not set the list item id index properly!");
                }
            }
        }
        if (++highestID > this._lastUniqueID) {
            this._lastUniqueID = highestID;
        }
        return String.valueOf(this._lastUniqueID);
    }

    public String getKeyName() {
        return this._keyName;
    }

    public List getAllReferences() {
        Vector<SimpleType> references = new Vector<SimpleType>();
        Iterator keyRefHashEntries = this._keyRefs.values().iterator();
        while (keyRefHashEntries.hasNext()) {
            Hashtable refsHash = (Hashtable)keyRefHashEntries.next();
            Enumeration refEntries = refsHash.keys();
            while (refEntries.hasMoreElements()) {
                SimpleType element = (SimpleType)refEntries.nextElement();
                if (element.unChoosenBranch()) continue;
                references.add(element);
            }
        }
        return references;
    }

    public Vector getAllReferencesFor(String value) {
        Vector<SimpleType> references = new Vector<SimpleType>();
        Iterator keyRefHashEntries = this._keyRefs.values().iterator();
        while (keyRefHashEntries.hasNext()) {
            Hashtable refsHash = (Hashtable)keyRefHashEntries.next();
            Enumeration refEntries = refsHash.keys();
            while (refEntries.hasMoreElements()) {
                SimpleType element = (SimpleType)refEntries.nextElement();
                String refKeyValue = element.getPlainValue();
                if (refKeyValue == null || !refKeyValue.equals(value) || element.unChoosenBranch()) continue;
                if (references.contains(element) && JAXFrontProperties.LOG_ENABLED) {
                    LogRegistry.getInstance().error(this.getClass(), "can't have two equal types with keyrefs!");
                }
                references.add(element);
            }
        }
        return references;
    }

    public void getInfo(StringBuffer info, boolean details) {
        info.append(StringUtil.newLine);
        info.append("Info for:");
        info.append(this.getKeyName());
        if (this.getContext() != null) {
            info.append(" Context:" + this.getContext().toString());
        }
        info.append(" schemaXP:" + this._schemaKey.getSchemaElement().getXPath() + " selectorXP:" + ArrayUtil.toString(this._schemaKey.getNormalizedSelectorXPath(), "/"));
        info.append(StringUtil.newLine);
        info.append("all Keys:" + this._keys.entrySet().size() + " ");
        if (details) {
            Iterator it = this._keys.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry aEntry = it.next();
                SimpleType st = (SimpleType)aEntry.getKey();
                if (st.unChoosenBranch()) continue;
                String value = st.getPlainValue();
                info.append(DOMHelper.createInfoXPath(st, 3, true, true));
                info.append(":");
                info.append(value);
                if (!it.hasNext()) continue;
                info.append(" - ");
            }
        }
        info.append(StringUtil.newLine);
        info.append("all KeyRefs:" + this._keyRefs.entrySet().size() + " ");
        if (details) {
            Iterator keyRefHashEntries = this._keyRefs.entrySet().iterator();
            while (keyRefHashEntries.hasNext()) {
                Map.Entry keyRefEntry = keyRefHashEntries.next();
                String keyRefName = (String)keyRefEntry.getKey();
                info.append(StringUtil.newLine);
                info.append(keyRefName + " -> ");
                Hashtable refsHash = (Hashtable)keyRefEntry.getValue();
                Iterator refEntries = refsHash.entrySet().iterator();
                while (refEntries.hasNext()) {
                    Map.Entry refEntry = refEntries.next();
                    Object refO = refEntry.getKey();
                    String refKeyValue = null;
                    SimpleType element = (SimpleType)refO;
                    if (element.unChoosenBranch()) continue;
                    refKeyValue = element.getPlainValue();
                    info.append(DOMHelper.createInfoXPath(element, 3, true, true));
                    info.append(":");
                    info.append(refKeyValue);
                    if (!refEntries.hasNext()) continue;
                    info.append(" , ");
                }
            }
        }
        info.append(StringUtil.newLine);
    }

    public void release() {
        if (this._dom != null) {
            this._dom = null;
        }
        if (this._keys != null) {
            this._keys.clear();
        }
        this._keys = null;
        if (this._keyRefs != null) {
            this._keyRefs.clear();
        }
        this._keyRefs = null;
    }

    public KeyContainer deepCloneForTest() {
        KeyContainer clone = new KeyContainer(this._keyName);
        clone._keyRefs = new Hashtable();
        clone._keys = new Hashtable();
        clone._lastUniqueID = this._lastUniqueID;
        Iterator it = this._keys.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry aEntry = it.next();
            SimpleType st = (SimpleType)aEntry.getKey();
            String value = st.getPlainValue();
            if (st.unChoosenBranch()) continue;
            value = value == null ? "null" : value;
            clone._keys.put(value, st.getXPathLocation());
        }
        Iterator keyRefHashEntries = this._keyRefs.entrySet().iterator();
        clone._keyRefs = new Hashtable();
        while (keyRefHashEntries.hasNext()) {
            Map.Entry keyRefEntry = keyRefHashEntries.next();
            String keyRefName = (String)keyRefEntry.getKey();
            Hashtable refsHash = (Hashtable)keyRefEntry.getValue();
            Hashtable<String, String> refsHashClone = new Hashtable<String, String>();
            clone._keyRefs.put(keyRefName, refsHashClone);
            Iterator refEntries = refsHash.entrySet().iterator();
            while (refEntries.hasNext()) {
                Map.Entry refEntry = refEntries.next();
                Object refO = refEntry.getKey();
                String refKeyValue = null;
                SimpleType element = (SimpleType)refO;
                if (element.unChoosenBranch()) continue;
                refKeyValue = element.getPlainValue();
                refKeyValue = refKeyValue == null ? "null" : refKeyValue;
                refsHashClone.put(refKeyValue, element.getXPathLocation());
            }
        }
        return clone;
    }

    public String isEqual(KeyContainer against) {
        StringBuffer info = new StringBuffer();
        if (!this.getKeyName().equals(against.getKeyName())) {
            info.append("keyName doesn't match:" + this.getKeyName() + "!=" + against.getKeyName());
            info.append("\n");
        }
        info.append(KeyContainer.containsAll(this.getKeyName() + " key count not equal!", this._keys, against._keys));
        Iterator it = this._keys.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry aEntry = it.next();
            String entryKey = aEntry.getKey().toString();
            if (against._keys.containsKey(entryKey)) continue;
            info.append("keyValue doesn't exist in against:" + aEntry.getKey());
            info.append("\n");
        }
        info.append(KeyContainer.containsAll(this.getKeyName() + " key ref missing:", this._keyRefs, against._keyRefs));
        Iterator refsIt = this._keyRefs.entrySet().iterator();
        while (refsIt.hasNext()) {
            Map.Entry aEntry = refsIt.next();
            String refNameKey = aEntry.getKey().toString();
            if (!against._keyRefs.containsKey(refNameKey)) {
                info.append("keyValue doesn't exist in against:" + aEntry.getKey());
                info.append("\n");
                continue;
            }
            Hashtable againstKeyRefVaueEntries = (Hashtable)against._keyRefs.get(refNameKey);
            Hashtable keyRefVaueEntries = (Hashtable)aEntry.getValue();
            info.append(KeyContainer.containsAll(refNameKey, keyRefVaueEntries, againstKeyRefVaueEntries));
        }
        return info.toString();
    }

    public static String containsAll(String name, Hashtable source, Hashtable destination) {
        StringBuffer info = new StringBuffer();
        String souceS = "source";
        if (destination.size() != source.size()) {
            if (destination.size() > source.size()) {
                info.append("destination " + name + " count not equal:" + destination.size() + " not " + source.size());
                info.append("\n");
                Hashtable temp = destination;
                destination = source;
                source = temp;
                souceS = "destination";
            } else {
                info.append("source " + name + " count not equal:" + destination.size() + " not " + source.size());
                info.append("\n");
            }
        }
        Iterator it = source.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry aEntry = it.next();
            String entryKey = aEntry.getKey().toString();
            if (destination.containsKey(entryKey)) continue;
            info.append("value doesn't exist in " + souceS + ":" + aEntry.getKey());
            info.append("\n");
        }
        return info.toString();
    }

    public void setContext(KeyContextWrapper context) {
        if (context != null) {
            Type[] contextList = context.getContext();
            for (int c = 0; c < contextList.length; ++c) {
                contextList[c].setIsKeyContext(true);
            }
        }
        this._context = context;
    }

    public ListType getHolderList() {
        if (this.getContext() != null && this.getContext() != _defaultContextWrapper) {
            Type lastCont = this.getContext().getLastContextEntry();
            if (lastCont != null) {
                Type keyType = this.evaluatePossibleKeyType(lastCont);
                if (keyType != null) {
                    this._holderList = keyType.getParentList();
                }
            } else {
                String xpath = this._schemaKey.getSchemaElement().getSchemaType().getType().getXPathLocation();
                Type baseType = TypePathExecuter.getInstance().getTypeForXPath(this._dom.getRootType(), xpath, true);
                Type keyType = this.evaluatePossibleKeyType(baseType);
                if (keyType != null) {
                    this._holderList = keyType.getParentList();
                }
            }
        } else {
            Type keyType;
            String xpath = null;
            Type baseType = null;
            if (this._schemaKey.getSchemaElement().getSchemaType().getType().isGlobal()) {
                StringBuffer xp = new StringBuffer();
                DOMHelper.getPlainXPath(this._schemaKey.getSchemaElement(), xp);
                xpath = xp.toString();
                baseType = TypePathExecuter.getInstance().getTypeForXPath(this._dom.getRootType(), xpath, true);
            } else {
                xpath = this._schemaKey.getSchemaElement().getSchemaType().getType().getXPathLocation();
                baseType = TypePathExecuter.getInstance().getTypeForXPath(this._dom.getRootType(), xpath, true);
            }
            if (baseType != null && (keyType = this.evaluatePossibleKeyType(baseType)) != null) {
                this._holderList = keyType.getParentList();
            }
        }
        return this._holderList;
    }

    public Type getPossibleKeyType() {
        Type result = null;
        if (this.getContext() != null && this.getContext() != _defaultContextWrapper) {
            Type lastCont = this.getContext().getLastContextEntry();
            if (lastCont != null) {
                result = this.evaluatePossibleKeyType(lastCont);
            } else {
                String xpath = this._schemaKey.getSchemaElement().getSchemaType().getType().getXPathLocation();
                Type baseType = TypePathExecuter.getInstance().getTypeForXPath(this._dom.getRootType(), xpath, true);
                result = this.evaluatePossibleKeyType(baseType);
            }
        } else {
            String xpath = null;
            Type baseType = null;
            if (this._schemaKey.getSchemaElement().getSchemaType().getType().isGlobal()) {
                StringBuffer xp = new StringBuffer();
                DOMHelper.getPlainXPath(this._schemaKey.getSchemaElement(), xp);
                xpath = xp.toString();
                baseType = TypePathExecuter.getInstance().getTypeForXPath(this._dom.getRootType(), xpath, true);
            } else {
                xpath = this._schemaKey.getSchemaElement().getSchemaType().getType().getXPathLocation();
                baseType = TypePathExecuter.getInstance().getTypeForXPath(this._dom.getRootType(), xpath, true);
            }
            if (baseType != null) {
                result = this.evaluatePossibleKeyType(baseType);
            }
        }
        return result;
    }

    private Type evaluatePossibleKeyType(Type baseType) {
        Type result = null;
        Type foundSelectorType = null;
        List foundSelectorTypes = null;
        try {
            foundSelectorTypes = XPathExecuterImpl.getInstance().processXPath(this.getSchemaKey().getSelectorXPath(), baseType, true, false, false, false, false, false, false);
        }
        catch (TransformerException e) {
            // empty catch block
        }
        if (foundSelectorTypes != null && foundSelectorTypes.size() > 0) {
            foundSelectorType = foundSelectorTypes.size() > 1 ? (Type)foundSelectorTypes.get(1) : (Type)foundSelectorTypes.get(0);
        }
        if (foundSelectorType != null) {
            String fieldValue = this.getSchemaKey().getFields()[0];
            Type keyType = null;
            keyType = fieldValue == null || fieldValue.length() == 0 || fieldValue.trim().equals(".") ? foundSelectorType : TypePathExecuter.getInstance().getTypeForXPath(foundSelectorType, fieldValue, true);
            result = keyType;
        }
        return result;
    }

    public KeyContextWrapper getContext() {
        return this._context;
    }
}

