/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.jep.JaxfrontMathCommand;
import com.jaxfront.core.jep.SuperTypeNode;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.util.undo.JAXFrontUndoManager;
import java.util.Stack;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.nfunk.jep.ParseException;

public class UndoRedoUIAction
extends JaxfrontMathCommand {
    public UndoRedoUIAction() {
        this.numberOfParameters = 1;
    }

    public void run(MathEvaluator.MathCommunicator communicator, Stack stack) throws ParseException {
        this.checkStack(stack);
        JAXFrontUndoManager manager = communicator.getRootType().getDOM().getUndoManager();
        String undoManagerAction = (String)stack.pop();
        Double done = SuperTypeNode.isFalse;
        if ("undo".equalsIgnoreCase(undoManagerAction)) {
            try {
                manager.undo();
                done = SuperTypeNode.isTrue;
            }
            catch (CannotUndoException e) {}
        } else if ("canUndo".equalsIgnoreCase(undoManagerAction)) {
            if (manager.canUndo()) {
                done = SuperTypeNode.isTrue;
            }
        } else if ("redo".equalsIgnoreCase(undoManagerAction)) {
            try {
                manager.redo();
                done = SuperTypeNode.isTrue;
            }
            catch (CannotRedoException e) {}
        } else if ("canRedo".equalsIgnoreCase(undoManagerAction)) {
            if (manager.canRedo()) {
                done = SuperTypeNode.isTrue;
            }
        } else {
            throw new ParseException(this.getClass() + " Invalid parameter type:" + undoManagerAction + " possible values: undo, canUnd, redo, canRedo!");
        }
        stack.push(done);
    }
}

