/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.jep.JaxfrontMathCommand;
import com.jaxfront.core.jep.SuperTypeNode;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.Type;
import java.util.List;
import java.util.Stack;
import org.nfunk.jep.ParseException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomHasChanged
extends JaxfrontMathCommand {
    public static final String FORCED_CHANGE_VALUE = "forcedChangeValue";

    public DomHasChanged() {
        this.numberOfParameters = -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(MathEvaluator.MathCommunicator communicator, Stack stack) throws ParseException {
        this.checkStack(stack);
        Document dom = communicator.getRootType().getDOM();
        Boolean forcedValue = (Boolean)communicator.getUserObject(FORCED_CHANGE_VALUE);
        boolean hasChanged = communicator.getRootType().getDOM().hasChanged();
        if (this.curNumberOfParameters != 0) {
            if (this.curNumberOfParameters != 1) throw new ParseException(new StringBuffer().append("wrong number of parameters:").append(this.getClass()).toString());
            hasChanged = false;
            Object toSearchFor = stack.pop();
            if (toSearchFor instanceof Type) {
                hasChanged = ((Type)toSearchFor).hasChanged();
            } else if (toSearchFor instanceof List) {
                List res = (List)toSearchFor;
                for (int r = 0; r < res.size(); ++r) {
                    Type aResType;
                    Object aRes = res.get(r);
                    if (aRes instanceof Type && (aResType = (Type)aRes).hasChanged()) {
                        hasChanged = true;
                    } else {
                        if (!(aRes instanceof String) || (aResType = communicator.getDoc().getType((String)aRes)) == null || !aResType.hasChanged()) continue;
                        hasChanged = true;
                    }
                    break;
                }
            } else {
                if (!(toSearchFor instanceof Boolean)) throw new ParseException(new StringBuffer().append("wrong parameter type:").append(toSearchFor != null ? toSearchFor.getClass().getName() : "").toString());
                List targets = communicator.getTargetTypes();
                if (targets != null && !dom.getController().isBlockDirtyChange()) {
                    this.setChanged((Boolean)toSearchFor, targets);
                }
            }
        }
        if (forcedValue != null) {
            if (forcedValue.booleanValue()) {
                stack.push(SuperTypeNode.isTrue);
                return;
            } else {
                stack.push(SuperTypeNode.isFalse);
            }
            return;
        } else if (hasChanged) {
            stack.push(SuperTypeNode.isTrue);
            return;
        } else {
            stack.push(SuperTypeNode.isFalse);
        }
    }

    private void setChanged(boolean changed, List<AbstractType> targets) {
        for (int t = 0; t < targets.size(); ++t) {
            if (targets.get(t) == null) continue;
            targets.get(t).setHasChanged(changed);
        }
    }
}

