/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.jep.SuperTypeNode;
import com.jaxfront.core.rule.MathEvaluator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Stack;
import org.nfunk.jep.ParseException;

public class CurrentDateTime
extends SuperTypeNode {
    private String _defaultPattern = "yyyy-MM-dd'T'HH:mm:ss";

    public CurrentDateTime() {
    }

    public CurrentDateTime(String pattern) {
        this._defaultPattern = pattern;
    }

    public void run(MathEvaluator.MathCommunicator communicator, Stack stack) throws ParseException {
        this.checkStack(stack);
        Object result = "";
        if (this.curNumberOfParameters == 1) {
            String value = (String)stack.pop();
            result = this.getDate(communicator, value);
        } else if (this.curNumberOfParameters == 0) {
            String pattern = this._defaultPattern;
            result = this.getDate(communicator, pattern);
        } else if (this.curNumberOfParameters == 1) {
            Object param = stack.pop();
            if (param instanceof String) {
                String pattern = (String)param;
                result = this.getDate(communicator, pattern);
            }
        } else {
            throw new ParseException(this.getClass() + " Invalid parameter type");
        }
        stack.push(result);
    }

    private Object getDate(MathEvaluator.MathCommunicator communicator, String pattern) {
        Date today = null;
        today = communicator.getDoc() != null && communicator.getDoc().getConnectionManager() != null ? communicator.getDoc().getConnectionManager().getCommonServerDate() : new Date();
        if (pattern.equals("asNumber")) {
            return new Long(today.getTime());
        }
        if (communicator.getRootType() == null) {
            SimpleDateFormat formatter = new SimpleDateFormat(pattern);
            return formatter.format(today);
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, communicator.getRootType().getDOM().getGlobalDefinition().getCurrentLocale());
        return formatter.format(today);
    }
}

