/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.dom.CodeTables;
import com.jaxfront.core.jep.SuperTypeNode;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.schema.XMLSchema;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import java.util.List;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.NULL;

public class CodeSetParameter
extends SuperTypeNode {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(MathEvaluator.MathCommunicator communicator, Stack stack) throws ParseException {
        this.checkStack(stack);
        Object param = null;
        String xPath = null;
        Type resultType = null;
        if (this.curNumberOfParameters == 1) {
            Type baseType = communicator.getRootType();
            param = stack.pop();
            if (param == NULL._null) {
                stack.push(NULL._null);
                return;
            }
            if (param instanceof Type) {
                resultType = param;
            }
            if (param instanceof String) {
                xPath = param;
                List resultList = TypePathExecuter.getInstance().processXPath(baseType, xPath.trim());
                if (resultList.size() > 0) {
                    resultType = (Type)resultList.get(0);
                }
            }
            if (resultType == null) {
                stack.push(NULL._null);
                return;
            } else {
                if (!resultType.isSimple()) throw new ParseException(this.getClass() + " No Codeset for Complex Types");
                String codeSetValue = ((SimpleType)resultType).getCodeSetParam();
                if (codeSetValue == null) {
                    throw new ParseException(this.getClass() + " No Code for this Type: " + resultType.getName() + " defined.");
                }
                stack.push(codeSetValue);
            }
            return;
        } else {
            if (this.curNumberOfParameters != 3) throw new ParseException(this.getClass() + " Invalid parameter type");
            Object param3 = stack.pop();
            Object param2 = stack.pop();
            Object param1 = stack.pop();
            String codeURL = null;
            String codeId = null;
            String codeSetName = null;
            if (param1 == NULL._null || param2 == NULL._null || param3 == NULL._null) {
                stack.push(NULL._null);
                return;
            }
            if (param1 instanceof String) {
                codeURL = (String)param1;
            }
            if (param2 instanceof String) {
                codeSetName = (String)param2;
            }
            if (param3 instanceof String) {
                codeId = (String)param3;
            } else if (param3 instanceof Double) {
                codeId = Integer.toString(((Double)param3).intValue());
            }
            if (codeId == null || codeURL == null || codeSetName == null) throw new ParseException(this.getClass() + " Invalid parameter type");
            XMLSchema schema = communicator.getRootType().getDOM().getSchema();
            CodeTables codeTables = schema.getCodeTables(schema, codeURL, communicator.getRootType().getDOM().getFingerPrint().getXUIURL());
            String codeSetValue = null;
            if (codeTables == null) throw new ParseException(this.getClass() + "CodeSets not found:" + codeURL);
            codeSetValue = codeTables.getEntryParam(communicator.getRootType(), codeSetName, codeId, communicator.getRootType().getDOM().getLanguage());
            if (codeSetValue != null) {
                stack.push(codeSetValue);
                return;
            } else {
                stack.push(NULL._null);
            }
        }
    }
}

