/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.dom;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.dom.LogEntry;
import com.jaxfront.core.dom.LoggingListener;
import com.jaxfront.core.type.Type;
import java.util.Vector;

public class HistoryLoggingListener
extends LoggingListener {
    private Vector _fingerPrintActions = null;
    private boolean _isNewDocument = false;
    private boolean _logOnlyMetaData = false;
    private boolean _logStructureChanges = false;
    private static Vector _fingerprintActions;

    public HistoryLoggingListener(Document dom, String scope, String logLevel, Vector fingerPrintActions) {
        super(dom.getRootType(), scope, logLevel);
        this._fingerPrintActions = fingerPrintActions;
    }

    public void apply(Type source, DOMChangeEvent event, String oldValue) {
        if (this.doesConcern(event)) {
            LogEntry logEntry = new LogEntry(source, event, "1", oldValue);
            source.getDOM().getController().addChangeLog(logEntry);
        }
    }

    protected boolean doesConcern(DOMChangeEvent event) {
        boolean doesConcern = false;
        int iAction = (int)event.getType();
        switch (iAction) {
            case 256: {
                doesConcern = !this._logOnlyMetaData;
                break;
            }
            case 4096: {
                doesConcern = this._logStructureChanges;
                break;
            }
            case 2: {
                doesConcern = this._logStructureChanges;
                break;
            }
            case 1: {
                doesConcern = false;
                break;
            }
            case 8192: {
                doesConcern = true;
                break;
            }
            case 0x200000: {
                doesConcern = true;
                break;
            }
            case 32768: {
                doesConcern = true;
                break;
            }
            case 0x400000: {
                String keyName = event.getChangeName();
                if (this.getFingerprintActions().contains(keyName)) {
                    if (keyName.equals("STATUS") && event.getOldValue().toString().equals("1") && event.getNewValue().toString().equals("2")) {
                        doesConcern = false;
                        this._isNewDocument = true;
                        break;
                    }
                    if (keyName.equals("OWNER") && this._isNewDocument) {
                        doesConcern = false;
                        break;
                    }
                    doesConcern = true;
                    break;
                }
                doesConcern = false;
                break;
            }
            case 0: {
                doesConcern = false;
            }
            case 4: {
                doesConcern = false;
                break;
            }
            case 8: {
                doesConcern = false;
                break;
            }
            case 16: {
                doesConcern = false;
                break;
            }
            case 32: {
                doesConcern = false;
                break;
            }
            case 64: {
                doesConcern = false;
                break;
            }
            case 128: {
                doesConcern = this._logStructureChanges;
                break;
            }
            case 512: {
                doesConcern = this._logStructureChanges;
                break;
            }
            case 1024: {
                doesConcern = this._logStructureChanges;
                break;
            }
            case 2048: {
                doesConcern = false;
                break;
            }
            case 16384: {
                doesConcern = false;
                break;
            }
            case 65536: {
                doesConcern = false;
                break;
            }
            case 131072: {
                doesConcern = false;
                break;
            }
            case 0x2000000: {
                doesConcern = false;
                break;
            }
            case 0x800000: {
                doesConcern = false;
                break;
            }
            case 0x1000000: {
                doesConcern = false;
                break;
            }
            case 0x20000000: {
                doesConcern = false;
                break;
            }
            case 0x40000000: {
                doesConcern = false;
                break;
            }
            case 262144: {
                doesConcern = false;
                break;
            }
            case 524288: {
                doesConcern = false;
                break;
            }
            case 0x100000: {
                doesConcern = false;
                break;
            }
        }
        return doesConcern;
    }

    public void setLogOnlyMetaData(boolean logOnlyMetaData) {
        this._logOnlyMetaData = logOnlyMetaData;
        this.setLogPropertyChanges(!logOnlyMetaData);
    }

    public void setLogStructureChanges(boolean logStructureChanges) {
        this._logStructureChanges = logStructureChanges;
    }

    private Vector getFingerprintActions() {
        if (this._fingerPrintActions == null) {
            this._fingerPrintActions = new Vector();
        }
        return this._fingerPrintActions;
    }

    public static Vector getFingerprintLogActions() {
        if (_fingerprintActions == null) {
            _fingerprintActions = new Vector();
            _fingerprintActions.add("STATUS");
            _fingerprintActions.add("OWNER");
        }
        return _fingerprintActions;
    }
}

