/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.dom;

import com.jaxfront.core.dom.CodeSetEntry;
import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.dom.DocumentCreationException;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.URLHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.w3c.dom.ls.LSInput;

public class FingerPrint {
    private Hashtable _pInstructions;
    private Document _jaxDOM;
    private URL _xsdURL;
    private URL _xuiURL;
    private Vector _includes;
    private Vector _includedFingerprints;
    private String _xsdJAXContent;
    private String _xuiJAXContent;
    private Hashtable _xuiNamespaceMapping;
    private boolean _serializeJAXFrontPI = true;
    private XMLEntityResolver _resolver;
    private LSInput _xuiInput;
    private LSInput _xsdInput;
    private String[] _nlsLangSequence;
    private String _lastLoadedNLSLanguage;
    public static final String JAXFRONT_PI = "jaxfront";
    public static final String JAXFRONT_PI_XSD = "xsd";
    public static final String JAXFRONT_PI_XML = "xml";
    public static final String JAXFRONT_PI_XUI = "xui";
    public static final String JAXFRONT_PI_PID = "pid";
    public static final String JAXFRONT_PI_VERSION = "version";
    public static final String JAXFRONT_PI_TIME = "time";
    public static final String JAXFRONT_PI_APP_VERSION = "appversion";
    public static final String JAXFRONT_PI_INCLUDE = "include";
    public static final String JAXFRONT_PI_XUI_NS_MAPPING = "nsMapping";
    public static final String JAXFRONT_PI_INCLUDE_PDF = "include-pdf";
    public static final String JAXFRONT_PI_CONTROLLER = "controller";
    public static final String JAXFRONT_PI_CREATED = "CREATED";
    public static final String JAXFRONT_PI_CREATED_USER = "CREATED_USER";
    public static final String JAXFRONT_PI_LASTUPDATE = "LASTUPDATE";
    public static final String JAXFRONT_PI_LASTUPDATE_USER = "LASTUPDATE_USER";
    public static final String JAXFRONT_PI_OWNER = "OWNER";
    public static final String JAXFRONT_PI_STATUS = "STATUS";
    public static final String JAXFRONT_PI_GROUP_ID = "GROUP_ID";
    public static final String JAXFRONT_PI_MANDANT_ID = "MANDANT_ID";
    public static final String JAXFRONT_PI_ID = "ID";
    public long _dbLoadTimeStamp = -1L;

    public FingerPrint(Document jaxDOM, org.w3c.dom.Document dom, URL xsdURL, URL xuiURL) {
        this._xsdURL = xsdURL;
        this._xuiURL = xuiURL;
        this._jaxDOM = jaxDOM;
        if (dom != null) {
            this.initialize(dom);
        }
    }

    public FingerPrint(Document jaxDOM, org.w3c.dom.Document dom, URL xsdURL, LSInput xuiInput) {
        this._xsdURL = xsdURL;
        if (xuiInput != null) {
            try {
                this._xuiURL = new URL("file", null, xuiInput.getSystemId());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        this._xuiInput = xuiInput;
        this._jaxDOM = jaxDOM;
        if (dom != null) {
            this.initialize(dom);
        }
    }

    public FingerPrint(Document jaxDOM, org.w3c.dom.Document dom, LSInput xsdInput, LSInput xuiInput) {
        this._xsdInput = xsdInput;
        this._xuiInput = xuiInput;
        this._jaxDOM = jaxDOM;
        if (dom != null) {
            this.initialize(dom);
        }
    }

    public Document getJAXDOM() {
        return this._jaxDOM;
    }

    public void checkVersionNo() throws DocumentCreationException {
        if (this.getVersionNo() == null || !this.getVersionNo().equals(Document.getXUIVersionNo())) {
            String message = "False version-no found in xui-file: Document version is:" + this.getVersionNo() + " System version is:" + Document.getXUIVersionNo();
            if (LogRegistry.getInstance().logWarnings()) {
                LogRegistry.getInstance().warn(this.getClass(), message);
            }
            if (!this.isVersionCheckDisabled()) {
                throw DocumentCreationException.wrongXUIVersion(new Exception(message), this);
            }
        }
    }

    public String getTimeCreated() {
        return (String)this.getProcessingInstructions().get(JAXFRONT_PI_TIME);
    }

    public String getVersionNo() {
        return (String)this.getProcessingInstructions().get(JAXFRONT_PI_VERSION);
    }

    public String getAppVersionNo() {
        return (String)this.getProcessingInstructions().get(JAXFRONT_PI_APP_VERSION);
    }

    private void initialize(org.w3c.dom.Document dom) {
        String jaxfrontPI = DOMHelper.getProcessingInstructionValue(dom, JAXFRONT_PI);
        if (jaxfrontPI != null && jaxfrontPI.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(jaxfrontPI, ";");
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken();
                int eq = temp.indexOf("=");
                if (eq == -1) continue;
                String key = temp.substring(0, eq).trim();
                String value = temp.substring(eq + 1).trim();
                if (key.equals(JAXFRONT_PI_INCLUDE)) {
                    if (value != null) {
                        value = URLDecoder.decode(value);
                    }
                    if (value == null || value.equals("") || this.getIncludes().contains(value)) continue;
                    this.getIncludes().add(value);
                    continue;
                }
                if (key.equals(JAXFRONT_PI_XUI_NS_MAPPING)) {
                    if (value == null || value.equals("")) continue;
                    String[] maps = StringUtil.split(value, "%KEY");
                    for (int ma = 0; ma < maps.length; ++ma) {
                        String[] kVPair = StringUtil.split(maps[ma], "%VAL");
                        if (kVPair.length != 2) continue;
                        this.putXUINamespaceMapping(kVPair[0], kVPair[1]);
                    }
                    continue;
                }
                if (key.equals("NLS_LANGUAGE_SEQUENCE")) {
                    if (value != null && !value.equals("")) {
                        this.setNLSReadingSequence(StringUtil.split(value, ","));
                    }
                    this.putProcessingInstructions(key, value);
                    continue;
                }
                this.putProcessingInstructions(key, value);
            }
        }
    }

    public Vector getIncludes() {
        if (this._includes == null) {
            this._includes = new Vector();
        }
        return this._includes;
    }

    public String getIncludedPDFXUI() {
        return (String)this.getProcessingInstructions().get(JAXFRONT_PI_INCLUDE_PDF);
    }

    public boolean hasIncludes() {
        return this.getIncludes().size() > 0;
    }

    public void setAppVersionNo(String versionNo) {
        this.putProcessingInstructions(JAXFRONT_PI_APP_VERSION, versionNo);
    }

    public StringBuffer serialize(Document jaxDom) {
        StringBuffer sb = new StringBuffer();
        if (!this._serializeJAXFrontPI) {
            return null;
        }
        sb.append("<?jaxfront version=2.77");
        sb.append(";" + this.makeFingerPrint(jaxDom, JAXFRONT_PI_TIME, new Timestamp(System.currentTimeMillis()).toString()));
        Enumeration pis = this.getProcessingInstructions().keys();
        String key = null;
        String value = null;
        while (pis.hasMoreElements()) {
            key = (String)pis.nextElement();
            value = (String)this.getProcessingInstructions().get(key);
            if (key.equals(JAXFRONT_PI_VERSION) || key.equals(JAXFRONT_PI_TIME) || key.equals(JAXFRONT_PI_INCLUDE) || key.equals(JAXFRONT_PI_XUI_NS_MAPPING)) continue;
            sb.append(";" + this.makeFingerPrint(jaxDom, key, value));
        }
        if (this.getXUIURL() != null && this.getXuiLocation() == null) {
            sb.append(";" + this.makeFingerPrint(jaxDom, JAXFRONT_PI_XUI, this.getXUIName()));
        }
        if (this.getXSDURL() != null && this.getXsdLocation() == null) {
            sb.append(";" + this.makeFingerPrint(jaxDom, JAXFRONT_PI_XSD, this.getXSDName()));
        }
        if (jaxDom.keepXUIDOMinMemory()) {
            Iterator nsIt;
            Enumeration includeEnum = this.getIncludes().elements();
            while (includeEnum.hasMoreElements()) {
                value = (String)includeEnum.nextElement();
                sb.append(";" + this.makeFingerPrint(jaxDom, JAXFRONT_PI_INCLUDE, value));
            }
            if (jaxDom != null && jaxDom.getXUINamespaceMappings() != null && (nsIt = jaxDom.getXUINamespaceMappings().entrySet().iterator()).hasNext()) {
                sb.append(";");
                sb.append(JAXFRONT_PI_XUI_NS_MAPPING);
                sb.append("=");
                StringBuffer mapps = new StringBuffer();
                while (nsIt.hasNext()) {
                    Map.Entry nsEntry = nsIt.next();
                    mapps.append("%KEY");
                    mapps.append(nsEntry.getKey());
                    mapps.append("%VAL");
                    mapps.append(nsEntry.getValue());
                }
                sb.append(mapps);
            }
        }
        sb.append("?>");
        return sb;
    }

    private String makeFingerPrint(Document jaxDom, String key, String value) {
        if (jaxDom.getSerializationModifier() == null) {
            return key + "=" + value;
        }
        if (jaxDom.getSerializationModifier().serializeFingerPrint(key, value)) {
            return jaxDom.getSerializationModifier().modifyFingerPrint(key, value);
        }
        return "";
    }

    private String getXUIName() {
        String fileLocation = null;
        if (this.getXSDURL() != null && this.getXUIURL() != null) {
            URL xsdDirectory = null;
            if (this.getXSDURL().getProtocol().equals("file")) {
                xsdDirectory = URLHelper.getUserURL(URLHelper.getFile(this.getXSDURL()).getParent());
                fileLocation = URLHelper.getRelativePath(xsdDirectory, this.getXUIURL());
            } else {
                fileLocation = URLHelper.getRelativePath(this.getXSDURL(), this.getXUIURL());
            }
        }
        return fileLocation;
    }

    private String getXSDName() {
        String fileLocation = null;
        if (this.getXSDURL() != null) {
            if (JAXFrontProperties.getInstance(this.getAppContext()).serializeXSDUrlRelative()) {
                if (this._jaxDOM != null && this._jaxDOM.getClientProperty("urlBase") != null) {
                    String urlBase = (String)this._jaxDOM.getClientProperty("urlBase");
                    fileLocation = URLHelper.relativize(URLHelper.getUserURL(urlBase), this.getXSDURL()).toString();
                } else {
                    fileLocation = URLHelper.getFileName(this.getXSDURL());
                }
            } else {
                fileLocation = this.getXSDURL().toExternalForm();
            }
        }
        return fileLocation;
    }

    private String getAppContext() {
        if (this._jaxDOM != null) {
            return this._jaxDOM.getAppContext();
        }
        return null;
    }

    public URL getXSDURL() {
        return this._xsdURL;
    }

    public URL getXUIURL() {
        if (this._xuiURL == null && this._xuiInput != null) {
            try {
                this._xuiURL = this._xuiInput.getBaseURI() == null ? URLHelper.getUserURL(this._xuiInput.getSystemId()) : URLHelper.resolve(this._xuiInput.getBaseURI(), this._xuiInput.getSystemId()).toURL();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this._xuiURL;
    }

    public String getPID() {
        return (String)this.getProcessingInstructions().get(JAXFRONT_PI_PID);
    }

    public void setPID(String pid) {
        if (pid == null) {
            this.getProcessingInstructions().remove(JAXFRONT_PI_PID);
            if (this.getJAXDOM() != null) {
                this.getJAXDOM().removeApplicationProperty(JAXFRONT_PI_PID);
            }
        } else {
            this.putProcessingInstructions(JAXFRONT_PI_PID, pid);
            if (this.getJAXDOM() != null) {
                this.getJAXDOM().putApplicationProperty(JAXFRONT_PI_PID, pid);
            }
        }
    }

    public Vector getIncludedFingerPrints() {
        if (this._includedFingerprints == null) {
            this._includedFingerprints = new Vector();
        }
        return this._includedFingerprints;
    }

    public Hashtable getXUINamespaceMapping() {
        return this._xuiNamespaceMapping;
    }

    public String putXUINamespaceMapping(String namespace, String prefix) {
        if (this._xuiNamespaceMapping == null) {
            this._xuiNamespaceMapping = new Hashtable();
        }
        return this._xuiNamespaceMapping.put(namespace != null ? namespace : "", prefix != null ? prefix : "");
    }

    public void setXUINamespaceMapping(Hashtable mapping) {
        this._xuiNamespaceMapping = mapping;
    }

    public String getXUINamespaceMapping(String namespace) {
        if (this._xuiNamespaceMapping == null) {
            return null;
        }
        return (String)this._xuiNamespaceMapping.get(namespace);
    }

    public void addIncludedFingerPrint(FingerPrint fingerPrint) {
        this.getIncludedFingerPrints().add(fingerPrint);
    }

    public void setIncludedPDFXUI(String name) {
        this.putProcessingInstructions(JAXFRONT_PI_INCLUDE_PDF, name);
    }

    public void setXuiURL(URL xuiURL) {
        this._xuiURL = xuiURL;
    }

    public Object putProcessingInstructions(String key, String value) {
        return this.putProcessingInstructions(key, value, null);
    }

    public Object putProcessingInstructions(String key, String value, CodeSetEntry codeSetEntry) {
        if (this._jaxDOM != null) {
            boolean changed;
            String oldValue = this.getProcessingInstruction(key);
            boolean bl = changed = oldValue != value && (value == null || !value.equals(oldValue));
            if (changed) {
                String newValue = value;
                if (codeSetEntry != null) {
                    newValue = codeSetEntry.getText(value);
                    if (oldValue != null) {
                        oldValue = codeSetEntry.getText(oldValue);
                    }
                }
                this._jaxDOM.fireDOMChanged(DOMChangeEvent.DOM_FINGERPRINT_CHANGED(this._jaxDOM, key, oldValue, newValue));
            }
        }
        return this.getProcessingInstructions().put(key, value);
    }

    public String getProcessingInstruction(String key) {
        return (String)this.getProcessingInstructions().get(key);
    }

    public void removeProcessingInstruction(String key) {
        this.getProcessingInstructions().remove(key);
    }

    public void setXsdLocation(String xsdLocation) {
        this.putProcessingInstructions(JAXFRONT_PI_XSD, xsdLocation);
    }

    public String getXsdLocation() {
        return (String)this.getProcessingInstructions().get(JAXFRONT_PI_XSD);
    }

    public void setXmlLocation(String xmlLocation) {
        this.putProcessingInstructions(JAXFRONT_PI_XML, xmlLocation);
    }

    public String getXmlLocation() {
        return (String)this.getProcessingInstructions().get(JAXFRONT_PI_XML);
    }

    public String getController() {
        return (String)this.getProcessingInstructions().get(JAXFRONT_PI_CONTROLLER);
    }

    public void setXuiLocation(String xuiLocation) {
        URL xuiURL;
        if (this.getXSDURL() != null && (xuiURL = URLHelper.getUserURL(xuiLocation)) != null) {
            xuiLocation = URLHelper.getRelativePath(this.getXSDURL(), xuiURL);
        }
        this.putProcessingInstructions(JAXFRONT_PI_XUI, xuiLocation);
    }

    public String getXuiLocation() {
        return (String)this.getProcessingInstructions().get(JAXFRONT_PI_XUI);
    }

    public void update(String jaxfrontPI) {
        String raw = jaxfrontPI.substring(jaxfrontPI.indexOf("<?") + 11, jaxfrontPI.length() - 2);
        String[] tokens = TextTools.tokenize(raw, ";");
        String key = null;
        String value = null;
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i].indexOf("=") == -1) continue;
            key = tokens[i].substring(0, tokens[i].indexOf("=")).trim();
            value = tokens[i].substring(tokens[i].indexOf("=") + 1, tokens[i].length()).trim();
            if (key.equals(JAXFRONT_PI_INCLUDE)) continue;
            this.putProcessingInstructions(key, value);
        }
    }

    public Hashtable getProcessingInstructions() {
        if (this._pInstructions == null) {
            this._pInstructions = new Hashtable();
        }
        return this._pInstructions;
    }

    public void refresh(FingerPrint xuiFingerprint) {
        if (xuiFingerprint.getAppVersionNo() != null) {
            this.setAppVersionNo(xuiFingerprint.getAppVersionNo());
        }
        if (xuiFingerprint.getIncludedPDFXUI() != null) {
            this.setIncludedPDFXUI(xuiFingerprint.getIncludedPDFXUI());
        }
    }

    private boolean isVersionCheckDisabled() {
        return true;
    }

    public void setXSDJAXContent(String content) {
        this._xsdJAXContent = content;
    }

    public void setXUIJAXContent(String content) {
        this._xuiJAXContent = content;
    }

    public String getXSDJAXContent() {
        return this._xsdJAXContent;
    }

    public String getXUIJAXContent() {
        return this._xuiJAXContent;
    }

    public void setSerializeJAXFrontPI(boolean serializeJAXFrontPI) {
        this._serializeJAXFrontPI = serializeJAXFrontPI;
    }

    public void setEntityResolver(XMLEntityResolver resolver) {
        this._resolver = resolver;
    }

    public XMLEntityResolver getEntityResolver() {
        return this._resolver;
    }

    public LSInput getXSDInput() {
        return this._xsdInput;
    }

    public void setXSDInput(LSInput input) {
        this._xsdInput = input;
    }

    public void setXUIInput(LSInput input) {
        this._xuiInput = input;
    }

    public LSInput getXUIInput() {
        return this._xuiInput;
    }

    public void setNLSReadingSequence(String[] langSeq) {
        if (langSeq != null && ArrayUtil.contains(langSeq, "all") == -1) {
            langSeq = ArrayUtil.addToArray(langSeq, "all");
        }
        this._nlsLangSequence = langSeq;
    }

    public String[] getNLSReadingSequence(String defaultLang) {
        if (this._nlsLangSequence == null && defaultLang != null) {
            return new String[]{defaultLang};
        }
        return this._nlsLangSequence;
    }

    public void setLastLoadedLanguage(String currentLang) {
        this._lastLoadedNLSLanguage = currentLang;
    }

    public String getLastLoadedLanguage() {
        return this._lastLoadedNLSLanguage;
    }

    public long getDBLoadTimeStamp() {
        return this._dbLoadTimeStamp;
    }

    public void setDBLoadTimeStamp(long loadTimeStamp) {
        this._dbLoadTimeStamp = loadTimeStamp;
    }
}

