/* TOUCH.CMD  REXX CMD by Gord Snider  v1.0  2003/02/02 */
/* PURPOSE: To set a file's date and time to the current date and time.
   
   SYNTAX:  TOUCH target | *  [/T]
       or   TOUCH /? 
            
      where target is a filename in the current directory, or 
            * is all the files in the current directory; and
      where optional switch is /? to show a help screen and exit,
            optional switch /T turns on trace ?i
*/
if LRU() then exit
parse arg target '/' switches
switches = translate(switches)
if pos('?', switches) > 0 | target = '' then do              /* show help screen */
    do l = 1 until substr(sourceline(l), 1, 2) = '*/'
      say sourceline(l)
    end l
  exit
  end  /* if */
if pos('T', switches) > 0 then trace ?i

/* CALL RxFuncAdd 'SysSetFileDateTime', 'RexxUtil', 'SysSetFileDateTime'; */
if target = '*' 
   then do; call SysFileTree '*', 'file.', 'FO'
        do i = 1 to file.0
          call SysSetFileDateTime(file.i)
          if result > 0 then do
             say file.i 'RC =' result
             exit 1
             end /* do */
        end i
      end /* do */
   else call SysSetFileDateTime(target)

exit 0
