//----------------------------------------------------------------------------
// $Id: StreamDiscard.java,v 1.2 2006/03/09 22:34:53 enz Exp $
// $Source: /cvsroot/gogui/gogui/src/net/sf/gogui/utils/StreamDiscard.java,v $
//----------------------------------------------------------------------------

package net.sf.gogui.utils;

import java.io.InputStream;

//----------------------------------------------------------------------------

/** Thread discarding an output stream. */
public class StreamDiscard
    extends Thread
{
    public StreamDiscard(InputStream src)
    {
        m_src = src;
    }

    /** Run method.
        Exceptions caught are written to stderr.
    */
    public void run()
    {
        try
        {
            byte buffer[] = new byte[1024];
            while (true)
            {
                int n = m_src.read(buffer);
                if (n < 0)
                    break;
                if (n == 0)
                {
                    // Not sure if this is necessary.
                    sleep(100);
                    continue;
                }
            }
        }
        catch (Throwable e)
        {
            StringUtils.printException(e);
        }
    }

    private final InputStream m_src;
};

//----------------------------------------------------------------------------
