/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.sgf;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.sf.gogui.game.GameInformation;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.MarkType;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.utils.StringUtils;

public class SgfWriter {
    private final StringBuffer m_buffer = new StringBuffer(128);
    private final int m_size;
    private final PrintStream m_out;

    public SgfWriter(OutputStream outputStream, GameTree gameTree, String string, String string2) {
        this.m_out = new PrintStream(outputStream);
        this.print("(");
        GameInformation gameInformation = gameTree.getGameInformation();
        this.m_size = gameInformation.m_boardSize;
        String string3 = gameInformation.m_result;
        String string4 = gameInformation.m_playerBlack;
        String string5 = gameInformation.m_playerWhite;
        String string6 = gameInformation.m_blackRank;
        String string7 = gameInformation.m_whiteRank;
        String string8 = gameInformation.m_date;
        String string9 = gameInformation.m_rules;
        int n = gameInformation.m_handicap;
        double d = gameInformation.m_komi;
        TimeSettings timeSettings = gameInformation.m_timeSettings;
        this.printHeader(string, string2, n, string8, string4, string5, string6, string7, string3, d, string9, timeSettings);
        this.printNewLine();
        this.printNode(gameTree.getRoot(), true);
        this.print(")");
        this.m_out.println(this.m_buffer.toString());
        this.m_out.close();
    }

    public SgfWriter(OutputStream outputStream, Board board, String string, String string2) {
        this.m_size = board.getSize();
        this.m_out = new PrintStream(outputStream);
        this.print("(");
        this.printHeader(string, string2);
        this.printNewLine();
        this.printPosition(board);
        this.print(")");
        this.m_out.println(this.m_buffer.toString());
        this.m_out.close();
    }

    private String getEscaped(String string) {
        return this.getEscaped(string, false);
    }

    private String getEscaped(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(2 * string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c;
            String string2 = bl ? "]:\\" : "]\\";
            if (string2.indexOf(c = string.charAt(i)) >= 0) {
                stringBuffer.append('\\');
                stringBuffer.append(c);
                continue;
            }
            if (c != '\n' && Character.isWhitespace(c)) {
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static int getMoveNumberInVariation(Node node) {
        int n = 0;
        while (node != null) {
            if (node.getMove() != null) {
                ++n;
            }
            if ((node = node.getFather()) == null || node.getNumberChildren() <= 1) continue;
            break;
        }
        return n;
    }

    private String getPoint(GoPoint goPoint) {
        if (goPoint == null) {
            return "";
        }
        int n = 97 + goPoint.getX();
        int n2 = 97 + (this.m_size - goPoint.getY() - 1);
        return "" + (char)n + (char)n2;
    }

    private String getPointValue(GoPoint goPoint) {
        return "[" + this.getPoint(goPoint) + "]";
    }

    private String getPointList(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer(128);
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.append(this.getPointValue((GoPoint)arrayList.get(i)));
        }
        return stringBuffer.toString();
    }

    private void print(String string) {
        if (string.indexOf(10) > 0) {
            this.printNewLine();
            this.m_buffer.append(string);
            this.printNewLine();
            return;
        }
        int n = 78;
        if (this.m_buffer.length() + string.length() > n) {
            this.printNewLine();
        }
        this.m_buffer.append(string);
    }

    private void printNewLine() {
        if (this.m_buffer.length() > 0) {
            this.m_out.println(this.m_buffer.toString());
            this.m_buffer.replace(0, this.m_buffer.length(), "");
        }
    }

    private void printHeader(String string, String string2) {
        String string3 = string;
        if (string2 != null && !string2.equals("")) {
            string3 = string3 + ":" + string2;
        }
        this.print(";FF[4]CA[" + this.getEscaped(StringUtils.getDefaultEncoding()) + "]AP[" + this.getEscaped(string3) + "]");
        if (this.m_size != 19) {
            this.print("SZ[" + this.m_size + "]");
        }
    }

    private void printHeader(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7, String string8, double d, String string9, TimeSettings timeSettings) {
        this.printHeader(string, string2);
        if (n > 0) {
            this.print("HA[" + n + "]");
        } else {
            this.print("KM[" + GameInformation.roundKomi(d) + "]");
        }
        if (string9 != null && !string9.equals("")) {
            this.print("RU[" + this.getEscaped(string9) + "]");
        }
        if (timeSettings != null) {
            this.print("TM[" + timeSettings.getPreByoyomi() / 1000L + "]");
            if (timeSettings.getUseByoyomi()) {
                this.print("OT[" + timeSettings.getByoyomiMoves() + " moves / " + timeSettings.getByoyomi() / 1000L + " sec]");
            }
        }
        if (string4 != null && !string4.equals("")) {
            this.print("PB[" + this.getEscaped(string4) + "]");
        }
        if (string5 != null && !string5.equals("")) {
            this.print("PW[" + this.getEscaped(string5) + "]");
        }
        if (string6 != null && !string6.equals("")) {
            this.print("BR[" + this.getEscaped(string6) + "]");
        }
        if (string7 != null && !string7.equals("")) {
            this.print("WR[" + this.getEscaped(string7) + "]");
        }
        if (string3 != null && !string3.equals("")) {
            this.print("DT[" + this.getEscaped(string3) + "]");
        }
        if (string8 != null && !string8.equals("")) {
            this.print("RE[" + string8 + "]");
        }
    }

    private void printLabels(Node node) {
        Map map = node.getLabels();
        if (map == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("LB");
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            GoPoint goPoint = (GoPoint)entry.getKey();
            String string = (String)entry.getValue();
            stringBuffer.append('[');
            stringBuffer.append(this.getPoint(goPoint));
            stringBuffer.append(':');
            stringBuffer.append(this.getEscaped(string, true));
            stringBuffer.append(']');
        }
        this.print(stringBuffer.toString());
    }

    private void printMarked(Node node, String string, MarkType markType) {
        ArrayList arrayList = node.getMarked(markType);
        if (arrayList != null) {
            this.print(string + this.getPointList(arrayList));
        }
    }

    private void printNode(Node node, boolean bl) {
        int n;
        Map map;
        String string;
        int n2;
        Move move = node.getMove();
        if (!bl) {
            int n3;
            if (move != null && (n3 = SgfWriter.getMoveNumberInVariation(node)) != 1 && n3 % 10 == 1) {
                this.printNewLine();
            }
            this.print(";");
        }
        if (move != null) {
            String string2 = this.getPointValue(move.getPoint());
            if (move.getColor() == GoColor.BLACK) {
                this.print("B" + string2);
            } else {
                this.print("W" + string2);
            }
        }
        if (node.getNumberAddBlack() > 0) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("AB");
            for (n2 = 0; n2 < node.getNumberAddBlack(); ++n2) {
                stringBuffer.append(this.getPointValue(node.getAddBlack(n2)));
            }
            this.print(stringBuffer.toString());
        }
        if (node.getNumberAddWhite() > 0) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("AW");
            for (n2 = 0; n2 < node.getNumberAddWhite(); ++n2) {
                stringBuffer.append(this.getPointValue(node.getAddWhite(n2)));
            }
            this.print(stringBuffer.toString());
        }
        if (node.getNumberAddEmpty() > 0) {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("AE");
            for (n2 = 0; n2 < node.getNumberAddEmpty(); ++n2) {
                stringBuffer.append(this.getPointValue(node.getAddEmpty(n2)));
            }
            this.print(stringBuffer.toString());
        }
        if ((string = node.getComment()) != null && !string.trim().equals("")) {
            this.print("C[" + this.getEscaped(string) + "]");
        }
        if (!Double.isNaN(node.getTimeLeft(GoColor.BLACK))) {
            this.print("BL[" + node.getTimeLeft(GoColor.BLACK) + "]");
        }
        if (node.getMovesLeft(GoColor.BLACK) >= 0) {
            this.print("OB[" + node.getMovesLeft(GoColor.BLACK) + "]");
        }
        if (!Double.isNaN(node.getTimeLeft(GoColor.WHITE))) {
            this.print("WL[" + node.getTimeLeft(GoColor.WHITE) + "]");
        }
        if (node.getMovesLeft(GoColor.WHITE) >= 0) {
            this.print("OW[" + node.getMovesLeft(GoColor.WHITE) + "]");
        }
        if (node.getPlayer() != GoColor.EMPTY) {
            this.printToPlay(node.getPlayer());
        }
        this.printMarked(node, "MA", MarkType.MARK);
        this.printMarked(node, "CR", MarkType.CIRCLE);
        this.printMarked(node, "SQ", MarkType.SQUARE);
        this.printMarked(node, "TR", MarkType.TRIANGLE);
        this.printMarked(node, "SL", MarkType.SELECT);
        this.printMarked(node, "TB", MarkType.TERRITORY_BLACK);
        this.printMarked(node, "TW", MarkType.TERRITORY_WHITE);
        this.printLabels(node);
        if (!Double.isNaN(node.getValue())) {
            this.print("V[" + node.getValue() + "]");
        }
        if ((map = node.getSgfProperties()) != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string3 = (String)entry.getKey();
                String string4 = (String)entry.getValue();
                this.print(string3 + string4);
            }
        }
        if ((n = node.getNumberChildren()) == 0) {
            return;
        }
        if (n == 1) {
            this.printNode(node.getChild(), false);
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.printNewLine();
            this.print("(");
            this.printNode(node.getChild(i), false);
            this.print(")");
        }
    }

    private void printPosition(Board board) {
        int n = board.getNumberPoints();
        ArrayList<GoPoint> arrayList = new ArrayList<GoPoint>(n);
        ArrayList<GoPoint> arrayList2 = new ArrayList<GoPoint>(n);
        for (int i = 0; i < n; ++i) {
            GoPoint goPoint = board.getPoint(i);
            GoColor goColor = board.getColor(goPoint);
            if (goColor == GoColor.BLACK) {
                arrayList.add(goPoint);
                continue;
            }
            if (goColor != GoColor.WHITE) continue;
            arrayList2.add(goPoint);
        }
        this.printSetup(arrayList, arrayList2);
        this.printNewLine();
        this.printToPlay(board.getToMove());
    }

    private void printSetup(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList.size() > 0 || arrayList2.size() > 0) {
            if (arrayList.size() > 0) {
                this.print("AB" + this.getPointList(arrayList));
            }
            this.printNewLine();
            if (arrayList2.size() > 0) {
                this.print("AW" + this.getPointList(arrayList2));
            }
        }
    }

    private void printToPlay(GoColor goColor) {
        if (goColor == GoColor.BLACK) {
            this.print("PL[B]");
        } else {
            this.print("PL[W]");
        }
    }
}

