/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.sgf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.gogui.game.GameInformation;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.MarkType;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.sgf.ByteCountInputStream;
import net.sf.gogui.utils.ErrorMessage;
import net.sf.gogui.utils.ProgressShow;

public final class SgfReader {
    private boolean m_ignoreTimeSettings;
    private boolean m_isFile;
    private boolean m_sizeFixed;
    private int m_byoyomiMoves;
    private int m_lastPercent;
    private long m_byoyomi;
    private long m_preByoyomi;
    private long m_size;
    private ByteCountInputStream m_byteCountInputStream;
    private Reader m_reader;
    private GameInformation m_gameInformation;
    private GameTree m_gameTree;
    private ProgressShow m_progressShow;
    private final TreeSet m_warnings;
    private StreamTokenizer m_tokenizer;
    private String m_name;
    private String m_newCharset;
    private final StringBuffer m_buffer;
    private final ArrayList m_pointList;
    private final ArrayList m_values;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SgfReader(InputStream inputStream, String string, ProgressShow progressShow, long l) throws SgfError {
        block7: {
            this.m_byoyomiMoves = -1;
            this.m_byoyomi = -1L;
            this.m_preByoyomi = -1L;
            this.m_warnings = new TreeSet();
            this.m_buffer = new StringBuffer(512);
            this.m_pointList = new ArrayList();
            this.m_values = new ArrayList();
            this.m_name = string;
            this.m_progressShow = progressShow;
            this.m_size = l;
            boolean bl = this.m_isFile = inputStream instanceof FileInputStream && string != null;
            if (progressShow != null) {
                progressShow.showProgress(0);
            }
            try {
                this.readSgf(inputStream, "ISO-8859-1");
            }
            catch (SgfCharsetChanged sgfCharsetChanged) {
                try {
                    inputStream = new FileInputStream(new File(string));
                }
                catch (IOException iOException) {
                    throw new SgfError("Could not reset SGF stream after charset change");
                }
                try {
                    this.readSgf(inputStream, this.m_newCharset);
                }
                catch (SgfCharsetChanged sgfCharsetChanged2) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError();
                }
            }
        }
    }

    public GameTree getGameTree() {
        return this.m_gameTree;
    }

    public String getWarnings() {
        if (this.m_warnings.isEmpty()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(this.m_warnings.size() * 80);
        Iterator iterator = this.m_warnings.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    private void addSgfProperty(Node node, String string) {
        this.m_buffer.setLength(0);
        for (int i = 0; i < this.m_values.size(); ++i) {
            this.m_buffer.append('[');
            this.m_buffer.append(this.getValue(i));
            this.m_buffer.append(']');
        }
        node.addSgfProperty(string, this.m_buffer.toString());
    }

    private void applyFixes() {
        Node node = this.m_gameTree.getRoot();
        GameInformation gameInformation = this.m_gameTree.getGameInformation();
        if (node.getNumberAddWhite() + node.getNumberAddBlack() > 0 && node.getPlayer() == GoColor.EMPTY) {
            if (gameInformation.m_handicap > 0) {
                node.setPlayer(GoColor.WHITE);
            } else {
                boolean bl = false;
                boolean bl2 = false;
                for (int i = 0; i < node.getNumberChildren(); ++i) {
                    Move move = node.getChild(i).getMove();
                    if (move == null) continue;
                    if (move.getColor() == GoColor.BLACK) {
                        bl = true;
                    }
                    if (move.getColor() != GoColor.WHITE) continue;
                    bl2 = true;
                }
                if (bl && !bl2) {
                    node.setPlayer(GoColor.BLACK);
                }
                if (bl2 && !bl) {
                    node.setPlayer(GoColor.WHITE);
                }
            }
        }
    }

    private void checkEndOfFile() throws SgfError, IOException {
        int n;
        do {
            this.m_tokenizer.nextToken();
            n = this.m_tokenizer.ttype;
            if (n == 40) {
                this.setWarning("Multiple SGF trees; only first one was read");
                return;
            }
            if (n != -1) continue;
            return;
        } while (n == 32 || n == 9 || n == 10 || n == 13);
        this.setWarning("Extra text after SGF tree");
    }

    private String checkForObsoleteLongProps(String string) {
        if (!$assertionsDisabled && string != string.intern()) {
            throw new AssertionError();
        }
        if (string.length() <= 2) {
            return string;
        }
        String string2 = null;
        if (string == "ADDBLACK") {
            string2 = "AB";
        } else if (string == "ADDEMPTY") {
            string2 = "AE";
        } else if (string == "ADDWHITE") {
            string2 = "AW";
        } else if (string == "BLACK") {
            string2 = "B";
        } else if (string == "COMMENT") {
            string2 = "C";
        } else if (string == "DATE") {
            string2 = "DT";
        } else if (string == "GAME") {
            string2 = "GM";
        } else if (string == "HANDICAP") {
            string2 = "HA";
        } else if (string == "KOMI") {
            string2 = "KM";
        } else if (string == "PLAYERBLACK") {
            string2 = "PB";
        } else if (string == "PLAYERWHITE") {
            string2 = "PW";
        } else if (string == "PLAYER") {
            string2 = "PL";
        } else if (string == "RESULT") {
            string2 = "RE";
        } else if (string == "RULES") {
            string2 = "RU";
        } else if (string == "SIZE") {
            string2 = "SZ";
        } else if (string == "WHITE") {
            string2 = "W";
        }
        if (string2 != null) {
            this.setWarning("Verbose names for standard properties");
            return string2;
        }
        return string;
    }

    private void findRoot() throws SgfError, IOException {
        while (true) {
            this.m_tokenizer.nextToken();
            int n = this.m_tokenizer.ttype;
            if (n == 40) {
                this.m_tokenizer.nextToken();
                n = this.m_tokenizer.ttype;
                if (n == 59) {
                    this.m_tokenizer.pushBack();
                    return;
                }
                this.setWarning("Extra text before SGF tree");
                continue;
            }
            if (n == -1) {
                throw this.getError("No root tree found");
            }
            this.setWarning("Extra text before SGF tree");
        }
    }

    private SgfError getError(String string) {
        int n = this.m_tokenizer.lineno();
        if (this.m_name == null) {
            return new SgfError(n + ": " + string);
        }
        String string2 = this.m_name + ":" + n + ": " + string;
        return new SgfError(string2);
    }

    private GoPoint getPointList(int n) {
        return (GoPoint)this.m_pointList.get(n);
    }

    private String getValue(int n) {
        return (String)this.m_values.get(n);
    }

    private GoColor parseColor(String string) throws SgfError {
        GoColor goColor;
        if ((string = string.trim().toLowerCase()).equals("b") || string.equals("1")) {
            goColor = GoColor.BLACK;
        } else if (string.equals("w") || string.equals("2")) {
            goColor = GoColor.WHITE;
        } else {
            throw this.getError("Invalid color value");
        }
        return goColor;
    }

    private int parseInt(String string) throws SgfError {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.getError("Number expected");
        }
        return n;
    }

    private void parseOverTimeProp(String string) {
        if (this.parseOverTimeProp(string, "\\s*(\\d+)\\s*moves\\s*/\\s*(\\d+)\\s*sec\\s*", true, 1000L)) {
            return;
        }
        if (this.parseOverTimeProp(string, "\\s*(\\d+)\\s*moves\\s*/\\s*(\\d+)\\s*min\\s*", true, 60000L)) {
            return;
        }
        if (this.parseOverTimeProp(string, "\\s*(\\d+)x(\\d+)\\s*byo-yomi\\s*", true, 1000L)) {
            return;
        }
        if (this.parseOverTimeProp(string, "\\s*(\\d+)/(\\d+)\\s*canadian\\s*", true, 1000L)) {
            return;
        }
        this.m_ignoreTimeSettings = true;
    }

    private boolean parseOverTimeProp(String string, String string2, boolean bl, long l) {
        Pattern pattern = Pattern.compile(string2, 2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            if (!$assertionsDisabled && matcher.groupCount() != 2) {
                throw new AssertionError();
            }
            try {
                String string3;
                String string4;
                if (bl) {
                    string4 = matcher.group(1);
                    string3 = matcher.group(2);
                } else {
                    string4 = matcher.group(2);
                    string3 = matcher.group(1);
                }
                this.m_byoyomiMoves = Integer.parseInt(string4);
                this.m_byoyomi = (long)(Double.parseDouble(string3) * (double)l);
            }
            catch (NumberFormatException numberFormatException) {
                this.setWarning("Invalid byoyomi values");
                this.m_ignoreTimeSettings = true;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private GoPoint parsePoint(String string) throws SgfError {
        if ((string = string.trim().toLowerCase()).equals("")) {
            return null;
        }
        if (string.length() != 2) {
            throw this.getError("Invalid coordinates: " + string);
        }
        int n = this.m_gameInformation.m_boardSize;
        if (string.equals("tt") && n <= 19) {
            return null;
        }
        int n2 = string.charAt(0) - 97;
        int n3 = n - (string.charAt(1) - 97) - 1;
        if (n2 < 0 || n2 >= n || n3 < 0 || n3 >= n) {
            if (n2 == n && n3 == -1) {
                this.setWarning("Non-standard pass move encoding");
                return null;
            }
            throw this.getError("Invalid coordinates: " + string);
        }
        return GoPoint.get(n2, n3);
    }

    private void parsePointList() throws SgfError {
        this.m_pointList.clear();
        for (int i = 0; i < this.m_values.size(); ++i) {
            GoPoint goPoint;
            String string = this.getValue(i);
            int n = string.indexOf(58);
            if (n < 0) {
                goPoint = this.parsePoint(string);
                if (goPoint == null) {
                    this.setWarning("Point list argument contains PASS");
                    continue;
                }
                this.m_pointList.add(goPoint);
                continue;
            }
            goPoint = this.parsePoint(string.substring(0, n));
            GoPoint goPoint2 = this.parsePoint(string.substring(n + 1));
            if (goPoint == null || goPoint2 == null) {
                this.setWarning("Compressed point list contains PASS");
                continue;
            }
            int n2 = Math.min(goPoint.getX(), goPoint2.getX());
            int n3 = Math.max(goPoint.getX(), goPoint2.getX());
            int n4 = Math.min(goPoint.getY(), goPoint2.getY());
            int n5 = Math.max(goPoint.getY(), goPoint2.getY());
            for (int j = n2; j <= n3; ++j) {
                for (int k = n4; k <= n5; ++k) {
                    this.m_pointList.add(GoPoint.get(j, k));
                }
            }
        }
    }

    private void readKomi(String string) throws SgfError {
        if (string.trim().equals("")) {
            return;
        }
        try {
            this.m_gameInformation.m_komi = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.setWarning("Invalid value for komi");
        }
    }

    private void readMarked(Node node, MarkType markType) throws SgfError {
        this.parsePointList();
        for (int i = 0; i < this.m_pointList.size(); ++i) {
            node.addMarked(this.getPointList(i), markType);
        }
    }

    private Node readNext(Node node, boolean bl) throws IOException, SgfError, SgfCharsetChanged {
        int n;
        if (this.m_progressShow != null) {
            if (this.m_size > 0L) {
                long l = this.m_byteCountInputStream.getCount();
                n = (int)(l * 100L / this.m_size);
            } else {
                n = 100;
            }
            if (n != this.m_lastPercent) {
                this.m_progressShow.showProgress(n);
            }
            this.m_lastPercent = n;
        }
        this.m_tokenizer.nextToken();
        n = this.m_tokenizer.ttype;
        if (n == 40) {
            Node node2 = node;
            while (node2 != null) {
                node2 = this.readNext(node2, false);
            }
            return node;
        }
        if (n == 41) {
            return null;
        }
        if (n == -1) {
            this.setWarning("Game tree not closed");
            return null;
        }
        if (n != 59) {
            throw this.getError("Next node expected");
        }
        Node node3 = new Node();
        node.append(node3);
        while (this.readProp(node3, bl)) {
        }
        return node3;
    }

    private boolean readProp(Node node, boolean bl) throws IOException, SgfError, SgfCharsetChanged {
        this.m_tokenizer.nextToken();
        int n = this.m_tokenizer.ttype;
        if (n == -3) {
            String string;
            String string2 = this.m_tokenizer.sval.toUpperCase().intern();
            this.m_values.clear();
            while ((string = this.readValue()) != null) {
                this.m_values.add(string);
            }
            if (this.m_values.size() == 0) {
                throw this.getError("Property '" + string2 + "' has no value");
            }
            String string3 = this.getValue(0);
            if ((string2 = this.checkForObsoleteLongProps(string2)) == "AB") {
                this.parsePointList();
                for (int i = 0; i < this.m_pointList.size(); ++i) {
                    node.addBlack(this.getPointList(i));
                }
                this.m_sizeFixed = true;
            } else if (string2 == "AE") {
                this.parsePointList();
                for (int i = 0; i < this.m_pointList.size(); ++i) {
                    node.addEmpty(this.getPointList(i));
                }
                this.m_sizeFixed = true;
            } else if (string2 == "AW") {
                this.parsePointList();
                for (int i = 0; i < this.m_pointList.size(); ++i) {
                    node.addWhite(this.getPointList(i));
                }
                this.m_sizeFixed = true;
            } else if (string2 == "B") {
                node.setMove(Move.get(this.parsePoint(string3), GoColor.BLACK));
                this.m_sizeFixed = true;
            } else if (string2 == "BL") {
                try {
                    node.setTimeLeftBlack(Double.parseDouble(string3));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string2 == "BR") {
                this.m_gameInformation.m_blackRank = string3;
            } else if (string2 == "C") {
                String string4 = node.getComment() == null ? string3.trim() : node.getComment() + "\n" + string3.trim();
                node.setComment(string4);
            } else if (string2 == "CA") {
                if (bl && this.m_isFile && this.m_newCharset == null) {
                    this.m_newCharset = string3.trim();
                    if (Charset.isSupported(this.m_newCharset)) {
                        throw new SgfCharsetChanged();
                    }
                }
            } else if (string2 == "CR") {
                this.readMarked(node, MarkType.CIRCLE);
            } else if (string2 == "DT") {
                this.m_gameInformation.m_date = string3;
            } else if (string2 == "FF") {
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n2 < 1 || n2 > 4) {
                    this.setWarning("Unknown SGF file format version");
                }
            } else if (string2 == "GM") {
                if ((string3 = string3.trim()).equals("")) {
                    this.setWarning("Empty value for game type");
                } else if (!string3.equals("1")) {
                    throw this.getError("Not a Go game");
                }
            } else if (string2 == "HA") {
                try {
                    this.m_gameInformation.m_handicap = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setWarning("Invalid handicap value");
                }
            } else if (string2 == "KM") {
                this.readKomi(string3);
            } else if (string2 == "LB") {
                for (int i = 0; i < this.m_values.size(); ++i) {
                    String string5 = this.getValue(i);
                    int n3 = string5.indexOf(58);
                    if (n3 <= 0) continue;
                    GoPoint goPoint = this.parsePoint(string5.substring(0, n3));
                    String string6 = string5.substring(n3 + 1);
                    node.setLabel(goPoint, string6);
                }
            } else if (string2 == "MA" || string2 == "M") {
                this.readMarked(node, MarkType.MARK);
            } else if (string2 == "OB") {
                try {
                    node.setMovesLeftBlack(Integer.parseInt(string3));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string2 == "OM") {
                try {
                    this.m_byoyomiMoves = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setWarning("Invalid value for byoyomi moves");
                    this.m_ignoreTimeSettings = true;
                }
            } else if (string2 == "OP") {
                try {
                    this.m_byoyomi = (long)(Double.parseDouble(string3) * 1000.0);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setWarning("Invalid value for byoyomi time");
                    this.m_ignoreTimeSettings = true;
                }
            } else if (string2 == "OT") {
                this.parseOverTimeProp(string3);
            } else if (string2 == "OW") {
                try {
                    node.setMovesLeftWhite(Integer.parseInt(string3));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string2 == "PB") {
                this.m_gameInformation.m_playerBlack = string3;
            } else if (string2 == "PW") {
                this.m_gameInformation.m_playerWhite = string3;
            } else if (string2 == "PL") {
                node.setPlayer(this.parseColor(string3));
            } else if (string2 == "RE") {
                this.m_gameInformation.m_result = string3;
            } else if (string2 == "RU") {
                this.m_gameInformation.m_rules = string3;
            } else if (string2 == "SQ") {
                this.readMarked(node, MarkType.SQUARE);
            } else if (string2 == "SL") {
                this.readMarked(node, MarkType.SELECT);
            } else if (string2 == "SZ") {
                if (!bl) {
                    if (this.m_sizeFixed) {
                        throw this.getError("Size property outside root node");
                    }
                    this.setWarning("Size property not in root node");
                }
                try {
                    this.m_gameInformation.m_boardSize = this.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setWarning("Invalid board size value");
                }
                this.m_sizeFixed = true;
            } else if (string2 == "TB") {
                this.readMarked(node, MarkType.TERRITORY_BLACK);
            } else if (string2 == "TM") {
                this.readTime(string3);
            } else if (string2 == "TR") {
                this.readMarked(node, MarkType.TRIANGLE);
            } else if (string2 == "W") {
                node.setMove(Move.get(this.parsePoint(string3), GoColor.WHITE));
                this.m_sizeFixed = true;
            } else if (string2 == "TW") {
                this.readMarked(node, MarkType.TERRITORY_WHITE);
            } else if (string2 == "V") {
                try {
                    node.setValue(Float.parseFloat(string3));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string2 == "WL") {
                try {
                    node.setTimeLeftWhite(Double.parseDouble(string3));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string2 == "WR") {
                this.m_gameInformation.m_whiteRank = string3;
            } else if (string2 != "FF" && string2 != "GN" && string2 != "AP") {
                this.addSgfProperty(node, string2);
            }
            return true;
        }
        if (n != 10) {
            this.m_tokenizer.pushBack();
        }
        return false;
    }

    private void readSgf(InputStream inputStream, String string) throws SgfError, SgfCharsetChanged {
        try {
            InputStreamReader inputStreamReader;
            this.m_gameInformation = new GameInformation(19);
            this.m_sizeFixed = false;
            if (this.m_progressShow != null) {
                this.m_byteCountInputStream = new ByteCountInputStream(inputStream);
                inputStream = this.m_byteCountInputStream;
            }
            try {
                inputStreamReader = new InputStreamReader(inputStream, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                inputStreamReader = new InputStreamReader(inputStream);
            }
            this.m_reader = new BufferedReader(inputStreamReader);
            this.m_tokenizer = new StreamTokenizer(this.m_reader);
            this.findRoot();
            Node node = new Node();
            Node node2 = this.readNext(node, true);
            while (node2 != null) {
                node2 = this.readNext(node2, false);
            }
            this.checkEndOfFile();
            if (node.getNumberChildren() == 1) {
                node = node.getChild();
                node.setFather(null);
            }
            this.setTimeSettings();
            this.m_gameTree = new GameTree(this.m_gameInformation, node);
            this.applyFixes();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SgfError("File not found");
        }
        catch (IOException iOException) {
            throw new SgfError("IO error");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new SgfError("Out of memory");
        }
    }

    private String readValue() throws IOException, SgfError {
        this.m_tokenizer.nextToken();
        int n = this.m_tokenizer.ttype;
        if (n != 91) {
            if (n != 10) {
                this.m_tokenizer.pushBack();
            }
            return null;
        }
        this.m_buffer.setLength(0);
        boolean bl = false;
        while (true) {
            int n2;
            if ((n2 = this.m_reader.read()) < 0) {
                throw this.getError("Property value incomplete");
            }
            if (!bl) {
                if (n2 == 93) break;
                bl = n2 == 92;
                if (bl) continue;
                this.m_buffer.append((char)n2);
                continue;
            }
            if (n2 == 10 || n2 == 13) continue;
            this.m_buffer.append((char)n2);
            bl = false;
        }
        return this.m_buffer.toString();
    }

    private void readTime(String string) {
        if (string.trim().equals("")) {
            return;
        }
        try {
            this.m_preByoyomi = (long)(Double.parseDouble(string) * 1000.0);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            block9: {
                try {
                    Pattern pattern = Pattern.compile("(\\d{1,2}+):(\\d\\d)");
                    Matcher matcher = pattern.matcher(string.trim());
                    if (matcher.matches()) {
                        if (!$assertionsDisabled && matcher.groupCount() != 2) {
                            throw new AssertionError();
                        }
                        this.m_preByoyomi = (Integer.parseInt(matcher.group(1)) * 60 + Integer.parseInt(matcher.group(2))) * 1000;
                        return;
                    }
                    pattern = Pattern.compile("(\\d+):(\\d\\d):(\\d\\d)");
                    matcher = pattern.matcher(string.trim());
                    if (matcher.matches()) {
                        if (!$assertionsDisabled && matcher.groupCount() != 3) {
                            throw new AssertionError();
                        }
                        this.m_preByoyomi = (Integer.parseInt(matcher.group(1)) * 3600 + Integer.parseInt(matcher.group(2)) * 60 + Integer.parseInt(matcher.group(3))) * 1000;
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException2) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError();
                }
            }
            this.setWarning("Invalid value for time");
            this.m_ignoreTimeSettings = true;
            return;
        }
    }

    private void setTimeSettings() {
        if (this.m_ignoreTimeSettings || this.m_preByoyomi <= 0L) {
            return;
        }
        if (this.m_byoyomi <= 0L || this.m_byoyomiMoves <= 0) {
            this.m_gameInformation.m_timeSettings = new TimeSettings(this.m_preByoyomi);
            return;
        }
        this.m_gameInformation.m_timeSettings = new TimeSettings(this.m_preByoyomi, this.m_byoyomi, this.m_byoyomiMoves);
    }

    private void setWarning(String string) {
        this.m_warnings.add(string);
    }

    static {
        $assertionsDisabled = !SgfReader.class.desiredAssertionStatus();
    }

    private static class SgfCharsetChanged
    extends Exception {
        private static final long serialVersionUID = 0L;

        private SgfCharsetChanged() {
        }
    }

    public static class SgfError
    extends ErrorMessage {
        private static final long serialVersionUID = 0L;

        public SgfError(String string) {
            super(string);
        }
    }
}

