/*-----------------------------------------*
 *-------- GnuDip.cmd for OS/2 ----------*
 * lan.to@tiscali.it 
 * 
 * Maded for DynDns.it
 * 
 * See gnudip2.sourgeforge.net about setting up a dynamic DNS
 *
 * http://gnudip2.sourceforge.net/gnudip-www/latest/gnudip/html/protocol.html
 *
 * Based on dnsalias (Tx to all)  
 * 
 * Command line switches used by the program.
 *
 *---------------------------------------------------------------*
 * 25th January 2004, Bruce Dudley
 *
 * 29th August 2002  Bruce Dudley
 *
 * Modified by Bruce Dudley os2box@transit.homeip.net on 05-12-2001
 *
 * Modified by Vinicius Beltrao on 07-23-2000

 * Original by Dennis Peterson on 7-27-97 for usage with the old ml.org
 *
 * Archive includes b64rx.dll which encodes the userid:password string
 * The b64rx.dll code was created by Teet Knnussaar (teet@aetec.estnet.ee)
 *
 * Requires rxsock.dll
 * Requires Md5Rx.dll  Created by Teet Knnussaar (teet@aetec.estnet.ee)
 * This code is free to everyone. 
 * ( but sent me an e.mail please ! lan.to@tiscali.it)
 * --------------------------------------------------------------*/

trace e
signal on halt

/*---------------------------------*
 *--- Initialize REXX utilities ---*
 *---------------------------------*/
if RxFuncQuery("SysLoadFuncs") then
  do
    Call RxFuncAdd "Sysloadfuncs","RexxUtil","Sysloadfuncs"
    Call SysLoadFuncs
  end

/*------------------------------------*
 *--- Initialize md5rx API package ---*
 *------------------------------------*/

call rxfuncadd 'B64encode','md5rx','B64encode'
call rxfuncadd 'B64decode','md5rx','B64decode'
call rxfuncadd 'MD5String','md5rx','MD5String'

/*---------------------------------*
 *--- Initialize socket package ---*
 *---------------------------------*/
if RxFuncQuery("SockLoadFuncs") then
    do
      rc = RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
      rc = SockLoadFuncs(NoCopyright)
    end
/*---------------------------------------------------------------*
 *----------------- START of USER config area -------------------*
 *---------------------------------------------------------------*/

loginname = "*****"            
password = "*******"
hostname = "lan.ns0.it" 
dominio = "ns0.it"

/***** Server to contact for DNS change ********/

server = "slim.impulso.it"
BaseURL = "/gnudip/cgi-bin/gdipupdt.cgi"
port = "80"
interface = "ppp0"


/*-----------------------------------------------------------------------*
 *------------------- END of USER config area ---------------------------*
 *-----------------------------------------------------------------------*/
crlf = "0d0a"x
User_Agent="User-Agent: RxDip/2-0.4" 

/*-------------------------------------------------------------------*
 *--- Obtain switch from command line and decide if we are to -------*
 *-------------------------------------------------------------------*/
parse arg action
if action='' then azione=2
else azione=1

'@ifconfig' interface' | find /i "inet" | rxqueue'
if queued() <> 0 then do
   Parse Pull lin
   Parse Var lin "." -5 . mydip . remoteip .
end
/*------------------------------------------------------------*
 *--- Initialize http variables - Yes -- rexx can to HTML! ---*
 *------------------------------------------------------------*/
URL = "GET " || BaseURL
URL = URL || " HTTP/1.0" || crlf
URL = URL || "Host: "hostname":"port || crlf
URL = URL || User_Agent || crlf 
URL = URL || "Pragma: no-cache" || crlf || crlf 

/*------------------------*
 * --- Get server name ---*
 *------------------------*/
rc = SockGetHostByName(server,"host.!")
if (rc = 0) then
   do
      say "Error" h_errno "calling SockGetHostByName("server")"
      exit
   end

If azione='2' then Say "Register address " mydip " to " server

Ipserver = host.!addr;

Call Open_Socket
Call Connect_Socket
Data=URL
Call Send_Socket 
Call Receive_Socket
Call Close_Socket
/*--------------------------------------*
 *--- Check results received         ---*
 *--------------------------------------*/
   if pos('Salt generated',returnData) = 0 then do
        say 'Find Page.'crlf
   end
   else do
	if pos('salt',returnData) > 0 then do
           NewSalt = SubStr(returnData,(pos('salt',returnData) + 15),10)
        end
	if pos('time',returnData) > 0 then do
           NewTime = SubStr(returnData,(pos('time',returnData) + 15),10)
        end
	if pos('sign',returnData) > 0 then do
           NewSign = SubStr(returnData,(pos('sign',returnData) + 15),32)
        end
   end

/*----------------------------------------*
 *--- Second Step                      ---*
 *--- 1) Encoding Password             ---*
 *--- 2) Append dot and salt           ---*
 *--- 3) Digest the string             ---*
 *----------------------------------------*/
NewPass=MD5String(password)
NewPass=C2X(NewPass)
call lowercase
NewPass=NewPass'.'NewSalt
NewPass=MD5String(NewPass)
NewPass=C2X(NewPass)
call lowercase 

/*----------------------------------------*
 *--- Other GET                        ---*
 *----------------------------------------*/
URL = "GET " || BaseURL || "?"
URL = URL || "salt="NewSalt || "&"
URL = URL || "time="NewTime || "&"
URL = URL || "sign="NewSign || "&"
URL = URL || "user="loginname || "&" 
URL = URL || "domn="dominio || "&"
URL = URL || "pass="NewPass || "&"
URL = URL || "reqc="Azione
URL = URL || " HTTP/1.0" || crlf
URL = URL || User_Agent || crlf 
URL = URL || "Pragma: no-cache" || crlf || crlf 


Data=URL

Call Open_Socket
Call Connect_Socket
Call Send_Socket 
Call Receive_Socket

/*----------------------------------------*
 *---  Namo a vede che succede         ---*
 *----------------------------------------*/
if pos('retc',returnData) > 0 then do
  Rcode = SubStr(returnData,(pos('retc',returnData) + 15),1)
end

Select 
    when  Rcode=0 then Say "Successful registered"
    when  Rcode=2 then Say "Successful deregistered"
 otherwise say "Error" 
end



/*----------------------------------------*
 *--- Close socket (and catch signals) ---*
 *----------------------------------------*/
halt:
Call Close_Socket
rc = SockDropFuncs()
exit 0    /* Exit the Program */


/*-------------------*
 *--- Open socket ---*
 *-------------------*/
Open_Socket:

socket  = SockSocket("AF_INET","SOCK_STREAM",0)
if (socket = -1) then
  do
     say "Error on SockSocket:" errno
     exit
end
return

/*----------------------*
 *--- Connect socket ---*
 *----------------------*/
Connect_Socket:
server.!family = "AF_INET"
server.!port   = port
server.!addr   = IpServer

rc = SockConnect(socket,"server.!")
if (rc = -1) then
   do
      say "Error on SockConnect:" errno
      exit
   end
return

/*----------------------------------------*
 *--- Send data over socket            ---*
 *----------------------------------------*/
Send_Socket:

rc = SockSend(socket, data)
if (rc = -1) then
   do
      say "Error on SockSend URL:" errno
      exit
   end
return

/*------------------------------------------*
 *--- Receive the result from the server ---*
 *------------------------------------------*/
Receive_socket:
returnData=''
newData=''
do until rc = 0
   say "Waiting Receiving data rc=" rc
   rc = SockRecv(socket,"newData",256)
   returnData = returnData || newData
end
return

/*------------------------------------------*
 *--- Closes socket                      ---*
 *------------------------------------------*/
Close_Socket:
rc = SockSoClose(socket)
if (rc = -1) then say "Error on SockSoClose:" errno
return

/*------------------------------------------*
 *--- LowerCase                          ---*
 *------------------------------------------*/
LowerCase:
NewPass=Translate(NewPass,'abcdef','ABCDEF')
return

