/*
 * Installation Program for Gismo
 *
 * [HISTORY]
 * Revision 1 (04.Aug.2000)
 * > Renewal.
 * Revision 2 (18.Jan.2001)
 * > Fix problem.
 * Revision 3 (02.May.2001)
 * > Create Gismo Color Palette.
 *
 *
 */
rc = RxFuncAdd( "SysLoadFuncs", "RexxUtil", "SysLoadFuncs")

DIR = directory()

APL_FOLDER_NAME = "Gismo"
APL_FOLDER_ID   = "<GISMO_FOLDER>"

APL_EXE_NAME = "Gismo"
APL_EXE_FILE = DIR"\GISMO.EXE"
APL_EXE_ID   = "<GISMO>"

README_E_FILE = DIR"\readme_e.htm"
README_E_NAME = "Readme English"

README_J_FILE = DIR"\readme_j.htm"
README_J_NAME = "Readme Japanese"


say ""
say " Install Gismo..."
say ""

/* Create Folders */
/* 1. Pretty Pop Software Main Folder */
if SysCreateObject( 'WPFolder', 'Pretty Pop Software', '<WP_DESKTOP>', "OBJECTID=<PRETTY_POP_SOFTWARE>", "u" ) then do
    say ' Create Folder : Pretty Pop Software'
end

/* 2. Application Folder */
if SysCreateObject( 'WPFolder', APL_FOLDER_NAME, '<PRETTY_POP_SOFTWARE>', "OBJECTID="APL_FOLDER_ID, "u" ) then do
    say " Create Folder : "APL_FOLDER_NAME
end

/* Create Objects */
parameter = "EXENAME="APL_EXE_FILE";STARTUPDIR="directory()";OBJECTID="APL_EXE_ID
if SysCreateObject('WPProgram', APL_EXE_NAME, APL_FOLDER_ID, parameter, 'u') then do
    say " Create Object : "APL_EXE_NAME
end

if SysCreateShadow(APL_EXE_ID, "<WP_DESKTOP>") then do
    say " Create Object : "APL_EXE_NAME
end

if SysCreateObject( 'WPUrl', README_J_NAME, APL_FOLDER_ID, 'URL=file:///'README_J_FILE, "u" ) then do
    say " Create Object : "README_J_NAME
end

if SysCreateObject( 'WPUrl', README_E_NAME, APL_FOLDER_ID, 'URL=file:///'README_E_FILE, "u" ) then do
    say " Create Object : "README_E_NAME
end



if SysCreateObject( 'WPFolder', 'Gismo Color Palette', '<GISMO_FOLDER>', "OBJECTID=<GISMO_COLORPALETTE_FOLDER>", "u" ) then do
    say ' Create Folder : Gismo Color Palette Folder'
end


place = "<GISMO_COLORPALETTE_FOLDER>"

modus = 'Replace'

AUTOSETUP="HIRES"
XCELLCOUNT=10
YCELLCOUNT=14
XCELLWIDTH=30
YCELLHEIGHT=20
XCELLGAP=5
YCELLGAP=5

GismoColorPaletteName = "Gismo Color Palette^Color Name^Sort by Name"
OBJECTID="<GCP_ColorName_Name>"
COLORS_01="0x008080,0xD8BFD8,0xFF6347,0x40E0D0,0xEE82EE,0xF5DEB3,0xFFFFFF,0xF5F5F5,0xFFFF00,0x9ACD32,0xFFF5EE,0xA0522D,0xC0C0C0,0x87CEEB,0x6A5ACD,"
COLORS_02="0x708090,0xFFFAFA,0x00FF7F,0x4682B4,0xD2B48C,0xDDA0DD,0xB0E0E6,0x800080,0xFF0000,0xBC8F8F,0x4169E1,0x8B4513,0xFA8072,0xF4A460,0x2E8B57,"
COLORS_03="0xFF4500,0xDA70D6,0xEEE8AA,0x98FB98,0xAFEEEE,0xDB7093,0xFFEFD5,0xFFDAB9,0xCD853F,0xFFC0CB,0x191970,0xF5FFFA,0xFFE4E1,0xFFE4B5,0xFFDEAD,"
COLORS_04="0x000080,0xFDF5E6,0x808000,0x6B8E23,0xFFA500,0x800000,0x66CDAA,0x0000CD,0xBA55D3,0x9370DB,0x3CB371,0x7B68EE,0x00FA9A,0x48D1CC,0xC71585,"
COLORS_05="0xFFA07A,0x20B2AA,0x87CEFA,0x778899,0xB0C4DE,0xFFFFE0,0x00FF00,0x32CD32,0xFAF0E6,0xFF00FF,0xFFF0F5,0x7CFC00,0xFFFACD,0xADD8E6,0xF08080,"
COLORS_06="0xE0FFFF,0xFAFAD2,0x90EE90,0xD3D3D3,0xFFB6C1,0x808080,0x008000,0xADFF2F,0xF0FFF0,0xFF69B4,0xCD5C5C,0x4B0082,0xFFFFF0,0xF0E68C,0xE6E6FA,"
COLORS_07="0x696969,0x1E90FF,0xB22222,0xFFFAF0,0x228B22,0xFF00FF,0xDCDCDC,0xF8F8FF,0xFFD700,0xDAA520,0x9932CC,0x8B0000,0xE9967A,0x8FBC8F,0x483D8B,"
COLORS_08="0x2F4F4F,0x00CED1,0x9400D3,0xFF1493,0x00BFFF,0x00FFFF,0x00008B,0x008B8B,0xB8860B,0xA9A9A9,0x006400,0xBDB76B,0x8B008B,0x556B2F,0xFF8C00,"
COLORS_09="0x8A2BE2,0xA52A2A,0xDEB887,0x5F9EA0,0x7FFF00,0xD2691E,0xFF7F50,0x6495ED,0xFFF8DC,0xDC143C,0xF0F8FF,0xFAEBD7,0x00FFFF,0x7FFFD4,0xF0FFFF,"
COLORS_10="0xF5F5DC,0xFFE4C4,0x000000,0xFFEBCD,0x0000FF"

COLORS=COLORS_01""COLORS_02""COLORS_03""COLORS_04""COLORS_05""COLORS_06""COLORS_07""COLORS_08""COLORS_09""COLORS_10
setup = "OBJECTID="OBJECTID";AUTOSETUP="AUTOSETUP";XCELLCOUNT="XCELLCOUNT";YCELLCOUNT="YCELLCOUNT";XCELLWIDTH="XCELLWIDTH";YCELLHEIGHT="YCELLHEIGHT";XCELLGAP="XCELLGAP";YCELLGAP="XCELLGAP";COLORS="COLORS
rc = SysCreateObject("WPColorPalette", GismoColorPaletteName, place, setup, modus);
if rc = 1 then say " Create Gismo Color Palette : "translate(GismoColorPaletteName, " ", "^")


GismoColorPaletteName = "Gismo Color Palette^Color Name^Sort by Hue"
OBJECTID="<GCP_ColorName_Hue>"
COLORS_01="0xFFFAFA,0xFFFFFF,0xF5F5F5,0xDCDCDC,0xD3D3D3,0xC0C0C0,0xA9A9A9,0x808080,0x696969,0x000000,0xFA8072,0xFFE4E1,0xFF0000,0x8B0000,0x800000,"
COLORS_02="0xB22222,0xA52A2A,0xCD5C5C,0xF08080,0xBC8F8F,0xF4A460,0x8B4513,0xD2691E,0xFFF5EE,0xA0522D,0xFFA07A,0xFF4500,0xFF7F50,0xE9967A,0xFF6347,"
COLORS_03="0xFFDEAD,0xFFEBCD,0xD2B48C,0xFAEBD7,0xDEB887,0xFF8C00,0xFFE4C4,0xCD853F,0xFAF0E6,0xFFDAB9,0xFFD700,0xFFF8DC,0xB8860B,0xDAA520,0xF5DEB3,"
COLORS_04="0xFDF5E6,0xFFFAF0,0xFFA500,0xFFE4B5,0xFFEFD5,0xFFFF00,0x808000,0xFAFAD2,0xFFFFE0,0xF5F5DC,0xFFFFF0,0xBDB76B,0xEEE8AA,0xF0E68C,0xFFFACD,"
COLORS_05="0x98FB98,0x90EE90,0x8FBC8F,0xF0FFF0,0x7FFF00,0x7CFC00,0xADFF2F,0x556B2F,0x9ACD32,0x6B8E23,0x00FA9A,0x00FF7F,0xF5FFFA,0x2E8B57,0x3CB371,"
COLORS_06="0x00FF00,0x008000,0x006400,0x32CD32,0x228B22,0x008080,0x2F4F4F,0xAFEEEE,0xE0FFFF,0xF0FFFF,0x48D1CC,0x20B2AA,0x40E0D0,0x7FFFD4,0x66CDAA,"
COLORS_07="0x87CEFA,0x87CEEB,0x00BFFF,0xADD8E6,0xB0E0E6,0x5F9EA0,0x00FFFF,0x00FFFF,0x00CED1,0x008B8B,0xE6E6FA,0xF8F8FF,0x4169E1,0x6495ED,0xB0C4DE,"
COLORS_08="0x778899,0x708090,0x1E90FF,0xF0F8FF,0x4682B4,0x8A2BE2,0x9370DB,0x7B68EE,0x6A5ACD,0x483D8B,0x0000FF,0x0000CD,0x00008B,0x000080,0x191970,"
COLORS_09="0xFF00FF,0x8B008B,0x800080,0xEE82EE,0xDDA0DD,0xD8BFD8,0xBA55D3,0x9400D3,0x9932CC,0x4B0082,0xFFB6C1,0xFFC0CB,0xDC143C,0xDB7093,0xFFF0F5,"
COLORS_10="0xFF69B4,0xFF1493,0xC71585,0xDA70D6,0xFF00FF"

COLORS=COLORS_01""COLORS_02""COLORS_03""COLORS_04""COLORS_05""COLORS_06""COLORS_07""COLORS_08""COLORS_09""COLORS_10
setup = "OBJECTID="OBJECTID";AUTOSETUP="AUTOSETUP";XCELLCOUNT="XCELLCOUNT";YCELLCOUNT="YCELLCOUNT";XCELLWIDTH="XCELLWIDTH";YCELLHEIGHT="YCELLHEIGHT";XCELLGAP="XCELLGAP";YCELLGAP="XCELLGAP";COLORS="COLORS
rc = SysCreateObject("WPColorPalette", GismoColorPaletteName, place, setup, modus);
if rc = 1 then say " Create Gismo Color Palette : "translate(GismoColorPaletteName, " ", "^")


GismoColorPaletteName = "Gismo Color Palette^Color Name^Sort by Saturation"
OBJECTID="<GCP_ColorName_Saturation>"
COLORS_01="0xFFFAFA,0xFFFFFF,0xF5F5F5,0xDCDCDC,0xD3D3D3,0xC0C0C0,0xA9A9A9,0x808080,0x696969,0x000000,0xFAF0E6,0xFFF5EE,0xFFF0F5,0xF0F8FF,0xF0FFFF,"
COLORS_02="0xF0FFF0,0xFFFFF0,0xFFFAF0,0xF5FFFA,0xF8F8FF,0xFAFAD2,0xFFF8DC,0xFAEBD7,0xE0FFFF,0xFFFFE0,0xFFE4E1,0xD8BFD8,0xF5F5DC,0xFDF5E6,0xE6E6FA,"
COLORS_03="0x8FBC8F,0xBC8F8F,0xFFE4C4,0xB0E0E6,0x778899,0x708090,0xB0C4DE,0xFFFACD,0xFFEBCD,0xFFEFD5,0xFFDEAD,0xFFE4B5,0xFFB6C1,0xEEE8AA,0xFFDAB9,"
COLORS_04="0xDDA0DD,0xF5DEB3,0xAFEEEE,0xFFC0CB,0xADD8E6,0xEE82EE,0xBDB76B,0x87CEEB,0xF0E68C,0x5F9EA0,0x2F4F4F,0x98FB98,0x90EE90,0xDEB887,0xD2B48C,"
COLORS_05="0xFA8072,0xFFA07A,0x7FFFD4,0x66CDAA,0xDB7093,0x9370DB,0xDA70D6,0xE9967A,0xF08080,0x87CEFA,0x4682B4,0xF4A460,0xBA55D3,0xFF69B4,0x6495ED,"
COLORS_06="0x7B68EE,0x6A5ACD,0x483D8B,0x556B2F,0xCD5C5C,0xA52A2A,0xFF6347,0xA0522D,0x40E0D0,0x4169E1,0xCD853F,0xFF7F50,0x2E8B57,0x3CB371,0x48D1CC,"
COLORS_07="0x20B2AA,0xADFF2F,0x8A2BE2,0xB22222,0x191970,0x32CD32,0x9ACD32,0x9932CC,0x6B8E23,0x228B22,0x800000,0x006400,0xB8860B,0xFF1493,0xDC143C,"
COLORS_08="0xC71585,0x1E90FF,0x8B4513,0xD2691E,0xDAA520,0x8B008B,0x00008B,0x008B8B,0x8B0000,0x4B0082,0x800080,0x000080,0x008080,0x008000,0x808000,"
COLORS_09="0xFFD700,0xFFA500,0xFF8C00,0xFF4500,0xFF0000,0x7CFC00,0x00FA9A,0x9400D3,0x00CED1,0x0000CD,0xFF00FF,0xFF00FF,0x0000FF,0x00BFFF,0x00FFFF,"
COLORS_10="0x00FFFF,0x00FF7F,0x00FF00,0x7FFF00,0xFFFF00"

COLORS=COLORS_01""COLORS_02""COLORS_03""COLORS_04""COLORS_05""COLORS_06""COLORS_07""COLORS_08""COLORS_09""COLORS_10
setup = "OBJECTID="OBJECTID";AUTOSETUP="AUTOSETUP";XCELLCOUNT="XCELLCOUNT";YCELLCOUNT="YCELLCOUNT";XCELLWIDTH="XCELLWIDTH";YCELLHEIGHT="YCELLHEIGHT";XCELLGAP="XCELLGAP";YCELLGAP="XCELLGAP";COLORS="COLORS
rc = SysCreateObject("WPColorPalette", GismoColorPaletteName, place, setup, modus);
if rc = 1 then say " Create Gismo Color Palette : "translate(GismoColorPaletteName, " ", "^")


GismoColorPaletteName = "Gismo Color Palette^Color Name^Sort by Value"
OBJECTID="<GCP_ColorName_Value>"
COLORS_01="0x008000,0x808000,0x800000,0x808080,0x191970,0x556B2F,0x696969,0x006400,0x2F4F4F,0x000000,0x008B8B,0x8B0000,0x8B4513,0x228B22,0x2E8B57,"
COLORS_02="0x483D8B,0x4B0082,0x800080,0x000080,0x008080,0xB22222,0xA9A9A9,0xA52A2A,0xA0522D,0x5F9EA0,0x778899,0x708090,0x6B8E23,0x8B008B,0x00008B,"
COLORS_03="0x9932CC,0xC71585,0xC0C0C0,0xBDB76B,0x8FBC8F,0xBC8F8F,0xB8860B,0x4682B4,0x3CB371,0x20B2AA,0xD2B48C,0x00CED1,0x48D1CC,0x0000CD,0x32CD32,"
COLORS_04="0x9ACD32,0xCD853F,0x6A5ACD,0xCD5C5C,0x66CDAA,0xDCDCDC,0xDB7093,0x9370DB,0xDAA520,0xDA70D6,0xD8BFD8,0x9400D3,0xBA55D3,0xD3D3D3,0xD2691E,"
COLORS_05="0xE9967A,0xADD8E6,0xB0E0E6,0x8A2BE2,0x4169E1,0x40E0D0,0xDEB887,0xB0C4DE,0xDDA0DD,0xDC143C,0xF4A460,0xF08080,0xF0E68C,0x7B68EE,0xEE82EE,"
COLORS_06="0x90EE90,0xEEE8AA,0xAFEEEE,0x6495ED,0x87CEEB,0x00FA9A,0xFA8072,0x87CEFA,0xFAFAD2,0xFAEBD7,0xE6E6FA,0xFAF0E6,0xF5DEB3,0xF5F5DC,0xF5F5F5,"
COLORS_07="0xF0FFF0,0xFFFFF0,0xFFFAF0,0xF5FFFA,0xF8F8FF,0xFFFAFA,0xFFFFFF,0xFDF5E6,0x7CFC00,0x98FB98,0xFFEBCD,0xFFEFD5,0xFFF8DC,0xE0FFFF,0xFFFFE0,"
COLORS_08="0xFFE4E1,0xFFF5EE,0xFFF0F5,0xF0F8FF,0xF0FFFF,0xFF69B4,0xFFA07A,0x7FFFD4,0xFFDEAD,0xFFE4B5,0xFFB6C1,0xFFDAB9,0xFFC0CB,0xFFE4C4,0xFFFACD,"
COLORS_09="0xFFD700,0xFFA500,0xFF8C00,0xFF4500,0xFF0000,0xFF1493,0x1E90FF,0xADFF2F,0xFF6347,0xFF7F50,0xFF00FF,0xFF00FF,0x0000FF,0x00BFFF,0x00FFFF,"
COLORS_10="0x00FFFF,0x00FF7F,0x00FF00,0x7FFF00,0xFFFF00"

COLORS=COLORS_01""COLORS_02""COLORS_03""COLORS_04""COLORS_05""COLORS_06""COLORS_07""COLORS_08""COLORS_09""COLORS_10
setup = "OBJECTID="OBJECTID";AUTOSETUP="AUTOSETUP";XCELLCOUNT="XCELLCOUNT";YCELLCOUNT="YCELLCOUNT";XCELLWIDTH="XCELLWIDTH";YCELLHEIGHT="YCELLHEIGHT";XCELLGAP="XCELLGAP";YCELLGAP="XCELLGAP";COLORS="COLORS
rc = SysCreateObject("WPColorPalette", GismoColorPaletteName, place, setup, modus);
if rc = 1 then say " Create Gismo Color Palette : "translate(GismoColorPaletteName, " ", "^")



YCELLCOUNT=22

GismoColorPaletteName = "Gismo Color Palette^216 Color Palette^Sort by Name"
OBJECTID="<GCP_216ColorPalette_Name>"
COLORS_01="0xFFFF00,0xFFFF33,0xFFFF66,0xFFFF99,0xFFFFCC,0xFFFFFF,0x000000,0x000000,0x000000,0x000000,0xFF9966,0xFF9999,0xFF99CC,0xFF99FF,0xFFCC00,"
COLORS_02="0xFFCC33,0xFFCC66,0xFFCC99,0xFFCCCC,0xFFCCFF,0xFF33CC,0xFF33FF,0xFF6600,0xFF6633,0xFF6666,0xFF6699,0xFF66CC,0xFF66FF,0xFF9900,0xFF9933,"
COLORS_03="0xFF0000,0xFF0033,0xFF0066,0xFF0099,0xFF00CC,0xFF00FF,0xFF3300,0xFF3333,0xFF3366,0xFF3399,0xCCCC66,0xCCCC99,0xCCCCCC,0xCCCCFF,0xCCFF00,"
COLORS_04="0xCCFF33,0xCCFF66,0xCCFF99,0xCCFFCC,0xCCFFFF,0xCC66CC,0xCC66FF,0xCC9900,0xCC9933,0xCC9966,0xCC9999,0xCC99CC,0xCC99FF,0xCCCC00,0xCCCC33,"
COLORS_05="0xCC3300,0xCC3333,0xCC3366,0xCC3399,0xCC33CC,0xCC33FF,0xCC6600,0xCC6633,0xCC6666,0xCC6699,0x99FF66,0x99FF99,0x99FFCC,0x99FFFF,0xCC0000,"
COLORS_06="0xCC0033,0xCC0066,0xCC0099,0xCC00CC,0xCC00FF,0x9999CC,0x9999FF,0x99CC00,0x99CC33,0x99CC66,0x99CC99,0x99CCCC,0x99CCFF,0x99FF00,0x99FF33,"
COLORS_07="0x996600,0x996633,0x996666,0x996699,0x9966CC,0x9966FF,0x999900,0x999933,0x999966,0x999999,0x990066,0x990099,0x9900CC,0x9900FF,0x993300,"
COLORS_08="0x993333,0x993366,0x993399,0x9933CC,0x9933FF,0x66CCCC,0x66CCFF,0x66FF00,0x66FF33,0x66FF66,0x66FF99,0x66FFCC,0x66FFFF,0x990000,0x990033,"
COLORS_09="0x669900,0x669933,0x669966,0x669999,0x6699CC,0x6699FF,0x66CC00,0x66CC33,0x66CC66,0x66CC99,0x663366,0x663399,0x6633CC,0x6633FF,0x666600,"
COLORS_10="0x666633,0x666666,0x666699,0x6666CC,0x6666FF,0x33FFCC,0x33FFFF,0x660000,0x660033,0x660066,0x660099,0x6600CC,0x6600FF,0x663300,0x663333,"
COLORS_11="0x33CC00,0x33CC33,0x33CC66,0x33CC99,0x33CCCC,0x33CCFF,0x33FF00,0x33FF33,0x33FF66,0x33FF99,0x336666,0x336699,0x3366CC,0x3366FF,0x339900,"
COLORS_12="0x339933,0x339966,0x339999,0x3399CC,0x3399FF,0x3300CC,0x3300FF,0x333300,0x333333,0x333366,0x333399,0x3333CC,0x3333FF,0x336600,0x336633,"
COLORS_13="0x00FF00,0x00FF33,0x00FF66,0x00FF99,0x00FFCC,0x00FFFF,0x330000,0x330033,0x330066,0x330099,0x009966,0x009999,0x0099CC,0x0099FF,0x00CC00,"
COLORS_14="0x00CC33,0x00CC66,0x00CC99,0x00CCCC,0x00CCFF,0x0033CC,0x0033FF,0x006600,0x006633,0x006666,0x006699,0x0066CC,0x0066FF,0x009900,0x009933,"
COLORS_15="0x000000,0x000033,0x000066,0x000099,0x0000CC,0x0000FF,0x003300,0x003333,0x003366,0x003399"

COLORS=COLORS_01""COLORS_02""COLORS_03""COLORS_04""COLORS_05""COLORS_06""COLORS_07""COLORS_08""COLORS_09""COLORS_10""COLORS_11""COLORS_12""COLORS_13""COLORS_14""COLORS_15
setup = "OBJECTID="OBJECTID";AUTOSETUP="AUTOSETUP";XCELLCOUNT="XCELLCOUNT";YCELLCOUNT="YCELLCOUNT";XCELLWIDTH="XCELLWIDTH";YCELLHEIGHT="YCELLHEIGHT";XCELLGAP="XCELLGAP";YCELLGAP="XCELLGAP";COLORS="COLORS
rc = SysCreateObject("WPColorPalette", GismoColorPaletteName, place, setup, modus);
if rc = 1 then say " Create Gismo Color Palette : "translate(GismoColorPaletteName, " ", "^")


GismoColorPaletteName = "Gismo Color Palette^216 Color Palette^Sort by Hue"
OBJECTID="<GCP_216ColorPalette_Hue>"
COLORS_01="0xFFFFFF,0xCCCCCC,0x999999,0x666666,0x333333,0x000000,0x000000,0x000000,0x000000,0x000000,0xFF3333,0xCC3333,0x993333,0xFF6666,0xCC6666,"
COLORS_02="0x663333,0xFF9999,0x996666,0xCC9999,0xFFCCCC,0xCC6633,0xFF9966,0xCC3300,0xFF6633,0xFF3300,0xFF0000,0xCC0000,0x990000,0x660000,0x330000,"
COLORS_03="0xFFCC66,0xFF9900,0xCC6600,0x663300,0xFF9933,0x996633,0xCC9966,0xFFCC99,0xFF6600,0x993300,0x666633,0xFFFF99,0x999966,0xCCCC99,0xFFFFCC,"
COLORS_04="0xFFCC00,0xCC9900,0xFFCC33,0x996600,0xCC9933,0xFFFF00,0xCCCC00,0x999900,0x666600,0x333300,0xFFFF33,0xCCCC33,0x999933,0xFFFF66,0xCCCC66,"
COLORS_05="0x669933,0x99CC66,0xCCFF99,0x99FF00,0x669900,0x99CC33,0xCCFF66,0x99CC00,0xCCFF33,0xCCFF00,0x33FF00,0x33CC00,0x66FF33,0x339900,0x66CC33,"
COLORS_06="0x99FF66,0x66FF00,0x66CC00,0x336600,0x99FF33,0x33FF33,0x33CC33,0x339933,0x66FF66,0x66CC66,0x336633,0x99FF99,0x669966,0x99CC99,0xCCFFCC,"
COLORS_07="0x33CC66,0x66FF99,0x00CC33,0x33FF66,0x00FF33,0x00FF00,0x00CC00,0x009900,0x006600,0x003300,0x66FFCC,0x00FF99,0x00CC66,0x006633,0x33FF99,"
COLORS_08="0x339966,0x66CC99,0x99FFCC,0x00FF66,0x009933,0x336666,0x99FFFF,0x669999,0x99CCCC,0xCCFFFF,0x00FFCC,0x00CC99,0x33FFCC,0x009966,0x33CC99,"
COLORS_09="0x00FFFF,0x00CCCC,0x009999,0x006666,0x003333,0x33FFFF,0x33CCCC,0x339999,0x66FFFF,0x66CCCC,0x336699,0x6699CC,0x99CCFF,0x0099FF,0x006699,"
COLORS_10="0x3399CC,0x66CCFF,0x0099CC,0x33CCFF,0x00CCFF,0x0033FF,0x0033CC,0x3366FF,0x003399,0x3366CC,0x6699FF,0x0066FF,0x0066CC,0x003366,0x3399FF,"
COLORS_11="0x3333FF,0x3333CC,0x333399,0x6666FF,0x6666CC,0x333366,0x9999FF,0x666699,0x9999CC,0xCCCCFF,0x6633CC,0x9966FF,0x3300CC,0x6633FF,0x3300FF,"
COLORS_12="0x0000FF,0x0000CC,0x000099,0x000066,0x000033,0xCC66FF,0x9900FF,0x6600CC,0x330066,0x9933FF,0x663399,0x9966CC,0xCC99FF,0x6600FF,0x330099,"
COLORS_13="0x663366,0xFF99FF,0x996699,0xCC99CC,0xFFCCFF,0xCC00FF,0x9900CC,0xCC33FF,0x660099,0x9933CC,0xFF00FF,0xCC00CC,0x990099,0x660066,0x330033,"
COLORS_14="0xFF33FF,0xCC33CC,0x993399,0xFF66FF,0xCC66CC,0x993366,0xCC6699,0xFF99CC,0xFF0099,0x990066,0xCC3399,0xFF66CC,0xCC0099,0xFF33CC,0xFF00CC,"
COLORS_15="0xFF0033,0xCC0033,0xFF3366,0x990033,0xCC3366,0xFF6699,0xFF0066,0xCC0066,0x660033,0xFF3399"

COLORS=COLORS_01""COLORS_02""COLORS_03""COLORS_04""COLORS_05""COLORS_06""COLORS_07""COLORS_08""COLORS_09""COLORS_10""COLORS_11""COLORS_12""COLORS_13""COLORS_14""COLORS_15
setup = "OBJECTID="OBJECTID";AUTOSETUP="AUTOSETUP";XCELLCOUNT="XCELLCOUNT";YCELLCOUNT="YCELLCOUNT";XCELLWIDTH="XCELLWIDTH";YCELLHEIGHT="YCELLHEIGHT";XCELLGAP="XCELLGAP";YCELLGAP="XCELLGAP";COLORS="COLORS
rc = SysCreateObject("WPColorPalette", GismoColorPaletteName, place, setup, modus);
if rc = 1 then say " Create Gismo Color Palette : "translate(GismoColorPaletteName, " ", "^")


GismoColorPaletteName = "Gismo Color Palette^216 Color Palette^Sort by Saturation"
OBJECTID="<GCP_216ColorPalette_Saturation>"
COLORS_01="0xFFFFFF,0xCCCCCC,0x999999,0x666666,0x333333,0x000000,0x000000,0x000000,0x000000,0x000000,0x99CCCC,0x99CC99,0xCCCC99,0xCC9999,0xFFCCFF,"
COLORS_02="0xCCCCFF,0xCCFFFF,0xCCFFCC,0xFFFFCC,0xFFCCCC,0xFFCC99,0xFF9999,0x996699,0x666699,0x669999,0x669966,0x999966,0x996666,0xCC99CC,0x9999CC,"
COLORS_03="0xFF99CC,0xFF99FF,0xCC99FF,0x9999FF,0x99CCFF,0x99FFFF,0x99FFCC,0x99FF99,0xCCFF99,0xFFFF99,0x99CC66,0xCCCC66,0xCC9966,0xCC6666,0x663366,"
COLORS_04="0x333366,0x336666,0x336633,0x666633,0x663333,0xFF9966,0xFF6666,0xCC6699,0xCC66CC,0x9966CC,0x6666CC,0x6699CC,0x66CCCC,0x66CC99,0x66CC66,"
COLORS_05="0x6699FF,0x66CCFF,0x66FFFF,0x66FFCC,0x66FF99,0x66FF66,0x99FF66,0xCCFF66,0xFFFF66,0xFFCC66,0x669933,0x999933,0x996633,0x993333,0xFF6699,"
COLORS_06="0xFF66CC,0xFF66FF,0xCC66FF,0x9966FF,0x6666FF,0xCC6633,0xCC3333,0x993366,0x993399,0x663399,0x333399,0x336699,0x339999,0x339966,0x339933,"
COLORS_07="0x3366CC,0x3399CC,0x33CCCC,0x33CC99,0x33CC66,0x33CC33,0x66CC33,0x99CC33,0xCCCC33,0xCC9933,0xFFCC33,0xFF9933,0xFF6633,0xFF3333,0xCC3366,"
COLORS_08="0xCC3399,0xCC33CC,0x9933CC,0x6633CC,0x3333CC,0x33CCFF,0x33FFFF,0x33FFCC,0x33FF99,0x33FF66,0x33FF33,0x66FF33,0x99FF33,0xCCFF33,0xFFFF33,"
COLORS_09="0xFF3366,0xFF3399,0xFF33CC,0xFF33FF,0xCC33FF,0x9933FF,0x6633FF,0x3333FF,0x3366FF,0x3399FF,0x336600,0x666600,0x663300,0x660000,0x330033,"
COLORS_10="0x000033,0x003333,0x003300,0x333300,0x330000,0x993300,0x990000,0x660033,0x660066,0x330066,0x000066,0x003366,0x006666,0x006633,0x006600,"
COLORS_11="0x003399,0x006699,0x009999,0x009966,0x009933,0x009900,0x339900,0x669900,0x999900,0x996600,0xCC9900,0xCC6600,0xCC3300,0xCC0000,0x990033,"
COLORS_12="0x990066,0x990099,0x660099,0x330099,0x000099,0x0099CC,0x00CCCC,0x00CC99,0x00CC66,0x00CC33,0x00CC00,0x33CC00,0x66CC00,0x99CC00,0xCCCC00,"
COLORS_13="0xCC0033,0xCC0066,0xCC0099,0xCC00CC,0x9900CC,0x6600CC,0x3300CC,0x0000CC,0x0033CC,0x0066CC,0x33FF00,0x66FF00,0x99FF00,0xCCFF00,0xFFFF00,"
COLORS_14="0xFFCC00,0xFF9900,0xFF6600,0xFF3300,0xFF0000,0x0033FF,0x0066FF,0x0099FF,0x00CCFF,0x00FFFF,0x00FFCC,0x00FF99,0x00FF66,0x00FF33,0x00FF00,"
COLORS_15="0xFF0033,0xFF0066,0xFF0099,0xFF00CC,0xFF00FF,0xCC00FF,0x9900FF,0x6600FF,0x3300FF,0x0000FF"

COLORS=COLORS_01""COLORS_02""COLORS_03""COLORS_04""COLORS_05""COLORS_06""COLORS_07""COLORS_08""COLORS_09""COLORS_10""COLORS_11""COLORS_12""COLORS_13""COLORS_14""COLORS_15
setup = "OBJECTID="OBJECTID";AUTOSETUP="AUTOSETUP";XCELLCOUNT="XCELLCOUNT";YCELLCOUNT="YCELLCOUNT";XCELLWIDTH="XCELLWIDTH";YCELLHEIGHT="YCELLHEIGHT";XCELLGAP="XCELLGAP";YCELLGAP="XCELLGAP";COLORS="COLORS
rc = SysCreateObject("WPColorPalette", GismoColorPaletteName, place, setup, modus);
if rc = 1 then say " Create Gismo Color Palette : "translate(GismoColorPaletteName, " ", "^")


GismoColorPaletteName = "Gismo Color Palette^216 Color Palette^Sort by Value"
OBJECTID="<GCP_216ColorPalette_Value>"
COLORS_01="0x003333,0x003300,0x333300,0x330000,0x333333,0x000000,0x000000,0x000000,0x000000,0x000000,0x660000,0x663366,0x333366,0x336666,0x336633,"
COLORS_02="0x666633,0x663333,0x666666,0x330033,0x000033,0x660066,0x330066,0x000066,0x003366,0x006666,0x006633,0x006600,0x336600,0x666600,0x663300,"
COLORS_03="0x996633,0x993333,0x996699,0x666699,0x669999,0x669966,0x999966,0x996666,0x999999,0x660033,0x993366,0x993399,0x663399,0x333399,0x336699,"
COLORS_04="0x339999,0x339966,0x339933,0x669933,0x999933,0x009999,0x009966,0x009933,0x009900,0x339900,0x669900,0x999900,0x996600,0x993300,0x990000,"
COLORS_05="0xCC9999,0xCCCCCC,0x990033,0x990066,0x990099,0x660099,0x330099,0x000099,0x003399,0x006699,0x66CC66,0x99CC66,0xCCCC66,0xCC9966,0xCC6666,"
COLORS_06="0xCC99CC,0x9999CC,0x99CCCC,0x99CC99,0xCCCC99,0xCC9933,0xCC6633,0xCC3333,0xCC6699,0xCC66CC,0x9966CC,0x6666CC,0x6699CC,0x66CCCC,0x66CC99,"
COLORS_07="0x3333CC,0x3366CC,0x3399CC,0x33CCCC,0x33CC99,0x33CC66,0x33CC33,0x66CC33,0x99CC33,0xCCCC33,0xCCCC00,0xCC9900,0xCC6600,0xCC3300,0xCC0000,"
COLORS_08="0xCC3366,0xCC3399,0xCC33CC,0x9933CC,0x6633CC,0x0066CC,0x0099CC,0x00CCCC,0x00CC99,0x00CC66,0x00CC33,0x00CC00,0x33CC00,0x66CC00,0x99CC00,"
COLORS_09="0xFFFFFF,0xCC0033,0xCC0066,0xCC0099,0xCC00CC,0x9900CC,0x6600CC,0x3300CC,0x0000CC,0x0033CC,0xCCFF99,0xFFFF99,0xFFCC99,0xFF9999,0xFFCCFF,"
COLORS_10="0xCCCCFF,0xCCFFFF,0xCCFFCC,0xFFFFCC,0xFFCCCC,0xFF9966,0xFF6666,0xFF99CC,0xFF99FF,0xCC99FF,0x9999FF,0x99CCFF,0x99FFFF,0x99FFCC,0x99FF99,"
COLORS_11="0x6699FF,0x66CCFF,0x66FFFF,0x66FFCC,0x66FF99,0x66FF66,0x99FF66,0xCCFF66,0xFFFF66,0xFFCC66,0xFFCC33,0xFF9933,0xFF6633,0xFF3333,0xFF6699,"
COLORS_12="0xFF66CC,0xFF66FF,0xCC66FF,0x9966FF,0x6666FF,0x33CCFF,0x33FFFF,0x33FFCC,0x33FF99,0x33FF66,0x33FF33,0x66FF33,0x99FF33,0xCCFF33,0xFFFF33,"
COLORS_13="0xFF3366,0xFF3399,0xFF33CC,0xFF33FF,0xCC33FF,0x9933FF,0x6633FF,0x3333FF,0x3366FF,0x3399FF,0x33FF00,0x66FF00,0x99FF00,0xCCFF00,0xFFFF00,"
COLORS_14="0xFFCC00,0xFF9900,0xFF6600,0xFF3300,0xFF0000,0x0033FF,0x0066FF,0x0099FF,0x00CCFF,0x00FFFF,0x00FFCC,0x00FF99,0x00FF66,0x00FF33,0x00FF00,"
COLORS_15="0xFF0033,0xFF0066,0xFF0099,0xFF00CC,0xFF00FF,0xCC00FF,0x9900FF,0x6600FF,0x3300FF,0x0000FF"

COLORS=COLORS_01""COLORS_02""COLORS_03""COLORS_04""COLORS_05""COLORS_06""COLORS_07""COLORS_08""COLORS_09""COLORS_10""COLORS_11""COLORS_12""COLORS_13""COLORS_14""COLORS_15
setup = "OBJECTID="OBJECTID";AUTOSETUP="AUTOSETUP";XCELLCOUNT="XCELLCOUNT";YCELLCOUNT="YCELLCOUNT";XCELLWIDTH="XCELLWIDTH";YCELLHEIGHT="YCELLHEIGHT";XCELLGAP="XCELLGAP";YCELLGAP="XCELLGAP";COLORS="COLORS
rc = SysCreateObject("WPColorPalette", GismoColorPaletteName, place, setup, modus);
if rc = 1 then say " Create Gismo Color Palette : "translate(GismoColorPaletteName, " ", "^")



say ""
say " Gismo instalation was successfully completed."
say ""
say " GismõCXg[͖ɏI܂B"
say ""
