/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

   Removes a newsgroup from the set of newsgroups that we are
   fetching with the news-to-mail feed.  This script deletes the
   mailing list, its Weasel mail account, and its mail directory
   (except that the mail directory is not deleted if it contains
   any files.)  It also updates the configuration file.

      Author:       Peter Moylan (peter@ee.newcastle.edu.au)
      Started:      12 February 2001
      Last revised: 16 February 2001

   Assumption:
      This script assumes that it is in a subdirectory of the
      Major Major directory.  (It needs this assumption to
      find the MAJOR.INI file.)  If this is not true, you
      need to modify part of the script below.

   Usage:
      rmgroup groupname cfgfile

      The cfgfile parameter is the name of the configuration
      file.  If it is omitted, we assume "getnews.cfg".
      See CFG.DOC for the format of the configuration file.

*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

/****************************************************************/
/*                       MAIN PROGRAM                           */
/****************************************************************/

parse arg group cfgfile
IF cfgfile = '' THEN cfgfile = 'getnews.cfg'
IF group = '' THEN
    DO
        SAY "Example: rmgroup alt.test"
        EXIT
    END

CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs

/* Copy the configuration file, deleting the line that  */
/* specifies the group we are deleting.                 */

DO UNTIL STREAM(outfile, 'C', 'QUERY EXISTS') = ''
    outfile = SysTempFileName("?????.tmp")
END
WeaselDir = STRIP(LINEIN(cfgfile), 'T', '\')||'\'
CALL LINEOUT outfile,WeaselDir
newsserver = LINEIN(cfgfile)
CALL LINEOUT outfile,newsserver
DO WHILE STREAM(cfgfile, 'S') = 'READY'
    PARSE VALUE LINEIN(cfgfile) WITH groupname number
    IF groupname \= '' THEN
        IF groupname = group THEN
            SAY group' removed from configuration file.'
        ELSE
            CALL LINEOUT outfile, groupname number
END
CALL STREAM cfgfile, 'C', 'CLOSE'
CALL STREAM outfile, 'C', 'CLOSE'
'@del 'cfgfile
'@rename 'outfile' 'cfgfile

/* Delete the Major Major mailing list. */

MajorDir = '..'
inifile = MajorDir||'\MAJOR.INI'
call SysIni inifile, group, 'DELETE:'
SAY 'Mailing list 'group' deleted.'

/* Delete the Weasel account. */

Nul = '00'X
WeaselDir = STRIP(LINEIN(cfgfile), 'T', '\')
CALL STREAM cfgfile, 'C', 'CLOSE'
inifile = WeaselDir||'\WEASEL.INI'
call SysIni inifile, group, 'DELETE:'
SAY 'Weasel mail account for 'group' removed.'

/* Remove the mail directory, if possible.  */

MailDir = SysIni(inifile, '$SYS', 'MailRoot')
j = POS(Nul,MailDir)
IF j > 0 THEN MailDir = LEFT(MailDir, j-1)
MailDir = STRIP(MailDir)
MailDir = TRANSLATE(MailDir, '\', '/')||group
IF SysRmDir(MailDir) \= 0 THEN
    DO
        SAY "Could not remove the group's mail directory"
        SAY "     "MailDir
        SAY "You should check whether it still contains mail."
    END
ELSE
    SAY 'Mail directory 'MailDir' removed.'

EXIT

