/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

   Major Major filter that intercepts the incoming mail and
   puts it into the "outgoing news" directory.

      Author:       Peter Moylan (peter@ee.newcastle.edu.au)
      Started:      11 February 2001
      Last revised: 13 February 2001

      (Some of the header processing is based on ideas supplied
       by Piersante Sestini in his own mail/news filter.)

   Usage:
      This script should be in the "News" subdirectory of
      the Major Major directory.

      Make this command file the filter for the Major Major
      list whose name is the name of the newsgroup you are
      echoing.  If you are echoing multiple newsgroups,
      make this the filter for all of the corresponding lists.

*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

outdir = DIRECTORY()||'\News\outgoing\'

CALL RxFuncAdd SysTempFileName, rexxutil, SysTempFileName
parse arg msgfile

/* Check the first header line to see whether this is mail      */
/* coming in from a list subscriber, as distinct from a posting */
/* extracted from the newsgroup and on its way out to members.  */

PARSE UPPER VALUE LINEIN(msgfile) WITH kwd':'.
IF (kwd \= 'RETURN-PATH') & (kwd \= 'RECEIVED') THEN EXIT 0

/* We're now confident that this is incoming mail.  Extract     */
/* the message directory name to identify the newsgroup.        */

p2 = LASTPOS('\',msgfile)
p1 = LASTPOS('\',msgfile, p2-1)
group = SUBSTR(msgfile, p1+1, p2-p1-1)
ftemp = SysTempFileName(outdir||'?????.TMP' )
CALL LINEOUT ftemp, "Newsgroups: "group

/* Copy the headers over, but deleting the ones the news server */
/* won't like.                                                  */

buffer = LINEIN(msgfile)
DO UNTIL LENGTH(buffer) = 0
    next = LINEIN(msgfile)
    DO WHILE (LENGTH(next) > 0) & (LEFT(next,1) = ' ')
        buffer = buffer||next
        next = LINEIN(msgfile)
    END
    PARSE UPPER VAR buffer kwd':'.
    IF (kwd \= 'RECEIVED') & (kwd \= 'RETURN-PATH') & (kwd \= 'TO') THEN
         CALL LINEOUT ftemp, buffer
    buffer = next
END

/* Now copy the message body. */

CALL LINEOUT ftemp, ''
DO WHILE STREAM(msgfile, 'S') = 'READY'
    CALL LINEOUT ftemp, LINEIN(msgfile)
END

CALL STREAM ftemp, 'C', 'CLOSE'
f = SysTempFileName('?????.ART' )
'@rename 'ftemp f
EXIT 1

