/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.flow.InlineLevel;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.fo.properties.SpaceProperty;

public class Leader
extends InlineLevel {
    private CommonRelativePosition commonRelativePosition;
    private Length alignmentAdjust;
    private int alignmentBaseline;
    private Length baselineShift;
    private int dominantBaseline;
    private Length textDepth;
    private Length textAltitude;
    private String id;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private int leaderAlignment;
    private LengthRangeProperty leaderLength;
    private int leaderPattern;
    private Length leaderPatternWidth;
    private int ruleStyle;
    private Length ruleThickness;
    private SpaceProperty wordSpacing;

    public Leader(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        super.bind(pList);
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.alignmentAdjust = pList.get(3).getLength();
        this.alignmentBaseline = pList.get(4).getEnum();
        this.baselineShift = pList.get(15).getLength();
        this.dominantBaseline = pList.get(82).getEnum();
        this.textDepth = pList.get(227).getLength();
        this.textAltitude = pList.get(225).getLength();
        this.id = pList.get(113).getString();
        this.keepWithNext = pList.get(119).getKeep();
        this.keepWithPrevious = pList.get(120).getKeep();
        this.leaderAlignment = pList.get(123).getEnum();
        this.leaderLength = pList.get(124).getLengthRange();
        this.leaderPattern = pList.get(125).getEnum();
        this.leaderPatternWidth = pList.get(126).getLength();
        switch (this.leaderPattern) {
            case 134: {
                break;
            }
            case 123: {
                this.ruleStyle = pList.get(191).getEnum();
                this.ruleThickness = pList.get(192).getLength();
                break;
            }
            case 35: {
                break;
            }
            case 158: {
                break;
            }
            default: {
                throw new RuntimeException("Invalid leader pattern: " + this.leaderPattern);
            }
        }
        this.wordSpacing = pList.get(243).getSpace();
    }

    protected void startOfNode() throws FOPException {
        this.checkId(this.id);
    }

    public String getId() {
        return this.id;
    }

    public int getRuleStyle() {
        return this.ruleStyle;
    }

    public Length getRuleThickness() {
        return this.ruleThickness;
    }

    public int getLeaderAlignment() {
        return this.leaderAlignment;
    }

    public LengthRangeProperty getLeaderLength() {
        return this.leaderLength;
    }

    public int getLeaderPattern() {
        return this.leaderPattern;
    }

    public Length getLeaderPatternWidth() {
        return this.leaderPatternWidth;
    }

    public Length getAlignmentAdjust() {
        return this.alignmentAdjust;
    }

    public int getAlignmentBaseline() {
        return this.alignmentBaseline;
    }

    public Length getBaselineShift() {
        return this.baselineShift;
    }

    public int getDominantBaseline() {
        return this.dominantBaseline;
    }

    public String getLocalName() {
        return "leader";
    }

    public int getNameId() {
        return 19;
    }
}

