/*
 * Decompiled with CFR 0.152.
 */
package swingx.tree;

import java.util.EventListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeModel
implements TreeModel {
    protected EventListenerList listenerList = new EventListenerList();

    protected abstract Object getParent(Object var1);

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public void nodeChanged(Object object) {
        if (this.listenerList != null && object != null) {
            Object object2 = this.getParent(object);
            if (object2 != null) {
                int n = this.getIndexOfChild(object2, object);
                if (n != -1) {
                    int[] nArray = new int[]{n};
                    this.nodesChanged(object2, nArray);
                }
            } else if (object == this.getRoot()) {
                this.nodesChanged(object, null);
            }
        }
    }

    public void nodesWereInserted(Object object, int[] nArray) {
        if (this.listenerList != null && object != null && nArray != null && nArray.length > 0) {
            int n = nArray.length;
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.getChild(object, nArray[i]);
            }
            this.fireTreeNodesInserted(this, this.getPathToRoot(object), nArray, objectArray);
        }
    }

    public void nodesWereRemoved(Object object, int[] nArray, Object[] objectArray) {
        if (object != null && nArray != null) {
            this.fireTreeNodesRemoved(this, this.getPathToRoot(object), nArray, objectArray);
        }
    }

    public void nodesChanged(Object object, int[] nArray) {
        if (object != null) {
            if (nArray != null) {
                int n = nArray.length;
                if (n > 0) {
                    Object[] objectArray = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        objectArray[i] = this.getChild(object, nArray[i]);
                    }
                    this.fireTreeNodesChanged(this, this.getPathToRoot(object), nArray, objectArray);
                }
            } else if (object == this.getRoot()) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(object), null, null);
            }
        }
    }

    public void rootExchanged() {
        this.fireTreeStructureChanged(this, this.getPathToRoot(this.getRoot()), null, null);
    }

    public void nodeStructureChanged(Object object) {
        this.fireTreeStructureChanged(this, this.getPathToRoot(object), null, null);
    }

    public Object[] getPathToRoot(Object object) {
        return this.getPathToRoot(object, 0);
    }

    protected Object[] getPathToRoot(Object object, int n) {
        if (object == null) {
            return null;
        }
        Object[] objectArray = object == this.getRoot() ? new Object[n] : this.getPathToRoot(this.getParent(object), ++n);
        if (objectArray == null) {
            return null;
        }
        objectArray[objectArray.length - n] = object;
        return objectArray;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, objectArray == null ? null : new TreePath(objectArray), nArray, objectArray2);
            }
            ((TreeModelListener)objectArray3[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listenerList.getListeners(TreeModelListener.class);
    }
}

