/*
 * Decompiled with CFR 0.152.
 */
package swingx.dnd.tree;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import swingx.dnd.ObjectTransferable;
import swingx.dnd.tree.DnDTreeModel;
import swingx.tree.AbstractTreeModel;

public abstract class AbstractDnDTreeModel
extends AbstractTreeModel
implements DnDTreeModel {
    private static AbstractDnDTreeModel currentDrag;
    private static boolean dragYielded;

    public Transferable createTransferable(Object[] objectArray) {
        currentDrag = this;
        dragYielded = false;
        return new ObjectTransferable((Object)objectArray);
    }

    protected Object[] getNodes(Transferable transferable) throws UnsupportedFlavorException, IOException {
        return (Object[])ObjectTransferable.getObject((Transferable)transferable);
    }

    public int getDragActions(Transferable transferable) {
        try {
            return this.getDragActions(this.getNodes(transferable));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected int getDragActions(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.getParent(objectArray[i]) != null) continue;
            return 0;
        }
        return 2;
    }

    public int getDropActions(Transferable transferable, Object object, int n) {
        try {
            return this.getDropActions((Object[])ObjectTransferable.getObject((Transferable)transferable), object, n);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected int getDropActions(Object[] objectArray, Object object, int n) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.isNodeAncestor(objectArray[i], object)) continue;
            return 0;
        }
        return 2;
    }

    public void drag(Transferable transferable, int n) throws UnsupportedFlavorException, IOException {
        if (!dragYielded && n == 2) {
            Object[] objectArray = this.getNodes(transferable);
            for (int i = objectArray.length - 1; i >= 0; --i) {
                this.removeNodeFromParent(objectArray[i]);
            }
        }
    }

    protected abstract void removeNodeFromParent(Object var1);

    public void drop(Transferable transferable, Object object, int n, int n2) throws UnsupportedFlavorException, IOException {
        if (n2 != 2) {
            throw new IllegalArgumentException("action not supported: " + n2);
        }
        if (currentDrag != null) {
            n = this.yieldDrag(transferable, object, n, n2);
        }
        Object[] objectArray = this.getNodes(transferable);
        for (int i = 0; i < objectArray.length; ++i) {
            this.insertNodeInto(objectArray[i], object, n + i);
        }
    }

    protected int yieldDrag(Transferable transferable, Object object, int n, int n2) throws UnsupportedFlavorException, IOException {
        Object[] objectArray = this.getNodes(transferable);
        for (int i = 0; i < objectArray.length; ++i) {
            if (this.getParent(objectArray[i]) != object || this.getIndexOfChild(object, objectArray[i]) >= n) continue;
            --n;
        }
        currentDrag.drag(transferable, n2);
        dragYielded = true;
        return n;
    }

    protected abstract void insertNodeInto(Object var1, Object var2, int var3);

    public void releaseTransferable(Transferable transferable) {
        currentDrag = null;
        dragYielded = false;
    }

    private boolean isNodeAncestor(Object object, Object object2) {
        do {
            if (object != object2) continue;
            return true;
        } while ((object2 = this.getParent(object2)) != null);
        return false;
    }
}

