/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.ChangeSupport;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;

public class TextFieldWidget
extends JTextField {
    private boolean isTemplate = false;
    private boolean isSelectAllOnFocus = false;
    private ChangeSupport changeSupport;
    private boolean blockSystemSelectionAccessViaToolkit = false;

    public TextFieldWidget() {
        this("", 0);
    }

    public TextFieldWidget(String string) {
        this(string, 0);
    }

    public TextFieldWidget(String string, int n) {
        super(string, n);
        this.setAlignmentX(0.0f);
        this.changeSupport = new ChangeSupport(this){

            public void fireChangeEvent() {
                TextFieldWidget.this.isTemplate = false;
                super.fireChangeEvent();
            }
        };
        this.getDocument().addDocumentListener(this.changeSupport);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void setDocument(Document document) {
        Document document2 = this.getDocument();
        if (this.changeSupport != null && document2 != null) {
            document2.removeDocumentListener(this.changeSupport);
        }
        super.setDocument(document);
        if (this.changeSupport != null && document != null) {
            document.addDocumentListener(this.changeSupport);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public TextFieldWidget setTemplate(boolean bl) {
        this.isTemplate = bl;
        return this;
    }

    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    public void setSelectAllOnFocus(boolean bl) {
        this.isSelectAllOnFocus = bl;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (focusEvent.getID() == 1004 && (this.isTemplate || this.isSelectAllOnFocus)) {
            this.selectAll();
        }
        super.processFocusEvent(focusEvent);
    }

    public Toolkit getToolkit() {
        if (this.blockSystemSelectionAccessViaToolkit) {
            throw new HeadlessException("no access to system selection atm");
        }
        return super.getToolkit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAll() {
        if (this.getDocument() != null) {
            this.setCaretPosition(this.getDocument().getLength());
            try {
                if (this.getToolkit().getSystemSelection() != null) {
                    this.blockSystemSelectionAccessViaToolkit = true;
                }
                this.moveCaretPosition(0);
            }
            finally {
                this.blockSystemSelectionAccessViaToolkit = false;
            }
        }
    }

    public String getText() {
        if (this.isTemplate) {
            return "";
        }
        return super.getText();
    }

    public boolean isEmpty() {
        return this.getText().trim().length() == 0;
    }

    public void setText(String string) {
        super.setText(string);
        this.setCaretPosition(0);
    }
}

