/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.WordBuffer;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class FileChooser
extends JFileChooser {
    private String command;
    private JComponent owner;

    public FileChooser(JComponent jComponent, String string, String string2, String string3, String string4) {
        super(string4 != null ? string4 : ".");
        this.setDialogTitle(string);
        this.owner = jComponent;
        this.command = string2;
        if (string3 != null) {
            Filter filter = new Filter(string3);
            this.addChoosableFileFilter(filter);
            this.setFileFilter(filter);
        }
    }

    public int showDialog() {
        int n = this.showDialog(this.owner, this.command);
        if (n != 0) {
            this.setSelectedFile(null);
        }
        return n;
    }

    private class Filter
    extends FileFilter {
        private String[] exts;
        private String descr;

        private Filter(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            this.exts = new String[stringTokenizer.countTokens()];
            if (this.exts.length == 0) {
                throw new IllegalArgumentException("extensions required");
            }
            WordBuffer wordBuffer = new WordBuffer(",");
            for (int i = 0; i < this.exts.length; ++i) {
                this.exts[i] = stringTokenizer.nextToken().toLowerCase().trim();
                wordBuffer.append("*." + this.exts[i]);
            }
            this.descr = wordBuffer.toString();
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n < 0) {
                return false;
            }
            String string2 = string.substring(n + 1);
            for (int i = 0; i < this.exts.length; ++i) {
                if (!this.exts[i].equalsIgnoreCase(string2)) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.descr;
        }
    }
}

