/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EnvironmentChecker {
    private static Logger LOG;
    private static final String[] SYSTEM_PROPERTIES;
    private static final Set<String> NOOVERRIDE;

    public static boolean isJava16() {
        String string = EnvironmentChecker.getProperty("java.version", "", "Checking Java VM version");
        return string.matches("1\\.[6789].*");
    }

    public static boolean isMac() {
        return EnvironmentChecker.getProperty("mrj.version", null, "isMac()") != null;
    }

    public static boolean isWindows() {
        return EnvironmentChecker.getProperty("os.name", "", "isWindows()").indexOf("Windows") > -1;
    }

    private static String getDatePattern(int n) {
        try {
            return ((SimpleDateFormat)DateFormat.getDateInstance(n)).toPattern();
        }
        catch (Throwable throwable) {
            return "?";
        }
    }

    public static void log() {
        Object object;
        Object object2;
        for (int i = 0; i < SYSTEM_PROPERTIES.length; ++i) {
            object2 = SYSTEM_PROPERTIES[i];
            object = (String)object2 + " = " + EnvironmentChecker.getProperty(SYSTEM_PROPERTIES[i], "", "check system props");
            if (NOOVERRIDE.contains(object2)) {
                object = (String)object + " (no override)";
            }
            LOG.info((String)object);
        }
        LOG.info("Locale = " + Locale.getDefault());
        LOG.info("DateFormat (short) = " + EnvironmentChecker.getDatePattern(3));
        LOG.info("DateFormat (medium) = " + EnvironmentChecker.getDatePattern(2));
        LOG.info("DateFormat (long) = " + EnvironmentChecker.getDatePattern(1));
        LOG.info("DateFormat (full) = " + EnvironmentChecker.getDatePattern(0));
        try {
            Object object3;
            String string = EnvironmentChecker.getProperty("java.class.path", "", "check classpath");
            object2 = new StringTokenizer(string, System.getProperty("path.separator"), false);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                object3 = EnvironmentChecker.checkClasspathEntry((String)object) ? " (does exist)" : "";
                LOG.info("Classpath = " + (String)object + (String)object3);
            }
            for (object = EnvironmentChecker.class.getClassLoader(); object != null; object = ((ClassLoader)object).getParent()) {
                if (object instanceof URLClassLoader) {
                    LOG.info("URLClassloader " + object + Arrays.asList(((URLClassLoader)object).getURLs()));
                    continue;
                }
                LOG.info("Classloader " + object);
            }
            object3 = Runtime.getRuntime();
            LOG.log(Level.INFO, "Memory Max={0}/Total={1}/Free={2}", new Long[]{new Long(((Runtime)object3).maxMemory()), new Long(((Runtime)object3).totalMemory()), new Long(((Runtime)object3).freeMemory())});
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "unexpected exception in log()", throwable);
        }
    }

    private static boolean checkClasspathEntry(String string) {
        try {
            return new File(string).exists();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String getProperty(String string, String string2, String string3) {
        return EnvironmentChecker.getProperty(new String[]{string}, string2, string3);
    }

    public static File getLog() {
        File file = new File(EnvironmentChecker.getProperty("user.home.genj", null, "log file"));
        if (!(file.exists() || file.mkdirs() || file.isDirectory())) {
            throw new Error("Can't initialize home directoy " + file);
        }
        return new File(file, "genj.log");
    }

    public static String getProperty(String[] stringArray, String string, String string2) {
        String string3 = null;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                string3 = stringArray[i];
                int n = string3.indexOf(47);
                if (n < 0) {
                    n = string3.length();
                }
                String string4 = string3.substring(n);
                String string5 = System.getProperty(string3 = string3.substring(0, n));
                if (string5 == null) continue;
                LOG.finer("Using system-property " + string3 + '=' + string5 + " (" + string2 + ')');
                return string5 + string4;
            }
        }
        catch (Throwable throwable) {
            LOG.log(Level.INFO, "Couldn't access system property " + string3 + " (" + throwable.getMessage() + ")");
        }
        if (string != null) {
            LOG.fine("Using fallback for system-property " + string3 + '=' + string + " (" + string2 + ')');
        }
        return string;
    }

    public static void loadSystemProperties(InputStream inputStream) throws IOException {
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            for (Object object : properties.keySet()) {
                if (System.getProperty((String)object) != null) continue;
                EnvironmentChecker.setProperty((String)object, properties.getProperty((String)object));
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException("unexpected throwable " + throwable.getMessage());
        }
    }

    private static void setProperty(String string, String string2) {
        String string3 = System.getProperty(string);
        if (string3 == null) {
            LOG.fine("Setting system property " + string);
            System.setProperty(string, string2);
        } else {
            LOG.fine("Not overriding system property " + string);
            NOOVERRIDE.add(string);
        }
    }

    static {
        Object object;
        File file;
        Serializable serializable;
        Object object2;
        LOG = Logger.getLogger("genj.util");
        SYSTEM_PROPERTIES = new String[]{"java.vendor", "java.vendor.url", "java.version", "java.class.version", "os.name", "os.arch", "os.version", "browser", "browser.vendor", "browser.version", "user.name", "user.dir", "user.home", "all.home", "user.home.genj", "all.home.genj"};
        NOOVERRIDE = new HashSet<String>();
        try {
            EnvironmentChecker.loadSystemProperties(new FileInputStream(new File("system.properties")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (EnvironmentChecker.isWindows()) {
            object2 = "reg query \"HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\ProfileList\"";
            serializable = Pattern.compile(".*AllUsersProfile\tREG_SZ\t(.*)");
            file = null;
            try {
                String string;
                object = Runtime.getRuntime().exec((String)object2);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
                while ((string = bufferedReader.readLine()) != null) {
                    Matcher matcher = ((Pattern)serializable).matcher(string);
                    if (!matcher.matches()) continue;
                    File file2 = new File(new File(System.getProperty("user.home")).getParent(), matcher.group(1));
                    if (!file2.isDirectory()) break;
                    EnvironmentChecker.setProperty("all.home", file2.getAbsolutePath());
                    break;
                }
                bufferedReader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            serializable = new File(System.getProperty("user.home"));
            file = new File((File)serializable, ".genj3");
            if (file.exists() && file.isDirectory()) {
                object2 = file;
            } else if (EnvironmentChecker.isWindows()) {
                object = new File(System.getenv("APPDATA"));
                if (!((File)object).exists()) {
                    object = new File((File)serializable, "Application Data");
                }
                object2 = new File((File)object, "GenJ3");
            } else {
                object2 = EnvironmentChecker.isMac() ? new File(new File((File)serializable, "Library/Application Support"), "GenJ3") : file;
            }
            EnvironmentChecker.setProperty("user.home.genj", ((File)object2).getAbsolutePath());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (EnvironmentChecker.isWindows() && ((File)(object2 = new File(System.getProperty("all.home"), "Application Data"))).isDirectory()) {
                EnvironmentChecker.setProperty("all.home.genj", new File((File)object2, "GenJ3").getAbsolutePath());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

