/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.io.IOException;
import java.io.InputStream;

public class ByteArray {
    private static final int CLUSTER = 4096;
    private static final byte[] EMPTY = new byte[0];
    private byte[] bits = EMPTY;
    private boolean isAllowInterrupts;

    public ByteArray(InputStream inputStream) throws InterruptedException, IOException {
        this(inputStream, Math.max(inputStream.available(), 4096), false);
    }

    public ByteArray(InputStream inputStream, boolean bl) throws InterruptedException, IOException {
        this(inputStream, Math.max(inputStream.available(), 4096), bl);
    }

    public ByteArray(InputStream inputStream, int n, boolean bl) throws InterruptedException, IOException {
        this.isAllowInterrupts = bl;
        byte[] byArray = new byte[n + 1];
        int n2 = 0;
        int n3 = 0;
        while (true) {
            n2 = inputStream.read(byArray, n3, byArray.length - n3);
            if (this.isAllowInterrupts && Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (n2 < 0) break;
            if ((n3 += n2) < byArray.length) continue;
            byte[] byArray2 = new byte[byArray.length * 2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = byArray2;
        }
        this.bits = new byte[n3];
        System.arraycopy(byArray, 0, this.bits, 0, n3);
        byArray = null;
    }

    public byte[] getBytes() {
        return this.bits;
    }
}

