/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import genj.report.HTMLEditorKit;
import genj.report.Report;
import genj.util.GridBagHelper;
import genj.util.Resources;
import genj.util.swing.EditorHyperlinkSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

class ReportDetail
extends JPanel {
    private JLabel lFile;
    private JLabel lAuthor;
    private JLabel lVersion;
    private JTextPane tpInfo;
    private HTMLEditorKit editorKit = new HTMLEditorKit(ReportDetail.class);

    public ReportDetail() {
        Resources resources = Resources.get(this);
        GridBagHelper gridBagHelper = new GridBagHelper(this);
        gridBagHelper.setParameter(1);
        gridBagHelper.setInsets(new Insets(0, 0, 0, 5));
        this.lFile = new JLabel("");
        this.lFile.setForeground(Color.black);
        gridBagHelper.add(new JLabel(resources.getString("report.file")), 2, 0);
        gridBagHelper.add(this.lFile, 3, 0, 1, 1, 17);
        this.lAuthor = new JLabel("");
        this.lAuthor.setForeground(Color.black);
        gridBagHelper.add(new JLabel(resources.getString("report.author")), 2, 1);
        gridBagHelper.add(this.lAuthor, 3, 1, 1, 1, 17);
        this.lVersion = new JLabel();
        this.lVersion.setForeground(Color.black);
        gridBagHelper.add(new JLabel(resources.getString("report.version")), 2, 2);
        gridBagHelper.add(this.lVersion, 3, 2);
        this.tpInfo = new JTextPane();
        this.tpInfo.setEditable(false);
        this.tpInfo.setEditorKit(this.editorKit);
        this.tpInfo.setFont(new JTextField().getFont());
        this.tpInfo.addHyperlinkListener(new EditorHyperlinkSupport(this.tpInfo));
        this.tpInfo.setPreferredSize(new Dimension(256, 256));
        JScrollPane jScrollPane = new JScrollPane(this.tpInfo);
        gridBagHelper.add(jScrollPane, 2, 4, 2, 1, 68);
        this.tpInfo.setText("Some very long info on report from file");
    }

    public void setReport(Report report) {
        if (report == null) {
            this.lFile.setText("");
            this.lAuthor.setText("");
            this.lVersion.setText("");
            this.tpInfo.setText("");
        } else {
            this.editorKit.setFrom(report.getClass());
            this.lFile.setText(report.getFile().getName());
            this.lAuthor.setText(report.getAuthor());
            this.lVersion.setText(this.getReportVersion(report));
            this.tpInfo.setText(report.getInfo().replaceAll("\n", "<br>"));
            this.tpInfo.setCaretPosition(0);
        }
    }

    private String getReportVersion(Report report) {
        String string = report.getVersion();
        String string2 = report.getLastUpdate();
        if (string2 != null) {
            string = string + " - " + Resources.get(this).getString("report.updated") + ": " + string2;
        }
        return string;
    }
}

