/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import genj.common.SelectEntityWidget;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.time.PointInTime;
import genj.option.Option;
import genj.option.OptionsWidget;
import genj.option.PropertyOption;
import genj.report.Options;
import genj.report.ReportView;
import genj.util.EnvironmentChecker;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.DialogHelper;
import genj.util.swing.ImageIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Report
implements Cloneable {
    private static final PrintWriter NUL = new PrintWriter(new OutputStream(){

        public void write(int n) {
        }
    });
    protected static final Logger LOG = Logger.getLogger("genj.report");
    protected static final Icon DEFAULT_ICON = new Icon(){

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    };
    protected Options OPTIONS = Options.getInstance();
    protected static final int OPTION_YESNO = 0;
    protected static final int OPTION_OKCANCEL = 1;
    protected static final int OPTION_OK = 2;
    private static final String[][] OPTION_TEXTS = new String[][]{{Action2.TXT_YES, Action2.TXT_NO}, {Action2.TXT_OK, Action2.TXT_CANCEL}, {Action2.TXT_OK}};
    protected static final int ALIGN_LEFT = 0;
    protected static final int ALIGN_CENTER = 1;
    protected static final int ALIGN_RIGHT = 2;
    protected Registry registry;
    private static final String userLanguage = Locale.getDefault().getLanguage();
    static final Resources COMMON_RESOURCES = Resources.get(Report.class);
    private Resources resources;
    private List<Option> options;
    private Icon icon;
    private File file;
    private PrintWriter out = NUL;
    private Component owner = null;
    private static final Pattern PATTERN_CVS_DATE = Pattern.compile("\\$Date: (\\d\\d\\d\\d)/(\\d\\d)/(\\d\\d)( \\d\\d:\\d\\d:\\d\\d) *\\$");

    protected Report() {
        this.registry = new Registry(Registry.get(Report.class), this.getClass().getName());
    }

    void log(String string) {
        this.getOut().println(string);
    }

    public PrintWriter getOut() {
        return this.out;
    }

    void setOut(PrintWriter printWriter) {
        this.out = printWriter;
    }

    void setOwner(Component component) {
        this.owner = component;
    }

    void saveOptions() {
        if (this.options == null) {
            return;
        }
        for (Option option : this.options) {
            if (option instanceof PropertyOption) {
                ((PropertyOption)option).persist(this.registry);
                continue;
            }
            option.persist();
        }
    }

    protected Registry getRegistry() {
        return this.registry;
    }

    public final List<? extends Option> getOptions() {
        if (this.options != null) {
            return this.options;
        }
        this.options = new ArrayList<Option>();
        List<PropertyOption> list = PropertyOption.introspect((Object)this, true);
        for (PropertyOption propertyOption : list) {
            String string;
            String string2;
            propertyOption.restore(this.registry);
            String string3 = this.translateOption(propertyOption.getProperty());
            if (string3.length() > 0) {
                propertyOption.setName(string3);
            }
            if ((string2 = this.translateOption(string = propertyOption.getProperty() + ".tip")).length() > 0 && !string2.equals(string)) {
                propertyOption.setToolTip(string2);
            }
            if (propertyOption.getCategory() == null) {
                propertyOption.setCategory(this.getName());
            } else {
                propertyOption.setCategory(this.translateOption(propertyOption.getCategory()));
            }
            this.options.add(propertyOption);
        }
        return this.options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        String string = this.translate("category");
        if (string.equals("category") || string.length() == 0) {
            this.icon = DEFAULT_ICON;
        } else {
            String string2 = "Category" + Character.toUpperCase(string.charAt(0)) + string.substring(1) + ".png";
            InputStream inputStream = null;
            try {
                inputStream = Report.class.getResourceAsStream(string2);
                this.icon = new ImageIcon(string2, inputStream);
            }
            catch (Throwable throwable) {
                this.icon = DEFAULT_ICON;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.icon;
    }

    public final String getCategory() {
        String string = this.translate("category");
        if (string.equals("category") || string.length() == 0) {
            return "";
        }
        String string2 = COMMON_RESOURCES.getString("category." + string, false);
        if (string2 == null) {
            LOG.fine("report's category " + string + " doesn't exist");
            return COMMON_RESOURCES.getString("category.utility");
        }
        return string2;
    }

    public final void flush() {
        this.getOut().flush();
    }

    public final void println() {
        this.println("");
    }

    public final void println(Object object) {
        if (object == null) {
            return;
        }
        if (Thread.interrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
        this.log(object.toString());
    }

    public final void println(Throwable throwable) {
        CharArrayWriter charArrayWriter = new CharArrayWriter(256);
        throwable.printStackTrace(new PrintWriter(charArrayWriter));
        this.log(charArrayWriter.toString());
    }

    public File getFileFromUser(String string, String string2) {
        return this.getFileFromUser(string, string2, false);
    }

    public File getFileFromUser(String string, String string2, boolean bl) {
        return this.getFileFromUser(string, string2, bl, null);
    }

    public File getFileFromUser(String string, String string2, boolean bl, String string3) {
        String string4 = this.registry.get("file", EnvironmentChecker.getProperty("user.home", ".", "looking for report file to let the user choose from"));
        JFileChooser jFileChooser = new JFileChooser(string4);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setDialogTitle(string);
        if (string3 != null) {
            jFileChooser.setFileFilter(new FileExtensionFilter(string3));
        }
        int n = jFileChooser.showDialog(this.owner, string2);
        File file = jFileChooser.getSelectedFile();
        if (n != 0 || file == null) {
            return null;
        }
        if (file.exists() && bl && (n = DialogHelper.openDialog(string, 2, ReportView.RESOURCES.getString("report.file.overwrite"), (Action[])Action2.yesNo(), (Object)this.owner)) != 0) {
            return null;
        }
        this.registry.put("file", file.getParent().toString());
        return file;
    }

    public File getDirectoryFromUser(String string, String string2) {
        String string3 = this.registry.get("dir", EnvironmentChecker.getProperty("user.home", ".", "looking for report dir to let the user choose from"));
        JFileChooser jFileChooser = new JFileChooser(string3);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle(string);
        int n = jFileChooser.showDialog(this.owner, string2);
        File file = jFileChooser.getSelectedFile();
        if (n != 0 || file == null) {
            return null;
        }
        this.registry.put("dir", file.toString());
        return file;
    }

    public final String initFile(String string, String string2) {
        if (string != null && string.trim().length() != 0) {
            return string;
        }
        File file = this.getFileFromUser(string2, Action2.TXT_OK);
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    public final Entity getEntityFromUser(String string, Gedcom gedcom, String string2) {
        int n;
        SelectEntityWidget selectEntityWidget = new SelectEntityWidget(gedcom, string2, null);
        Entity entity = gedcom.getEntity(this.registry.get("select." + string2, (String)null));
        if (entity != null) {
            selectEntityWidget.setSelection(entity);
        }
        if ((n = DialogHelper.openDialog(this.getName(), 3, new JComponent[]{new JLabel(string), selectEntityWidget}, (Action[])Action2.okCancel(), (Object)this.owner)) != 0) {
            return null;
        }
        Entity entity2 = selectEntityWidget.getSelection();
        if (entity2 == null) {
            return null;
        }
        this.registry.put("select." + entity2.getTag(), entity2.getId());
        return entity2;
    }

    public final Object getValueFromUser(String string, Object[] objectArray, Object object) {
        ChoiceWidget choiceWidget = new ChoiceWidget(objectArray, object);
        choiceWidget.setEditable(false);
        int n = DialogHelper.openDialog(this.getName(), 3, new JComponent[]{new JLabel(string), choiceWidget}, (Action[])Action2.okCancel(), (Object)this.owner);
        return n == 0 ? choiceWidget.getSelectedItem() : null;
    }

    public final String getValueFromUser(String string, String string2) {
        return this.getValueFromUser(string, string2, new String[0]);
    }

    public final String getValueFromUser(String string, String string2, String[] stringArray) {
        String string3;
        Object object;
        if (string != null && (object = this.registry.get(string, (String[])null)) != null) {
            stringArray = object;
        }
        object = new ChoiceWidget(stringArray, stringArray.length > 0 ? stringArray[0] : "");
        int n = DialogHelper.openDialog(this.getName(), 3, new JComponent[]{new JLabel(string2), object}, (Action[])Action2.okCancel(), (Object)this.owner);
        String string4 = string3 = n == 0 ? ((ChoiceWidget)object).getText() : null;
        if (string != null && string3 != null && string3.length() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + 1);
            arrayList.add(string3);
            for (int i = 0; i < stringArray.length && i < 20; ++i) {
                if (string3.equalsIgnoreCase(stringArray[i])) continue;
                arrayList.add(stringArray[i]);
            }
            this.registry.put(string, arrayList);
        }
        return string3;
    }

    public final boolean getOptionsFromUser(String string, Object object) {
        List<PropertyOption> list = PropertyOption.introspect(object);
        String string2 = object.getClass().getName();
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        if ((n = string2.lastIndexOf(36)) > 0) {
            string2 = string2.substring(n + 1);
        }
        for (PropertyOption propertyOption : list) {
            propertyOption.restore(this.registry);
            String string3 = this.translate(string2 + "." + propertyOption.getName());
            if (string3.length() <= 0) continue;
            propertyOption.setName(string3);
        }
        OptionsWidget optionsWidget = new OptionsWidget(string, list);
        int n2 = DialogHelper.openDialog(this.getName(), 3, optionsWidget, (Action[])Action2.okCancel(), (Object)this.owner);
        if (n2 != 0) {
            return false;
        }
        optionsWidget.stopEditing();
        for (PropertyOption propertyOption : list) {
            propertyOption.persist(this.registry);
        }
        return true;
    }

    public final boolean getOptionFromUser(String string, int n) {
        return 0 == this.getOptionFromUser(string, OPTION_TEXTS[n]);
    }

    private int getOptionFromUser(String string, String[] stringArray) {
        Action[] actionArray = new Action[stringArray.length];
        for (int i = 0; i < actionArray.length; ++i) {
            actionArray[i] = new Action2(stringArray[i]);
        }
        return DialogHelper.openDialog(this.getName(), 3, string, actionArray, (Object)this.owner);
    }

    public String translateOption(String string) {
        String string2;
        String string3;
        String string4 = this.translate(string);
        if (string4.equals(string) && !(string3 = COMMON_RESOURCES.getString(string2 = "option." + string)).equals(string2)) {
            string4 = string3;
        }
        return string4;
    }

    public final String translate(String string) {
        return this.translate(string, (Object[])null);
    }

    public final String translate(String string, Object ... objectArray) {
        return this.translate(string, null, objectArray);
    }

    public final String translate(String string, Locale locale, Object ... objectArray) {
        String string2;
        String string3;
        Resources resources = this.getResources();
        if (resources == null) {
            return string;
        }
        String string4 = null;
        String string5 = string3 = locale != null ? locale.getLanguage() : userLanguage;
        if (string3 != null && (string4 = resources.getString(string2 = string + '.' + string3, objectArray)) != string2) {
            return string4;
        }
        string4 = resources.getString(string, objectArray);
        return string4;
    }

    public void putFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    private String getTypeName() {
        String string = this.getClass().getName();
        while (string.indexOf(46) >= 0) {
            string = string.substring(string.indexOf(46) + 1);
        }
        return string;
    }

    protected Resources getResources() {
        if (this.resources == null) {
            this.resources = new Resources(this.getClass().getResourceAsStream(this.getTypeName() + ".properties"));
        }
        return this.resources;
    }

    public static String getIndent(int n, int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        while (stringBuffer.length() != n2) {
            stringBuffer.append(" ");
        }
        StringBuffer stringBuffer2 = new StringBuffer(256);
        while (--n > 0) {
            stringBuffer2.append(stringBuffer);
        }
        if (string != null) {
            stringBuffer2.append(string);
        }
        return stringBuffer2.toString();
    }

    public final String getIndent(int n) {
        return Report.getIndent(n, this.OPTIONS.getIndentPerLevel(), null);
    }

    public static String align(String string, int n, int n2) {
        int n3;
        int n4;
        int n5 = string.length();
        if (n5 > n) {
            return string.substring(0, n);
        }
        n5 = n - n5;
        StringBuffer stringBuffer = new StringBuffer(n);
        switch (n2) {
            default: {
                n4 = 0;
                break;
            }
            case 1: {
                n4 = (int)((float)n5 * 0.5f);
                break;
            }
            case 2: {
                n4 = n5;
            }
        }
        int n6 = n5 - n4;
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(string);
        for (n3 = 0; n3 < n6; ++n3) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public String getName() {
        String string = this.translate("name");
        if (string.length() == 0 || string.equals("name")) {
            string = this.getTypeName();
        }
        return string;
    }

    public String getAuthor() {
        return this.translate("author");
    }

    public String getVersion() {
        return this.translate("version");
    }

    public String getLastUpdate() {
        String string = this.translate("updated");
        if ("updated".equals(string)) {
            return null;
        }
        Matcher matcher = PATTERN_CVS_DATE.matcher(string);
        if (matcher.matches()) {
            try {
                string = new PointInTime(matcher.group(1) + matcher.group(2) + matcher.group(3)) + matcher.group(4);
            }
            catch (GedcomException gedcomException) {
                // empty catch block
            }
        }
        return string;
    }

    public String getInfo() {
        return this.translate("info");
    }

    public Object start(Object object) throws Throwable {
        try {
            return this.getStartMethod(object).invoke((Object)this, object);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    public boolean isReadOnly() {
        return true;
    }

    public String accepts(Object object) {
        return this.getStartMethod(object) != null ? this.getName() : null;
    }

    Method getStartMethod(Object object) {
        try {
            Method[] methodArray = this.getClass().getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Class<?> clazz;
                Class<?>[] classArray;
                if (!methodArray[i].getName().equals("start") || (classArray = methodArray[i].getParameterTypes()).length != 1 || !(clazz = classArray[0]).isAssignableFrom(object.getClass())) continue;
                return methodArray[i];
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Component getOwner() {
        return this.owner;
    }

    private class FileExtensionFilter
    extends FileFilter {
        private String extension;

        public FileExtensionFilter(String string) {
            this.extension = string.toLowerCase();
        }

        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith("." + this.extension);
        }

        public String getDescription() {
            return this.extension.toUpperCase() + " files";
        }
    }
}

