/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.renderer.Options;
import gj.awt.geom.Dimension2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class DPI {
    public static final RenderingHints.Key KEY = new DPIHintKey();
    public static final double INCH = 2.54;
    private int horizontal;
    private int vertical;

    public int horizontal() {
        return this.horizontal;
    }

    public int vertical() {
        return this.vertical;
    }

    public DPI(int n, int n2) {
        this.horizontal = n;
        this.vertical = n2;
    }

    public static DPI get(Graphics graphics) {
        DPI dPI = (DPI)((Graphics2D)graphics).getRenderingHint(KEY);
        if (dPI == null) {
            dPI = Options.getInstance().getDPI();
        }
        return dPI;
    }

    public Dimension2D toPixel(Dimension2D dimension2D) {
        return new Dimension2D.Double(dimension2D.getWidth() * (double)this.horizontal, dimension2D.getHeight() * (double)this.vertical);
    }

    public Rectangle2D toPixel(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double(rectangle2D.getX() * (double)this.horizontal, rectangle2D.getY() * (double)this.vertical, rectangle2D.getWidth() * (double)this.horizontal, rectangle2D.getHeight() * (double)this.vertical);
    }

    public Line2D toPixel(Line2D line2D) {
        return new Line2D.Double(this.toPixel(line2D.getP1()), this.toPixel(line2D.getP2()));
    }

    public Point2D toPixel(Point2D point2D) {
        return new Point2D.Double(point2D.getX() * (double)this.horizontal, point2D.getY() * (double)this.vertical);
    }

    public String toString() {
        return this.horizontal + " by " + this.vertical + " dpi";
    }

    private static class DPIHintKey
    extends RenderingHints.Key {
        private DPIHintKey() {
            super(0);
        }

        public boolean isCompatibleValue(Object object) {
            return object instanceof DPI;
        }
    }
}

