/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import genj.common.PathTreeWidget;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertySimpleReadOnly;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintManager;
import genj.renderer.BlueprintRenderer;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.DialogHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BlueprintEditor
extends JSplitPane {
    private static final Map<String, String> SAMPLES = new HashMap<String, String>();
    private JTextArea source;
    private Preview preview;
    private static final Resources resources;
    private Grammar grammar = Grammar.V55;
    private Blueprint blueprint;
    private AbstractButton bInsert;
    private Entity example;
    private boolean isChanged = false;
    private BlueprintManager blueprintManager = BlueprintManager.getInstance();

    public BlueprintEditor(Entity entity) {
        this.example = entity;
        this.grammar = entity.getGedcom().getGrammar();
        this.preview = new Preview();
        this.preview.setBorder(BorderFactory.createTitledBorder(resources.getString("blueprint.preview")));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.source = new JTextArea(3, 32);
        this.source.setFont(new Font("Monospaced", 0, 12));
        JScrollPane jScrollPane = new JScrollPane(this.source);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("HTML"));
        this.bInsert = new JButton(new Insert());
        jPanel.setMinimumSize(new Dimension(0, 0));
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.bInsert, "South");
        this.setLeftComponent(this.preview);
        this.setRightComponent(jPanel);
        this.setDividerLocation(Integer.MAX_VALUE);
        this.setOrientation(0);
        this.setOneTouchExpandable(true);
        this.source.getDocument().addDocumentListener(this.preview);
        this.set(null);
    }

    public int getLastDividerLocation() {
        return this.getSize().height / 2;
    }

    public void set(Blueprint blueprint) {
        if (blueprint == null) {
            this.blueprint = null;
            this.source.setText("");
        } else {
            this.blueprint = blueprint;
            this.source.setText(this.blueprint.getHTML());
            this.source.setCaretPosition(0);
        }
        boolean bl = this.blueprint != null && !this.blueprint.isReadOnly();
        this.bInsert.setEnabled(bl);
        this.source.setEditable(bl);
        this.source.setToolTipText(this.blueprint != null && this.blueprint.isReadOnly() ? resources.getString("blueprint.readonly", this.blueprint.getName()) : null);
        if (bl) {
            this.setSourceVisible(true);
        }
        this.isChanged = false;
        this.preview.repaint();
    }

    public void commit() {
        if (this.blueprint != null && this.isChanged) {
            this.blueprint.setSource(this.source.getText());
            try {
                this.blueprintManager.saveBlueprint(this.blueprint);
                this.isChanged = false;
            }
            catch (IOException iOException) {
                Logger.getLogger("genj.renderer").log(Level.WARNING, "can't save blueprint", iOException);
            }
        }
    }

    public void setSourceVisible(boolean bl) {
        SwingUtilities.invokeLater(new ShowHTML(bl));
    }

    static {
        SAMPLES.put("NAME", "John /Doe/");
        SAMPLES.put("SEX", "M");
        SAMPLES.put("DATE", "01 JAN 1900");
        SAMPLES.put("PLAC", "Nice Place");
        SAMPLES.put("ADDR", "Long Address");
        SAMPLES.put("CITY", "Big City");
        SAMPLES.put("POST", "12345");
        resources = Resources.get(BlueprintEditor.class);
    }

    private class Insert
    extends Action2 {
        private Insert() {
            super.setText(resources.getString("prop.insert"));
            super.setTip(resources.getString("prop.insert.tip"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PathTreeWidget pathTreeWidget = new PathTreeWidget();
            TagPath[] tagPathArray = BlueprintEditor.this.grammar.getAllPaths(BlueprintEditor.this.blueprint.getTag(), Property.class);
            pathTreeWidget.setPaths(tagPathArray, new TagPath[0]);
            int n = DialogHelper.openDialog(resources.getString("prop.insert.tip"), 3, pathTreeWidget, (Action[])Action2.okCancel(), (Object)BlueprintEditor.this);
            if (n != 0) {
                return;
            }
            tagPathArray = pathTreeWidget.getSelection();
            for (int i = 0; i < tagPathArray.length; ++i) {
                BlueprintEditor.this.source.insert("<prop path=" + tagPathArray[i].toString() + ">" + (i == tagPathArray.length - 1 ? "" : "\n"), BlueprintEditor.this.source.getCaretPosition());
            }
            BlueprintEditor.this.source.requestFocusInWindow();
        }
    }

    private class Preview
    extends JComponent
    implements DocumentListener {
        private Preview() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            BlueprintEditor.this.isChanged = true;
            this.repaint();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            BlueprintEditor.this.isChanged = true;
            this.repaint();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            BlueprintEditor.this.isChanged = true;
            this.repaint();
        }

        protected void paintComponent(Graphics graphics) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (BlueprintEditor.this.source.getText().length() == 0) {
                return;
            }
            Rectangle rectangle = this.getBounds();
            Insets insets = this.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            graphics.setColor(Color.white);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setFont(this.getFont());
            BlueprintRenderer blueprintRenderer = new BlueprintRenderer(new Blueprint(BlueprintEditor.this.source.getText())){

                protected Property getProperty(Entity entity, TagPath tagPath) {
                    MetaProperty metaProperty;
                    Property property = super.getProperty(entity, tagPath);
                    if (property != null) {
                        return property;
                    }
                    String string = (String)SAMPLES.get(tagPath.getLast());
                    if (string == null) {
                        string = Gedcom.getName(tagPath.getLast());
                    }
                    if (PropertyXRef.class.isAssignableFrom((metaProperty = BlueprintEditor.this.grammar.getMeta(tagPath, false)).getType())) {
                        string = "@...@";
                    }
                    try {
                        return metaProperty.create(string);
                    }
                    catch (GedcomException gedcomException) {
                        return new PropertySimpleReadOnly(tagPath.getLast(), string);
                    }
                }
            };
            blueprintRenderer.setDebug(true);
            blueprintRenderer.render(graphics, BlueprintEditor.this.example, rectangle);
        }
    }

    private class ShowHTML
    implements Runnable {
        private boolean visible;

        public ShowHTML(boolean bl) {
            this.visible = bl;
        }

        public void run() {
            BlueprintEditor.this.setDividerLocation(this.visible ? 0.5 : 1.0);
        }
    }
}

