/*
 * Decompiled with CFR 0.152.
 */
package genj.nav;

import genj.edit.actions.CreateChild;
import genj.edit.actions.CreateParent;
import genj.edit.actions.CreateSibling;
import genj.edit.actions.CreateSpouse;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.Indi;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.NestedBlockLayout;
import genj.view.SelectionSink;
import genj.view.View;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import spin.Spin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatorView
extends View {
    private static final String INDENT = "   ";
    private static final Resources RES = Resources.get(NavigatorView.class);
    private static final Registry REG = Registry.get(NavigatorView.class);
    private static final NestedBlockLayout LAYOUT = new NestedBlockLayout("<col><col><grandparents/><grandparent/></col><col><parents/><parent/></col><col><siblings/><sibling/></col><line/><col><spouses/><spouse/></col><line/><col><children/><child/></col><col><grandchildren/><grandchild/></col></col>");
    private GedcomListener callback = (GedcomListener)Spin.over((Object)new GedcomListenerAdapter(){

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            if (NavigatorView.this.context != null && NavigatorView.this.context.getEntity() == entity) {
                NavigatorView.this.setContext(new Context(gedcom), true);
            }
        }
    });
    private Context context = new Context();
    private JPanel content = new JPanel(LAYOUT);
    private static final MouseListener CLICK = new MouseAdapter(){

        public void mouseClicked(MouseEvent mouseEvent) {
            Action action;
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            Indi indi = (Indi)jLabel.getClientProperty(Indi.class);
            if (indi != null) {
                SelectionSink.Dispatcher.fireSelection(mouseEvent, new Context(indi));
            }
            if ((action = (Action)jLabel.getClientProperty(Action.class)) != null) {
                action.actionPerformed(new ActionEvent(mouseEvent.getSource(), 0, "", mouseEvent.getModifiers()));
            }
        }
    };

    public NavigatorView() {
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.content, 20, 31));
        this.content.setBackground(Color.WHITE);
    }

    @Override
    public void setContext(Context context, boolean bl) {
        if (this.context.getGedcom() != null) {
            this.context.getGedcom().removeGedcomListener(this.callback);
            this.context = new Context();
        }
        this.content.removeAll();
        if (context.getEntities().size() == 1) {
            if (context.getEntity() instanceof Indi) {
                this.setIndi((Indi)context.getEntity());
                this.addLine("line");
                this.addLine("line");
            }
            if (context.getEntity() instanceof Fam) {
                this.setFam((Fam)context.getEntity());
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void addLine(String string) {
        Box.Filler filler = new Box.Filler(new Dimension(1, 1), new Dimension(1, 1), new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        Color color = this.content.getForeground();
        filler.setBackground(new Color(color.getRed(), color.getGreen(), color.getBlue(), 128));
        filler.setOpaque(true);
        this.content.add(string, filler);
    }

    private void addExpander(String string, int n) {
        String string2 = RES.getString(string);
        NestedBlockLayout.Expander expander = new NestedBlockLayout.Expander(string2, string2 + " (" + n + ")");
        Registry registry = new Registry(REG, string);
        expander.setCollapsed(registry.get("folded", false));
        expander.addPropertyChangeListener("folded", registry);
        this.content.add(string, expander);
    }

    private void setFam(Fam fam) {
        Indi[] indiArray;
        Indi indi;
        int n = 0;
        Indi indi2 = fam.getHusband();
        if (indi2 != null) {
            this.content.add("parent", this.indi(indi2));
            ++n;
        }
        if ((indi = fam.getWife()) != null) {
            this.content.add("parent", this.indi(indi));
            ++n;
        }
        if (indi2 == null || indi == null) {
            this.content.add("parent", this.create(new CreateParent(fam)));
        }
        for (Indi indi3 : indiArray = fam.getChildren()) {
            this.content.add("child", this.indi(indi3));
        }
        this.content.add("child", this.create(new CreateChild(fam, true)));
        this.addExpander("parents", n);
        this.addExpander("children", indiArray.length);
    }

    private void setIndi(Indi indi) {
        Indi[] indiArray;
        this.context = new Context(indi);
        this.context.getGedcom().addGedcomListener(this.callback);
        List<Indi> list = this.getParents(indi.getParents());
        this.addExpander("grandparents", list.size());
        for (Indi indiArray22 : list) {
            this.content.add("grandparent", this.indi(indiArray22));
        }
        List<Indi> list2 = indi.getParents();
        this.addExpander("parents", list2.size());
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            indiArray = (Indi[])iterator.next();
            this.content.add("parent", this.indi((Indi)indiArray));
        }
        if (list2.size() < 2) {
            this.content.add("parent", this.create(new CreateParent(indi)));
        }
        Indi[] indiArray2 = indi.getSiblings(false);
        this.addExpander("siblings", indiArray2.length);
        for (Indi iterator2 : indiArray2) {
            this.content.add("sibling", this.indi(iterator2));
        }
        this.content.add("sibling", this.create(new CreateSibling(indi, true)));
        indiArray = indi.getPartners();
        this.addExpander("spouses", indiArray.length);
        for (Indi indi5 : indiArray) {
            this.content.add("spouse", this.indi(indi5));
        }
        if (indiArray.length == 0) {
            this.content.add("spouse", this.create(new CreateSpouse(indi)));
        }
        Indi[] indiArray3 = indi.getChildren();
        this.addExpander("children", indiArray3.length);
        for (Indi indi2 : indiArray3) {
            this.content.add("child", this.indi(indi2));
        }
        this.content.add("child", this.create(new CreateChild(indi, true)));
        List<Indi> list3 = this.getChildren(Arrays.asList(indiArray3));
        this.addExpander("grandchildren", list3.size());
        Iterator iterator3 = list3.iterator();
        while (iterator3.hasNext()) {
            Indi indi3 = (Indi)iterator3.next();
            this.content.add("grandchild", this.indi(indi3));
        }
    }

    private JLabel create(Action action) {
        JLabel jLabel = new JLabel("[" + RES.getString("create") + "]");
        Color color = jLabel.getForeground();
        jLabel.setForeground(new Color(color.getRed(), color.getGreen(), color.getBlue(), 128));
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        jLabel.putClientProperty(Action.class, action);
        jLabel.addMouseListener(CLICK);
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        return jLabel;
    }

    private List<Indi> getParents(List<Indi> list) {
        ArrayList<Indi> arrayList = new ArrayList<Indi>(4);
        for (Indi indi : list) {
            arrayList.addAll(indi.getParents());
        }
        return arrayList;
    }

    private List<Indi> getChildren(List<Indi> list) {
        ArrayList<Indi> arrayList = new ArrayList<Indi>(16);
        for (Indi indi : list) {
            arrayList.addAll(Arrays.asList(indi.getChildren()));
        }
        return arrayList;
    }

    private JLabel indi(Indi indi) {
        JLabel jLabel = new JLabel(indi.toString(), indi.getImage(), 2);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        jLabel.putClientProperty(Indi.class, indi);
        jLabel.addMouseListener(CLICK);
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        return jLabel;
    }
}

