/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.gedcom.Entity;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class PropertyWriter {
    boolean useIndents = false;
    private int lines = 0;
    private BufferedWriter out;

    public PropertyWriter(Writer writer, boolean bl) {
        this.out = new BufferedWriter(writer);
        this.useIndents = bl;
    }

    public int write(int n, Property property) throws IOException {
        this.writeProperty(n, property);
        this.out.flush();
        return this.lines;
    }

    public int getLines() {
        return this.lines;
    }

    protected String getValue(Property property) throws IOException {
        return property.getValue();
    }

    protected void writeProperty(int n, Property property) throws IOException {
        if (property.isTransient()) {
            return;
        }
        if (property instanceof MultiLineProperty) {
            this.writeMultiLine(n, property);
        } else {
            this.writeLine(n, this.getTag(property), this.getValue(property));
        }
        int n2 = property.getNoOfProperties();
        for (int i = 0; i < n2; ++i) {
            this.writeProperty(n + 1, property.getProperty(i));
        }
    }

    protected String getTag(Property property) {
        String string;
        if (property instanceof Entity && (string = ((Entity)property).getId()).length() > 0) {
            return '@' + string + "@ " + property.getTag();
        }
        return property.getTag();
    }

    private void writeMultiLine(int n, Property property) throws IOException {
        MultiLineProperty.Iterator iterator = ((MultiLineProperty)((Object)property)).getLineIterator();
        iterator.setValue(this.getValue(property));
        this.writeLine(n + iterator.getIndent(), this.getTag(property), iterator.getValue());
        while (iterator.next()) {
            this.writeLine(n + iterator.getIndent(), iterator.getTag(), iterator.getValue());
        }
    }

    private void writeLine(int n, String string, String string2) throws IOException {
        if (this.useIndents) {
            for (int i = 0; i < n; ++i) {
                this.out.write(32);
            }
        } else {
            this.out.write(Integer.toString(n));
            this.out.write(32);
        }
        this.out.write(string);
        if (string2 != null && string2.length() > 0) {
            this.out.write(32);
            this.out.write(string2);
        }
        this.out.newLine();
        ++this.lines;
    }
}

