/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class InputSource {
    private String name;

    protected InputSource(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public abstract InputStream open() throws IOException;

    public static InputSource get(File file) {
        return InputSource.get(file.getName(), file);
    }

    public static InputSource get(String string, File file) {
        return new FileInput(string, file);
    }

    public static InputSource get(String string, byte[] byArray) {
        return new ByteInput(string, byArray);
    }

    public static class ByteInput
    extends InputSource {
        private byte[] bytes;

        public ByteInput(String string, byte[] byArray) {
            super(string);
            this.bytes = byArray;
        }

        public InputStream open() {
            return new ByteArrayInputStream(this.bytes);
        }

        public boolean equals(Object object) {
            return object instanceof ByteInput && ((ByteInput)object).bytes.equals(this.bytes);
        }

        public int hashCode() {
            return this.bytes.hashCode();
        }

        public String toString() {
            return "byte array size=" + this.bytes.length + " name=" + this.getName();
        }
    }

    public static class FileInput
    extends InputSource {
        private File file;

        public FileInput(File file) {
            this(file.getName(), file);
        }

        public FileInput(String string, File file) {
            super(string);
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public InputStream open() throws IOException {
            return new FileInputStream(this.file);
        }

        public boolean equals(Object object) {
            if (!(object instanceof FileInput)) {
                return false;
            }
            FileInput fileInput = (FileInput)object;
            return fileInput.file.equals(this.file) && fileInput.getName().equals(this.getName());
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public String toString() {
            return "file name=" + this.getName() + " file=" + this.file.toString();
        }
    }
}

