/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.crypto.Enigma;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Submitter;
import genj.io.GedcomEncodingSniffer;
import genj.io.GedcomEncryptionException;
import genj.io.GedcomFormatException;
import genj.io.GedcomIOException;
import genj.io.GedcomReader;
import genj.io.GedcomReaderContext;
import genj.io.PropertyReader;
import genj.util.EnvironmentChecker;
import genj.util.MeteredInputStream;
import genj.util.Origin;
import genj.util.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GedcomReaderFactory {
    private static final Resources RESOURCES = Resources.get("genj.io");
    private static Logger LOG = Logger.getLogger("genj.io");
    private static final int ENTITY_AVG_SIZE = 150;

    public static GedcomReader createReader(Origin origin, GedcomReaderContext gedcomReaderContext) throws IOException {
        LOG.info("Initializing reader for " + origin);
        return new Impl(new Gedcom(origin), origin.open(), gedcomReaderContext != null ? gedcomReaderContext : new DefaultContext());
    }

    public static GedcomReader createReader(InputStream inputStream, GedcomReaderContext gedcomReaderContext) throws IOException {
        return new Impl(new Gedcom(), inputStream, gedcomReaderContext != null ? gedcomReaderContext : new DefaultContext());
    }

    private static class DefaultContext
    implements GedcomReaderContext {
        private DefaultContext() {
        }

        public String getPassword() {
            return null;
        }

        public void handleWarning(int n, String string, Context context) {
        }
    }

    private static class Impl
    implements GedcomReader {
        private static final int READHEADER = 0;
        private static final int READENTITIES = 1;
        private static final int LINKING = 2;
        private Gedcom gedcom;
        private int progress;
        private int entity = 0;
        private int state;
        private int length;
        private String gedcomLine;
        private ArrayList<LazyLink> lazyLinks = new ArrayList();
        private String tempSubmitter;
        private boolean cancel = false;
        private Object lock = new Object();
        private EntityReader reader;
        private MeteredInputStream meter;
        private Enigma enigma;
        private GedcomReaderContext context;

        private Impl(Gedcom gedcom, InputStream inputStream, GedcomReaderContext gedcomReaderContext) throws IOException {
            String string;
            GedcomEncodingSniffer gedcomEncodingSniffer = new GedcomEncodingSniffer(inputStream);
            Charset charset = gedcomEncodingSniffer.getCharset();
            String string2 = gedcomEncodingSniffer.getEncoding();
            if (!gedcomEncodingSniffer.isDeterministic()) {
                gedcomReaderContext.handleWarning(0, RESOURCES.getString("read.warn.nochar"), new Context(gedcom));
            }
            if ((string = EnvironmentChecker.getProperty("genj.gedcom.charset", null, "checking for forced charset for read of " + gedcom.getName())) != null) {
                try {
                    charset = Charset.forName(string);
                    string2 = "UTF-8";
                }
                catch (Throwable throwable) {
                    LOG.log(Level.WARNING, "Can't force charset " + charset, throwable);
                }
            }
            this.length = gedcomEncodingSniffer.available();
            this.gedcom = gedcom;
            this.gedcom.setEncoding(string2);
            this.context = gedcomReaderContext;
            this.meter = new MeteredInputStream(gedcomEncodingSniffer);
            this.reader = new EntityReader(new InputStreamReader((InputStream)this.meter, charset));
        }

        public void cancelTrackable() {
            this.cancel = true;
        }

        public int getProgress() {
            if (this.state == 1 && this.length > 0) {
                this.progress = (int)Math.min(100L, this.meter.getCount() * 100L / (long)this.length);
            }
            return this.progress;
        }

        public String getState() {
            switch (this.state) {
                case 0: {
                    return RESOURCES.getString("progress.read.header");
                }
                default: {
                    return RESOURCES.getString("progress.read.entities", "" + this.reader.getLines(), "" + this.entity);
                }
                case 2: 
            }
            return RESOURCES.getString("progress.read.linking");
        }

        public int getLines() {
            return this.reader.getLines();
        }

        public Gedcom read() throws GedcomEncryptionException, GedcomIOException, GedcomFormatException {
            if (this.gedcom == null) {
                throw new IllegalStateException("can't call read() twice");
            }
            try {
                this.readGedcom();
                Gedcom gedcom = this.gedcom;
                return gedcom;
            }
            catch (GedcomIOException gedcomIOException) {
                throw gedcomIOException;
            }
            catch (Throwable throwable) {
                LOG.log(Level.SEVERE, "unexpected throwable", throwable);
                throw new GedcomIOException(throwable.toString(), this.reader.getLines());
            }
            finally {
                try {
                    this.reader.in.close();
                }
                catch (Throwable throwable) {}
                this.gedcom = null;
                this.lazyLinks.clear();
            }
        }

        private void readGedcom() throws IOException {
            long l = System.currentTimeMillis();
            this.readHeader();
            ++this.state;
            long l2 = System.currentTimeMillis();
            while (this.reader.readEntity() != null) {
                if (!this.cancel) continue;
                throw new GedcomIOException("Cancelled", this.getLines());
            }
            long l3 = System.currentTimeMillis();
            ++this.state;
            if (this.tempSubmitter.length() > 0) {
                try {
                    Submitter submitter = (Submitter)this.gedcom.getEntity("SUBM", this.tempSubmitter.replace('@', ' ').trim());
                    this.gedcom.setSubmitter(submitter);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.context.handleWarning(0, RESOURCES.getString("read.warn.setsubmitter", this.tempSubmitter), new Context(this.gedcom));
                }
            }
            this.linkReferences();
            long l4 = System.currentTimeMillis();
            long l5 = System.currentTimeMillis();
            LOG.log(Level.FINE, this.gedcom.getName() + " loaded in " + (l5 - l) / 1000L + "s (header " + (l2 - l) / 1000L + "s, records " + (l3 - l2) / 1000L + "s, linking " + (l4 - l3) / 1000L + "s)");
        }

        private void linkReferences() throws GedcomIOException {
            int n = this.lazyLinks.size();
            for (int i = 0; i < n; ++i) {
                LazyLink lazyLink = this.lazyLinks.get(i);
                try {
                    if (lazyLink.xref.getParent() != null && lazyLink.xref.getTarget() == null) {
                        lazyLink.xref.link();
                    }
                    this.progress = Math.min(100, i * 200 / n);
                    continue;
                }
                catch (GedcomException gedcomException) {
                    this.context.handleWarning(lazyLink.line, gedcomException.getMessage(), new Context(lazyLink.xref));
                    continue;
                }
                catch (Throwable throwable) {
                    throw new GedcomIOException(RESOURCES.getString("read.error.xref", lazyLink.xref.getTag(), lazyLink.xref.getValue()), lazyLink.line);
                }
            }
        }

        private boolean readHeader() throws IOException {
            Property property;
            String string;
            String string2;
            Entity entity = this.reader.readEntity();
            if (entity == null || !entity.getTag().equals("HEAD")) {
                throw new GedcomFormatException(RESOURCES.getString("read.error.noheader"), 0);
            }
            this.tempSubmitter = entity.getPropertyValue("SUBM");
            String string3 = entity.getPropertyValue("SOUR");
            Property property2 = entity.getPropertyByPath("HEAD:GEDC:VERS");
            if (property2 == null || entity.getPropertyByPath("HEAD:GEDC:FORM") == null) {
                this.context.handleWarning(0, RESOURCES.getString("read.warn.badgedc"), new Context(this.gedcom));
            } else {
                string2 = property2.getValue();
                if ("5.5".equals(string2)) {
                    this.gedcom.setGrammar(Grammar.V55);
                    LOG.info("Found VERS " + string2 + " - Gedcom version is 5.5");
                } else if ("5.5.1".equals(string2)) {
                    this.gedcom.setGrammar(Grammar.V551);
                    LOG.info("Found VERS " + string2 + " - Gedcom version is 5.5.1");
                } else {
                    string = RESOURCES.getString("read.warn.badversion", string2, this.gedcom.getGrammar().getVersion());
                    this.context.handleWarning(0, RESOURCES.getString("read.warn.badversion", string2, this.gedcom.getGrammar().getVersion()), new Context(this.gedcom));
                    LOG.warning(string);
                }
            }
            string2 = entity.getPropertyValue("LANG");
            if (string2.length() > 0) {
                this.gedcom.setLanguage(string2);
                LOG.info("Found LANG " + string2 + " - Locale is " + this.gedcom.getLocale());
            }
            if ((string = entity.getPropertyValue("CHAR")).length() > 0) {
                this.gedcom.setEncoding(string);
                if (string.equals("ASCII")) {
                    this.context.handleWarning(0, RESOURCES.getString("read.warn.ascii"), new Context(this.gedcom));
                }
            }
            if ((property = entity.getProperty("PLAC")) != null) {
                String string4 = property.getPropertyValue("FORM");
                this.gedcom.setPlaceFormat(string4);
                LOG.info("Found Place.Format " + string4);
            }
            this.gedcom.deleteEntity(entity);
            return true;
        }

        private static class LazyLink {
            private PropertyXRef xref;
            private int line;

            LazyLink(PropertyXRef propertyXRef, int n) {
                this.xref = propertyXRef;
                this.line = n;
            }
        }

        private class EntityReader
        extends PropertyReader {
            EntityReader(Reader reader) {
                super(reader, null, false);
            }

            Entity readEntity() throws IOException {
                Entity entity;
                if (!this.readLine(true)) {
                    throw new GedcomFormatException(RESOURCES.getString("read.error.norecord"), this.lines);
                }
                if (this.level != 0) {
                    throw new GedcomFormatException(RESOURCES.getString("read.error.nonumber"), this.lines);
                }
                if (this.tag.equals("TRLR")) {
                    if (this.readLine(true)) {
                        throw new GedcomFormatException(RESOURCES.getString("read.error.aftertrlr"), this.lines);
                    }
                    return null;
                }
                try {
                    entity = Impl.this.gedcom.createEntity(this.tag, this.xref);
                    if (entity.getClass() != Entity.class && this.xref.length() == 0) {
                        Impl.this.context.handleWarning(this.getLines(), RESOURCES.getString("read.warn.recordnoid", Gedcom.getName(this.tag)), new Context(entity));
                    }
                    entity.setValue(this.value);
                    this.readProperties(entity, 0, 0);
                }
                catch (GedcomException gedcomException) {
                    throw new GedcomIOException(gedcomException.getMessage(), this.lines);
                }
                if (!this.tag.equals("TRLR")) {
                    Impl.this.entity++;
                }
                return entity;
            }

            protected void readProperties(Property property, int n, int n2) throws IOException {
                super.readProperties(property, n, n2);
                this.decryptLazy(property);
            }

            private void decryptLazy(Property property) throws GedcomIOException {
                if (property instanceof PropertyXRef) {
                    return;
                }
                if (property instanceof PropertyDate && property.isValid()) {
                    return;
                }
                String string = property.getValue();
                if (!Enigma.isEncrypted(string)) {
                    return;
                }
                while (Impl.this.enigma == null) {
                    String string2 = Impl.this.context.getPassword();
                    if (string2 == null) {
                        throw new GedcomIOException(RESOURCES.getString("crypt.password.required"), this.lines);
                    }
                    try {
                        Impl.this.enigma = Enigma.getInstance(string2);
                        Impl.this.enigma.decrypt(string);
                    }
                    catch (IOException iOException) {
                        Impl.this.enigma = null;
                    }
                }
                try {
                    property.setValue(Impl.this.enigma.decrypt(string));
                }
                catch (IOException iOException) {
                    throw new GedcomIOException(RESOURCES.getString("crypt.password.mismatch"), this.lines);
                }
            }

            protected void link(PropertyXRef propertyXRef, int n) {
                Impl.this.lazyLinks.add(new LazyLink(propertyXRef, n));
            }

            protected void trackEmptyLine() {
                if (!"TRLR".equals(this.tag)) {
                    Impl.this.context.handleWarning(this.getLines(), RESOURCES.getString("read.error.emptyline"), new Context(Impl.this.gedcom));
                }
            }

            protected void trackBadLevel(int n, Property property) {
                Impl.this.context.handleWarning(this.getLines(), RESOURCES.getString("read.warn.badlevel", "" + n), new Context(property));
            }

            protected void trackBadProperty(Property property, String string) {
                Impl.this.context.handleWarning(this.getLines(), string, new Context(property));
            }
        }
    }
}

