/*
 * Decompiled with CFR 0.152.
 */
package genj.help;

import genj.io.CachingStreamHandler;
import genj.util.Resources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;

class HelpWidget
extends JPanel {
    private static final Logger LOG = Logger.getLogger("genj.help");
    private static final Resources RESOURCES = Resources.get(HelpWidget.class);
    private static final CachingStreamHandler CACHE = new CachingStreamHandler("help");
    private static final String BASE_URL = "http://genj.sourceforge.net/wiki/%s/manual/";
    static final String WELCOME = "welcome";
    static final String MANUAL = "overview";
    static final String EXPORT = "?do=export_xhtmlbody";
    private String base;
    private JEditorPane content;
    private String page = null;

    public HelpWidget() {
        HTMLDocument hTMLDocument = new HTMLDocument();
        hTMLDocument.setAsynchronousLoadPriority(1);
        this.content = new JEditorPane();
        this.content.setBackground(Color.WHITE);
        this.content.setEditable(false);
        this.content.setEditorKit(new Kit());
        this.content.setDocument(hTMLDocument);
        this.content.addHyperlinkListener(new Hyperlinker());
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.content));
        String string = Locale.getDefault().getLanguage();
        if (!("en".equals(string) || "de".equals(string) || "fr".equals(string))) {
            string = "en";
        }
        this.base = String.format(BASE_URL, string);
    }

    String getPage() {
        return this.page;
    }

    void setPage(String string) {
        try {
            String string2 = this.page;
            this.page = string;
            this.content.setPage(new URL(null, this.base + string + EXPORT, CACHE));
            this.firePropertyChange("url", string2, string);
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "can't set help content", throwable);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(480, 480);
    }

    private class Hyperlinker
    implements HyperlinkListener {
        private Hyperlinker() {
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            String string = hyperlinkEvent.getDescription();
            if (string.startsWith("genj:")) {
                LOG.info("Click on " + string);
                return;
            }
            URL uRL = hyperlinkEvent.getURL();
            string = uRL.toString();
            if (string.startsWith(HelpWidget.this.base)) {
                if (string.indexOf(63) > 0) {
                    return;
                }
                HelpWidget.this.setPage(string.substring(HelpWidget.this.base.length()));
                return;
            }
            if (uRL != null) {
                try {
                    Desktop.getDesktop().browse(uRL.toURI());
                }
                catch (Throwable throwable) {
                    LOG.info("can't open external url " + string);
                }
            }
        }
    }

    private static class Kit
    extends HTMLEditorKit {
        private static Factory factory = new Factory();

        private Kit() {
        }

        public ViewFactory getViewFactory() {
            return factory;
        }

        private static class Factory
        extends HTMLEditorKit.HTMLFactory {
            private Factory() {
            }

            public View create(Element element) {
                Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (object instanceof HTML.Tag && object == HTML.Tag.IMG) {
                    MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
                    mutableAttributeSet.addAttribute(HTML.Attribute.BORDER, "0");
                    mutableAttributeSet.addAttribute(HTML.Attribute.ALIGN, "middle");
                    ImageView imageView = new ImageView(element);
                    return imageView;
                }
                return super.create(element);
            }
        }
    }
}

