/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom.time;

import genj.gedcom.GedcomException;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.GregorianCalendar;
import genj.gedcom.time.PointInTime;

public class FrenchRCalendar
extends Calendar {
    private static final int AN_0 = 2375474;
    private static final int AN_I = new GregorianCalendar().toJulianDay(21, 8, 1792);
    private static final int UNTIL = new GregorianCalendar().toJulianDay(0, 0, 1806);
    private static final String[] MONTHS = new String[]{"VEND", "BRUM", "FRIM", "NIVO", "PLUV", "VENT", "GERM", "FLOR", "PRAI", "MESS", "THER", "FRUC", "COMP"};
    private static final String[] WEEKDAYS = new String[]{"PRI", "DUO", "TRI", "QUA", "QUI", "SEX", "SEP", "OCT", "NON", "DEC", "VER", "GEN", "TRA", "OPI", "REC", "REV"};
    private static final int[] LEAP_YEARS = new int[]{3, 7, 11};
    private static final String YEARS_PREFIX = "An ";
    private static final String[] YEARS = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV"};
    private static final int DAYS_PER_MONTH = 30;
    private static final int DAYS_PER_4_YEARS = 1461;

    protected FrenchRCalendar() {
        super("@#DFRENCH R@", "french", "images/FrenchR", MONTHS, WEEKDAYS);
    }

    public int getDays(int n, int n2) {
        if (n < 12) {
            return 30;
        }
        return this.isLeap(n2) ? 6 : 5;
    }

    private boolean isLeap(int n) {
        return (n + 1) % 4 == 0;
    }

    protected String getDayOfWeek(PointInTime pointInTime, boolean bl) throws GedcomException {
        String[] stringArray;
        if (!pointInTime.isComplete()) {
            throw new GedcomException("");
        }
        String[] stringArray2 = stringArray = bl ? this.localizedWeekDays : this.weekDays;
        if (pointInTime.getMonth() == 12) {
            return stringArray[10 + pointInTime.getDay()];
        }
        return stringArray[pointInTime.getDay() % 10];
    }

    protected int toJulianDay(int n, int n2, int n3) throws GedcomException {
        int n4 = n3 * 1461 / 4 + n2 * 30 + n + 1 + 2375474;
        if (n4 < AN_I) {
            throw new GedcomException(resources.getString("frenchr.bef"));
        }
        if (n4 >= UNTIL) {
            throw new GedcomException(resources.getString("frenchr.aft"));
        }
        return n4;
    }

    protected PointInTime toPointInTime(int n) throws GedcomException {
        if (n < AN_I) {
            throw new GedcomException(resources.getString("frenchr.bef"));
        }
        if (n >= UNTIL) {
            throw new GedcomException(resources.getString("frenchr.aft"));
        }
        int n2 = (n - 2375474) * 4 - 1;
        int n3 = n2 / 1461;
        int n4 = n2 % 1461 / 4;
        int n5 = n4 / 30 + 1;
        int n6 = n4 % 30 + 1;
        return new PointInTime(n6 - 1, n5 - 1, n3, this);
    }

    public String getDisplayYear(int n) {
        if (n < 1 || n > YEARS.length) {
            return super.getDisplayYear(n);
        }
        return YEARS_PREFIX + YEARS[n - 1];
    }

    public int getYear(String string) throws GedcomException {
        if (string.length() > YEARS_PREFIX.length() && string.substring(0, YEARS_PREFIX.length()).equalsIgnoreCase(YEARS_PREFIX)) {
            string = string.substring(YEARS_PREFIX.length());
        }
        for (int i = 0; i < YEARS.length; ++i) {
            if (!YEARS[i].equals(string)) continue;
            return i + 1;
        }
        return super.getYear(string);
    }
}

