/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.util.swing.ImageIcon;
import java.util.ArrayList;
import java.util.List;

public abstract class PropertyXRef
extends Property {
    private PropertyXRef target = null;
    private String value = "";

    protected PropertyXRef(String string) {
        super(string);
    }

    void beforeDelNotify() {
        if (this.target != null) {
            PropertyXRef propertyXRef = this.target;
            Property property = propertyXRef.getParent();
            this.unlink();
            property.delProperty(propertyXRef);
        }
        super.beforeDelNotify();
    }

    public Entity getTargetEntity() {
        return this.target == null ? null : this.target.getEntity();
    }

    protected Entity getCandidate() throws GedcomException {
        if (this.target != null) {
            throw new IllegalArgumentException("Already linked");
        }
        Entity entity = this.getGedcom().getEntity(this.getTargetType(), this.value);
        if (entity == null) {
            throw new GedcomException(resources.getString("error.notfound", Gedcom.getName(this.getTargetType()), this.value));
        }
        return entity;
    }

    protected boolean isCandidate(Entity entity) {
        if (this.target != null) {
            return false;
        }
        return this.value.length() == 0 || entity.getId().equals(this.value);
    }

    public String getValue() {
        return this.target != null ? '@' + this.target.getEntity().getId() + '@' : '@' + this.value + '@';
    }

    public boolean isValid() {
        return this.target != null;
    }

    public abstract void link() throws GedcomException;

    protected void link(PropertyXRef propertyXRef) {
        if (this.target != null) {
            throw new IllegalArgumentException("can't link while target!=null");
        }
        if (propertyXRef == null) {
            throw new IllegalArgumentException("can't link to targe null");
        }
        this.target = propertyXRef;
        propertyXRef.target = this;
        this.propagateXRefLinked(this, propertyXRef);
    }

    public void unlink() {
        if (this.target == null) {
            throw new IllegalArgumentException("can't unlink without target");
        }
        PropertyXRef propertyXRef = this.target;
        this.target.target = null;
        this.target = null;
        this.propagateXRefUnlinked(this, propertyXRef);
    }

    public String getDisplayValue() {
        if (this.target == null) {
            return this.getValue();
        }
        return this.target.getEntity().toString();
    }

    protected String getForeignDisplayValue() {
        Entity entity = this.getEntity();
        Property property = this.getParent();
        String string = property != entity ? entity.toString() + " - " + property.getPropertyName() : entity.toString();
        return resources.getString("foreign.xref", string);
    }

    public PropertyXRef getTarget() {
        return this.target;
    }

    public void setValue(String string) {
        if (this.target != null) {
            return;
        }
        String string2 = this.getParent() == null ? null : this.getValue();
        this.value = string.replace('@', ' ').trim();
        if (string2 != null) {
            this.propagatePropertyChanged(this, string2);
        }
    }

    public String toString() {
        Entity entity = this.getTargetEntity();
        if (entity == null) {
            return super.toString();
        }
        return entity.toString();
    }

    public abstract String getTargetType();

    public String getDeleteVeto() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        String string = "prop." + this.getTag().toLowerCase() + ".veto";
        if (resources.contains(string)) {
            return resources.getString(string);
        }
        return resources.getString("prop.xref.veto");
    }

    public static Entity[] getReferences(Entity entity) {
        ArrayList<Entity> arrayList = new ArrayList<Entity>(10);
        List<PropertyXRef> list = entity.getProperties(PropertyXRef.class);
        for (PropertyXRef propertyXRef : list) {
            PropertyXRef propertyXRef2 = propertyXRef.getTarget();
            if (propertyXRef2 == null) continue;
            arrayList.add(propertyXRef2.getEntity());
        }
        return arrayList.toArray(new Entity[arrayList.size()]);
    }

    public ImageIcon getImage(boolean bl) {
        return this.overlay(super.getImage(false));
    }

    protected ImageIcon overlay(ImageIcon imageIcon) {
        ImageIcon imageIcon2 = this.target != null ? MetaProperty.IMG_LINK : MetaProperty.IMG_ERROR;
        return imageIcon.getOverLayed(imageIcon2);
    }

    public void setPrivate(boolean bl, boolean bl2) {
    }

    public int compareTo(Property property) {
        PropertyXRef propertyXRef = (PropertyXRef)property;
        if (this.getTargetEntity() == null || propertyXRef.getTargetEntity() == null) {
            return super.compareTo(propertyXRef);
        }
        return this.compare(this.getTargetEntity().toString(), propertyXRef.getTargetEntity().toString());
    }
}

