/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Options;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyComparator;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.PropertyHusband;
import genj.gedcom.PropertyWife;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fam
extends Entity {
    public static final TagPath PATH_FAMMARRDATE = new TagPath("FAM:MARR:DATE");
    public static final TagPath PATH_FAMMARRPLAC = new TagPath("FAM:MARR:PLAC");
    public static final TagPath PATH_FAMDIVDATE = new TagPath("FAM:DIV:DATE");
    public static final TagPath PATH_FAMDIVPLAC = new TagPath("FAM:DIV:PLAC");
    private static final TagPath SORT_SIBLINGS = new TagPath("CHIL:*:..:BIRT:DATE");

    public Fam(String string, String string2) {
        super(string, string2);
        this.assertTag("FAM");
    }

    public Indi getChild(int n) {
        int n2 = this.getNoOfProperties();
        for (int i = 0; i < n2; ++i) {
            Property property = this.getProperty(i);
            if (!"CHIL".equals(property.getTag()) || !property.isValid()) continue;
            if (n == 0) {
                return ((PropertyChild)property).getChild();
            }
            --n;
        }
        throw new IllegalArgumentException("no such child");
    }

    public Indi[] getChildren() {
        return this.getChildren(true);
    }

    public Indi[] getChildren(boolean bl) {
        Property property;
        ArrayList<PropertyChild> arrayList = new ArrayList<PropertyChild>(this.getNoOfProperties());
        for (PropertyChild propertyChild : this.getProperties(PropertyChild.class)) {
            if (!propertyChild.isValid()) continue;
            arrayList.add(propertyChild);
            if (!bl || (property = propertyChild.getProperty(SORT_SIBLINGS)) != null && property.isValid()) continue;
            bl = false;
        }
        if (bl) {
            Collections.sort(arrayList, new CHILComparator());
        }
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            property = ((PropertyChild)arrayList.get(i)).getChild();
            if (arrayList2.contains(property)) continue;
            arrayList2.add(property);
        }
        return Indi.toIndiArray(arrayList2);
    }

    public Indi getHusband() {
        Property property = this.getProperty("HUSB", true);
        if (property instanceof PropertyHusband) {
            return ((PropertyHusband)property).getHusband();
        }
        return null;
    }

    public int getNoOfChildren() {
        int n = 0;
        int n2 = this.getNoOfProperties();
        for (int i = 0; i < n2; ++i) {
            Property property = this.getProperty(i);
            if (property.getClass() != PropertyChild.class || !property.isValid()) continue;
            ++n;
        }
        return n;
    }

    public int getNoOfSpouses() {
        int n = 0;
        if (this.getHusband() != null) {
            ++n;
        }
        if (this.getWife() != null) {
            ++n;
        }
        return n;
    }

    public Indi getSpouse(int n) {
        Indi indi;
        Indi indi2 = this.getHusband();
        if (indi2 != null) {
            if (n == 0) {
                return indi2;
            }
            --n;
        }
        if ((indi = this.getWife()) != null) {
            if (n == 0) {
                return indi;
            }
            --n;
        }
        throw new IllegalArgumentException("No such spouse");
    }

    public List<Indi> getSpouses() {
        ArrayList<Indi> arrayList = new ArrayList<Indi>();
        if (this.getHusband() != null) {
            arrayList.add(this.getHusband());
        }
        if (this.getWife() != null) {
            arrayList.add(this.getWife());
        }
        return arrayList;
    }

    public Indi getOtherSpouse(Indi indi) {
        Indi indi2 = this.getWife();
        if (indi2 == indi) {
            return this.getHusband();
        }
        return indi2;
    }

    public Indi getWife() {
        Property property = this.getProperty("WIFE", true);
        if (property instanceof PropertyWife) {
            return ((PropertyWife)property).getWife();
        }
        return null;
    }

    public PropertyXRef setHusband(Indi indi) throws GedcomException {
        int n = this.getNoOfProperties();
        for (int i = 0; i < n; ++i) {
            Property property = this.getProperty(i);
            if (!"HUSB".equals(property.getTag()) || !property.isValid()) continue;
            this.delProperty(property);
            break;
        }
        if (indi == null) {
            return null;
        }
        PropertyHusband propertyHusband = new PropertyHusband();
        propertyHusband.setValue(indi.getId());
        this.addProperty(propertyHusband);
        try {
            propertyHusband.link();
        }
        catch (GedcomException gedcomException) {
            this.delProperty(propertyHusband);
            throw gedcomException;
        }
        if (indi.getSex() != 1) {
            indi.setSex(1);
        }
        return propertyHusband;
    }

    public PropertyXRef setWife(Indi indi) throws GedcomException {
        int n = this.getNoOfProperties();
        for (int i = 0; i < n; ++i) {
            Property property = this.getProperty(i);
            if (!"WIFE".equals(property.getTag()) || !property.isValid()) continue;
            this.delProperty(property);
            break;
        }
        if (indi == null) {
            return null;
        }
        PropertyWife propertyWife = new PropertyWife();
        propertyWife.setValue(indi.getId());
        this.addProperty(propertyWife);
        try {
            propertyWife.link();
        }
        catch (GedcomException gedcomException) {
            this.delProperty(propertyWife);
            throw gedcomException;
        }
        if (indi.getSex() != 2) {
            indi.setSex(2);
        }
        return propertyWife;
    }

    public PropertyXRef setSpouse(Indi indi) throws GedcomException {
        PropertyXRef propertyXRef;
        Indi indi2 = this.getHusband();
        Indi indi3 = this.getWife();
        if (indi2 != null && indi3 != null) {
            throw new GedcomException(resources.getString("error.already.spouses", this));
        }
        switch (indi.getSex()) {
            default: {
                propertyXRef = indi2 != null ? this.setWife(indi) : this.setHusband(indi);
                break;
            }
            case 1: {
                propertyXRef = this.setHusband(indi);
                if (indi2 == null) break;
                this.setWife(indi2);
                break;
            }
            case 2: {
                propertyXRef = this.setWife(indi);
                if (indi3 == null) break;
                this.setHusband(indi3);
            }
        }
        return propertyXRef;
    }

    public PropertyXRef addChild(Indi indi) throws GedcomException {
        PropertyChild propertyChild = new PropertyChild();
        propertyChild.setValue(indi.getId());
        this.addProperty(propertyChild);
        try {
            propertyChild.link();
        }
        catch (GedcomException gedcomException) {
            this.delProperty(propertyChild);
            throw gedcomException;
        }
        return propertyChild;
    }

    static Fam[] toFamArray(Collection<Fam> collection) {
        return collection.toArray(new Fam[collection.size()]);
    }

    @Override
    protected String getToStringPrefix(boolean bl) {
        Indi indi;
        StringBuffer stringBuffer = new StringBuffer();
        Indi indi2 = this.getHusband();
        if (indi2 != null) {
            stringBuffer.append(indi2.toString(bl));
            stringBuffer.append(Options.getInstance().getTxtMarriageSymbol());
        }
        if ((indi = this.getWife()) != null) {
            stringBuffer.append(indi.toString(bl));
        }
        return stringBuffer.toString();
    }

    public PropertyDate getMarriageDate() {
        return this.getMarriageDate(false);
    }

    public PropertyDate getMarriageDate(boolean bl) {
        PropertyDate propertyDate = (PropertyDate)this.getProperty(PATH_FAMMARRDATE);
        if (null != propertyDate || !bl) {
            return propertyDate;
        }
        this.setValue(PATH_FAMMARRDATE, "");
        return (PropertyDate)this.getProperty(PATH_FAMMARRDATE);
    }

    public PropertyDate getDivorceDate() {
        return (PropertyDate)this.getProperty(PATH_FAMDIVDATE);
    }

    public void swapSpouses() throws GedcomException {
        PropertyHusband propertyHusband = (PropertyHusband)this.getProperty("HUSB", true);
        PropertyWife propertyWife = (PropertyWife)this.getProperty("WIFE", true);
        if (propertyHusband == null && propertyWife == null) {
            return;
        }
        if (propertyHusband == null) {
            this.setHusband(this.getWife());
            return;
        }
        if (propertyWife == null) {
            this.setWife(this.getHusband());
            return;
        }
        PropertyFamilySpouse propertyFamilySpouse = null;
        PropertyFamilySpouse propertyFamilySpouse2 = null;
        if (propertyHusband != null) {
            propertyFamilySpouse = (PropertyFamilySpouse)propertyHusband.getTarget();
            propertyHusband.unlink();
        }
        if (propertyWife != null) {
            propertyFamilySpouse2 = (PropertyFamilySpouse)propertyWife.getTarget();
            propertyWife.unlink();
        }
        if (propertyHusband != null && propertyFamilySpouse2 != null) {
            propertyHusband.link(propertyFamilySpouse2);
        }
        if (propertyWife != null && propertyFamilySpouse != null) {
            propertyWife.link(propertyFamilySpouse);
        }
    }

    private class CHILComparator
    extends PropertyComparator {
        CHILComparator() {
            super(SORT_SIBLINGS);
        }

        public int compare(Property property, Property property2) {
            int n = super.compare(property, property2);
            return n != 0 ? n : Fam.this.getPropertyPosition(property) - Fam.this.getPropertyPosition(property2);
        }
    }
}

