/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context {
    private Gedcom gedcom;
    private List<Entity> entities = new ArrayList<Entity>();
    private List<Property> properties = new ArrayList<Property>();

    public boolean equals(Object object) {
        if (!(object instanceof Context)) {
            return false;
        }
        Context context = (Context)object;
        return this.gedcom == context.gedcom && this.entities.equals(context.entities) && this.properties.equals(context.properties);
    }

    public Context() {
    }

    public Context(Context context) {
        this.gedcom = context.gedcom;
        this.entities.addAll(context.entities);
        this.properties.addAll(context.properties);
    }

    public Context(Gedcom gedcom, Collection<? extends Entity> collection) {
        this(gedcom, collection, null);
    }

    public Context(Gedcom gedcom, Collection<? extends Entity> collection, Collection<? extends Property> collection2) {
        this.gedcom = gedcom;
        if (collection != null) {
            for (Entity property : collection) {
                if (property.getGedcom() != gedcom) {
                    throw new IllegalArgumentException("gedcom must be same");
                }
                if (this.entities.contains(property)) continue;
                this.entities.add(property);
            }
        }
        if (collection2 != null) {
            for (Property property : collection2) {
                if (property instanceof Entity) {
                    if (this.entities.contains(property)) continue;
                    this.entities.add((Entity)property);
                    continue;
                }
                if (this.properties.contains(property)) continue;
                Entity entity = property.getEntity();
                if (entity.getGedcom() != gedcom) {
                    throw new IllegalArgumentException("gedcom must be same");
                }
                this.properties.add(property);
                if (this.entities.contains(entity)) continue;
                this.entities.add(entity);
            }
        }
    }

    public Context(Gedcom gedcom) {
        this.gedcom = gedcom;
    }

    public Context(Property property) {
        this(property.getGedcom());
        this.properties.add(property);
        Entity entity = property.getEntity();
        if (!this.entities.contains(entity)) {
            this.entities.add(entity);
        }
    }

    public Context(Entity entity) {
        this(entity.getGedcom());
        this.entities.add(entity);
    }

    public Context remove(Entity entity) {
        ArrayList<Entity> arrayList = new ArrayList<Entity>(this.entities);
        arrayList.remove(entity);
        ArrayList<Property> arrayList2 = new ArrayList<Property>(this.properties.size());
        for (Property property : this.properties) {
            Entity entity2 = property.getEntity();
            if (entity2 == entity || entity2 == null) continue;
            arrayList2.add(property);
        }
        return new Context(this.gedcom, arrayList, arrayList2);
    }

    public Context remove(Property property) {
        ArrayList<Entity> arrayList = new ArrayList<Entity>(this.entities);
        ArrayList<Property> arrayList2 = new ArrayList<Property>(this.properties);
        arrayList2.remove(property);
        return new Context(this.gedcom, arrayList, arrayList2);
    }

    public Gedcom getGedcom() {
        return this.gedcom;
    }

    public Entity getEntity() {
        return this.entities.isEmpty() ? null : this.entities.get(0);
    }

    public Property getProperty() {
        return this.properties.isEmpty() ? null : this.properties.get(0);
    }

    public List<? extends Entity> getEntities() {
        return this.entities;
    }

    public List<? extends Property> getProperties() {
        return this.properties;
    }

    public String toString() {
        if (this.gedcom == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.gedcom.getName());
        for (Entity entity : this.entities) {
            stringBuffer.append(";");
            stringBuffer.append(entity.getId());
            for (Property property : this.properties) {
                if (property.getEntity() != entity) continue;
                stringBuffer.append(",");
                stringBuffer.append(property.getPath());
            }
        }
        return stringBuffer.toString();
    }

    public static Context fromString(Gedcom gedcom, String string) throws GedcomException {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        ArrayList<Property> arrayList2 = new ArrayList<Property>();
        String[] stringArray = string.split(";");
        if (!stringArray[0].equals(gedcom.getName())) {
            throw new GedcomException(stringArray[0] + " doesn't match " + gedcom.getName());
        }
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(",");
            Entity entity = gedcom.getEntity(stringArray2[0]);
            if (entity == null) {
                throw new GedcomException(stringArray2[0] + " not in " + gedcom);
            }
            arrayList.add(entity);
            for (int j = 1; j < stringArray2.length; ++j) {
                try {
                    Property property = entity.getPropertyByPath(stringArray2[j]);
                    if (property == null) {
                        throw new GedcomException(stringArray2[j] + " not in " + stringArray2[0] + " in " + gedcom);
                    }
                    arrayList2.add(property);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new GedcomException(stringArray2[j] + " not valid for " + stringArray[i]);
                }
            }
        }
        return new Context(gedcom, arrayList, arrayList2);
    }
}

