/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.common.SelectEntityWidget;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.gedcom.UnitOfWork;
import genj.util.swing.Action2;
import genj.util.swing.DialogHelper;
import genj.view.SelectionSink;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import javax.swing.Action;

public class XRefBean
extends PropertyBean {
    private PropertyBean.Preview preview = new PropertyBean.Preview();
    private PropertyXRef xref;

    public ViewContext getContext() {
        ViewContext viewContext = super.getContext();
        if (viewContext != null) {
            viewContext.addAction(new Swivel());
        }
        return viewContext;
    }

    public XRefBean() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.preview);
        this.preview.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() < 2) {
                    return;
                }
                if (XRefBean.this.xref == null) {
                    return;
                }
                SelectionSink.Dispatcher.fireSelection(mouseEvent, new ViewContext(XRefBean.this.xref));
            }
        });
    }

    protected void commitImpl(Property property) {
    }

    public boolean isEditable() {
        return false;
    }

    public void setPropertyImpl(Property property) {
        PropertyXRef propertyXRef;
        this.xref = propertyXRef = (PropertyXRef)property;
        if (propertyXRef != null && propertyXRef.getTargetEntity() != null) {
            this.preview.setEntity(propertyXRef.getTargetEntity());
        } else {
            this.preview.setEntity(null);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(64, 48);
    }

    private class Swivel
    extends Action2 {
        public Swivel() {
            this.setText(PropertyBean.RESOURCES.getString("xref.swivel"));
            this.setImage(MetaProperty.IMG_LINK);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (XRefBean.this.xref == null) {
                return;
            }
            SelectEntityWidget selectEntityWidget = new SelectEntityWidget(XRefBean.this.xref.getGedcom(), XRefBean.this.xref.getTargetType(), null);
            if (0 != DialogHelper.openDialog(this.getText(), 3, selectEntityWidget, (Action[])Action2.okCancel(), (Object)actionEvent)) {
                return;
            }
            final Entity entity = selectEntityWidget.getSelection();
            if (XRefBean.this.xref.getTarget() != null) {
                PropertyBean.LOG.fine("Swiveling " + XRefBean.this.xref.getEntity().getId() + "." + XRefBean.this.xref.getPath() + " from " + XRefBean.this.xref.getTarget().getEntity().getId() + " to " + entity.getId());
            } else {
                PropertyBean.LOG.fine("Swiveling " + XRefBean.this.xref.getEntity().getId() + "." + XRefBean.this.xref.getPath() + " to " + entity.getId());
            }
            try {
                XRefBean.this.xref.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        PropertyXRef propertyXRef = XRefBean.this.xref.getTarget();
                        if (propertyXRef != null) {
                            XRefBean.this.xref.unlink();
                            propertyXRef.getParent().delProperty(propertyXRef);
                        }
                        XRefBean.this.xref.setValue("@" + entity.getId() + "@");
                        XRefBean.this.xref.link();
                    }
                });
            }
            catch (GedcomException gedcomException) {
                DialogHelper.openDialog(this.getText(), 2, gedcomException.getMessage(), (Action[])Action2.okOnly(), (Object)actionEvent);
                PropertyBean.LOG.log(Level.FINER, gedcomException.getMessage(), gedcomException);
            }
        }
    }
}

