/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.common.AbstractPropertyTableModel;
import genj.common.PropertyTableWidget;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Gedcom;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyFamilyChild;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.PropertyHusband;
import genj.gedcom.PropertyWife;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class ReferencesBean
extends PropertyBean {
    public static Icon IMG = MetaProperty.IMG_LINK;
    private PropertyTableWidget table = new PropertyTableWidget();

    public ReferencesBean() {
        this.table.setVisibleRowCount(2);
        this.setLayout(new BorderLayout());
        this.add("Center", this.table);
    }

    public void removeNotify() {
        REGISTRY.put("refcols", this.table.getColumnLayout());
        super.removeNotify();
    }

    protected void commitImpl(Property property) {
    }

    protected void setPropertyImpl(Property property) {
        Model model = null;
        if (property != null) {
            model = this.getModel(property);
        }
        this.table.setModel(model);
        this.table.setColumnLayout(REGISTRY.get("refcols", ""));
    }

    private Model getModel(Property property) {
        ArrayList<PropertyXRef> arrayList = new ArrayList<PropertyXRef>();
        for (PropertyXRef propertyXRef : property.getProperties(PropertyXRef.class)) {
            if (propertyXRef instanceof PropertyHusband || propertyXRef instanceof PropertyWife || propertyXRef instanceof PropertyChild || propertyXRef instanceof PropertyFamilyChild || propertyXRef instanceof PropertyFamilySpouse || !propertyXRef.isValid()) continue;
            arrayList.add(propertyXRef);
        }
        return new Model(property, arrayList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Model
    extends AbstractPropertyTableModel {
        private List<PropertyXRef> rows;
        private TagPath[] columns;

        Model(Property property, List<PropertyXRef> list) {
            super(property.getGedcom());
            this.columns = new TagPath[]{new TagPath(".", Gedcom.getName("REFN")), new TagPath("*:..:..", "*")};
            this.rows = list;
        }

        @Override
        public int getNumCols() {
            return this.columns.length;
        }

        @Override
        public int getNumRows() {
            return this.rows.size();
        }

        @Override
        public TagPath getColPath(int n) {
            return this.columns[n];
        }

        @Override
        public Property getRowRoot(int n) {
            return this.rows.get(n);
        }

        @Override
        public String getCellValue(Property property, int n, int n2) {
            switch (n2) {
                case 0: {
                    PropertyXRef propertyXRef;
                    if (property instanceof PropertyXRef && (propertyXRef = (PropertyXRef)property).isTransient()) {
                        property = propertyXRef.getTarget().getParent();
                    }
                    return property.getPropertyName();
                }
            }
            return property.toString();
        }

        @Override
        public int getCellAlignment(Property property, int n, int n2) {
            return 2;
        }
    }
}

