/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.edit.beans.AgeBean;
import genj.edit.beans.ChoiceBean;
import genj.edit.beans.DateBean;
import genj.edit.beans.EntityBean;
import genj.edit.beans.EventBean;
import genj.edit.beans.FileBean;
import genj.edit.beans.MLEBean;
import genj.edit.beans.NameBean;
import genj.edit.beans.PlaceBean;
import genj.edit.beans.QualityBean;
import genj.edit.beans.SexBean;
import genj.edit.beans.SimpleValueBean;
import genj.edit.beans.XRefBean;
import genj.gedcom.Entity;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyAge;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyChoiceValue;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMultilineValue;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyQuality;
import genj.gedcom.PropertySex;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.renderer.BlueprintManager;
import genj.renderer.BlueprintRenderer;
import genj.util.ChangeSupport;
import genj.util.EnvironmentChecker;
import genj.util.Registry;
import genj.util.Resources;
import genj.view.ContextProvider;
import genj.view.ViewContext;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyBean
extends JPanel
implements ContextProvider {
    private static final int CACHE_PRELOAD = 10;
    protected static final Resources RESOURCES = Resources.get(PropertyBean.class);
    protected static final Logger LOG = Logger.getLogger("genj.edit.beans");
    protected static final Registry REGISTRY = Registry.get(PropertyBean.class);
    private static final Class<?>[] PROPERTY2BEANTYPE = new Class[]{Entity.class, EntityBean.class, PropertyQuality.class, QualityBean.class, PropertyPlace.class, PlaceBean.class, PropertyAge.class, AgeBean.class, PropertyChoiceValue.class, ChoiceBean.class, PropertyDate.class, DateBean.class, PropertyEvent.class, EventBean.class, PropertyFile.class, FileBean.class, PropertyBlob.class, FileBean.class, PropertyMultilineValue.class, MLEBean.class, PropertyName.class, NameBean.class, PropertySex.class, SexBean.class, PropertyXRef.class, XRefBean.class, Property.class, SimpleValueBean.class};
    private static final boolean isCache = "true".equals(EnvironmentChecker.getProperty("genj.edit.beans.cache", "true", "checking if bean cache is enabled or not"));
    private static final Map<Class<? extends PropertyBean>, List<PropertyBean>> BEANCACHE = PropertyBean.createBeanCache();
    protected Property root;
    protected TagPath path;
    protected Property property;
    protected List<? extends PropertyBean> session;
    protected JComponent defaultFocus = null;
    protected ChangeSupport changeSupport = new ChangeSupport(this);

    private static Map<Class<? extends PropertyBean>, List<PropertyBean>> createBeanCache() {
        LOG.fine("Initializing bean cache");
        HashMap<Class<? extends PropertyBean>, List<PropertyBean>> hashMap = new HashMap<Class<? extends PropertyBean>, List<PropertyBean>>();
        if (isCache) {
            for (int i = 0; i < PROPERTY2BEANTYPE.length; i += 2) {
                try {
                    ArrayList<PropertyBean> arrayList = new ArrayList<PropertyBean>(10);
                    for (int j = 0; j < 10; ++j) {
                        arrayList.add((PropertyBean)PROPERTY2BEANTYPE[i + 1].newInstance());
                    }
                    hashMap.put(PROPERTY2BEANTYPE[i + 1], arrayList);
                    continue;
                }
                catch (Throwable throwable) {
                    LOG.log(Level.WARNING, "can't instantiate bean " + PROPERTY2BEANTYPE[i + 1], throwable);
                }
            }
        }
        return hashMap;
    }

    public static PropertyBean getBean(Class<? extends Property> clazz) {
        for (int i = 0; i < PROPERTY2BEANTYPE.length; i += 2) {
            if (PROPERTY2BEANTYPE[i] == null || !PROPERTY2BEANTYPE[i].isAssignableFrom(clazz)) continue;
            return PropertyBean.getBeanImpl(PROPERTY2BEANTYPE[i + 1]);
        }
        LOG.warning("Can't find declared bean for property type " + clazz.getName() + ")");
        return PropertyBean.getBeanImpl(SimpleValueBean.class);
    }

    public static PropertyBean getBean(String string) {
        try {
            return PropertyBean.getBeanImpl(Class.forName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.log(Level.FINE, "Can't find desired bean " + string, classNotFoundException);
            return PropertyBean.getBeanImpl(SimpleValueBean.class);
        }
    }

    private static PropertyBean getBeanImpl(Class<? extends PropertyBean> clazz) {
        try {
            List<PropertyBean> list = BEANCACHE.get(clazz);
            if (list != null && !list.isEmpty()) {
                PropertyBean propertyBean = list.remove(list.size() - 1);
                if (propertyBean.getParent() == null) {
                    return propertyBean;
                }
                LOG.log(Level.FINE, "Bean has parent coming out of cache " + propertyBean);
            }
            return clazz.newInstance();
        }
        catch (Throwable throwable) {
            LOG.log(Level.FINE, "Problem with bean lookup " + clazz.getName(), throwable);
            return new SimpleValueBean();
        }
    }

    public static void recycle(PropertyBean propertyBean) {
        if (propertyBean.getParent() != null) {
            throw new IllegalArgumentException("bean still has parent");
        }
        propertyBean.root = null;
        propertyBean.path = null;
        propertyBean.property = null;
        propertyBean.session = null;
        if (!isCache) {
            return;
        }
        List<PropertyBean> list = BEANCACHE.get(propertyBean.getClass());
        if (list == null) {
            list = new ArrayList<PropertyBean>();
            BEANCACHE.put(propertyBean.getClass(), list);
        }
        if (list.size() < 10) {
            list.add(propertyBean);
        }
    }

    public static Set<Class<? extends PropertyBean>> getAvailableBeans() {
        return Collections.unmodifiableSet(BEANCACHE.keySet());
    }

    protected PropertyBean() {
        this.setOpaque(false);
    }

    public void setPreferHorizontal(boolean bl) {
    }

    public final PropertyBean setContext(Property property) {
        return this.setContext(property, new TagPath("."), property, new ArrayList<PropertyBean>());
    }

    public final PropertyBean setContext(Property property, TagPath tagPath, Property property2, List<PropertyBean> list) {
        if (property == null || tagPath == null) {
            throw new IllegalArgumentException("root and path cannot be null");
        }
        this.root = property;
        this.path = tagPath;
        this.property = property2;
        this.session = list;
        this.setPropertyImpl(property2);
        this.changeSupport.setChanged(false);
        return this;
    }

    protected abstract void setPropertyImpl(Property var1);

    @Override
    public ViewContext getContext() {
        return this.property == null || this.property.getEntity() == null ? null : new ViewContext(this.property);
    }

    public final Property getRoot() {
        return this.root;
    }

    public final TagPath getPath() {
        return this.path;
    }

    public final Property getProperty() {
        return this.property;
    }

    public boolean isCommittable() {
        return true;
    }

    public boolean hasChanged() {
        return this.changeSupport.hasChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public final void commit() throws GedcomException {
        if (this.property == null) {
            this.property = this.root.setValue(this.path, "");
        }
        this.commitImpl(this.property);
        this.changeSupport.setChanged(false);
    }

    protected abstract void commitImpl(Property var1) throws GedcomException;

    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.defaultFocus != null) {
            return this.defaultFocus.requestFocusInWindow();
        }
        return false;
    }

    @Override
    public void requestFocus() {
        if (this.defaultFocus != null) {
            this.defaultFocus.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public List<? extends Action> getActions() {
        return new ArrayList();
    }

    public class Preview
    extends JComponent {
        private Entity entity;
        private BlueprintRenderer renderer;

        protected Preview() {
            this.setBorder(new EmptyBorder(4, 4, 4, 4));
        }

        protected void paintComponent(Graphics graphics) {
            Insets insets = this.getInsets();
            Rectangle rectangle = new Rectangle(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.renderer != null && this.entity != null) {
                this.renderer.render(graphics, this.entity, rectangle);
            }
        }

        protected void setEntity(Entity entity) {
            this.entity = entity;
            if (this.entity != null) {
                this.renderer = new BlueprintRenderer(BlueprintManager.getInstance().getBlueprint(this.entity.getTag(), "Edit"));
            }
            this.repaint();
        }
    }
}

