/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.edit.Options;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyName;
import genj.util.swing.Action2;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.DialogHelper;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.TextFieldWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NameBean
extends PropertyBean {
    private static final NestedBlockLayout LAYOUT = new NestedBlockLayout("<table><row><l/><v wx=\"1\"/></row><row><l/><row><v wx=\"1\"/><check pad=\"0\"/></row></row><row><l/><v/></row><row><l/><v/></row></table>");
    private Property[] sameLastNames = new Property[0];
    private ChoiceWidget cLast;
    private ChoiceWidget cFirst;
    private JCheckBox cAll;
    private TextFieldWidget tSuff;
    private TextFieldWidget tNick;

    private String getReplaceAllMsg() {
        if (this.sameLastNames.length < 2) {
            return null;
        }
        return RESOURCES.getString("choice.global.confirm", "" + this.sameLastNames.length, ((PropertyName)this.getProperty()).getLastName(), this.cLast.getText());
    }

    public NameBean() {
        this.setLayout(LAYOUT.copy());
        this.cLast = new ChoiceWidget();
        this.cLast.addChangeListener(this.changeSupport);
        this.cLast.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                String string = NameBean.this.getReplaceAllMsg();
                if (string != null) {
                    NameBean.this.cAll.setVisible(true);
                    NameBean.this.cAll.setToolTipText(string);
                }
            }
        });
        this.cLast.setIgnoreCase(true);
        this.cFirst = new ChoiceWidget();
        this.cFirst.addChangeListener(this.changeSupport);
        this.cFirst.setIgnoreCase(true);
        this.tSuff = new TextFieldWidget("", 10);
        this.tSuff.addChangeListener(this.changeSupport);
        this.tNick = new TextFieldWidget("", 10);
        this.tNick.addChangeListener(this.changeSupport);
        this.cAll = new JCheckBox();
        this.cAll.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.cAll.setVisible(false);
        this.cAll.setRequestFocusEnabled(false);
        this.add(new JLabel(PropertyName.getLabelForFirstName()));
        this.add(this.cFirst);
        this.add(new JLabel(PropertyName.getLabelForLastName()));
        this.add(this.cLast);
        this.add(this.cAll);
        this.add(new JLabel(PropertyName.getLabelForSuffix()));
        this.add(this.tSuff);
        this.add(new JLabel(Gedcom.getName("NICK")));
        this.add(this.tNick);
        this.cAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = NameBean.this.getReplaceAllMsg();
                if (string != null && NameBean.this.cAll.isSelected()) {
                    int n = DialogHelper.openDialog(PropertyBean.RESOURCES.getString("choice.global.enable"), 3, string, (Action[])Action2.yesNo(), (Object)NameBean.this);
                    NameBean.this.cAll.setSelected(n == 0);
                }
            }
        });
        this.defaultFocus = this.cFirst;
    }

    protected void commitImpl(Property property) {
        PropertyName propertyName = (PropertyName)property;
        String string = this.cFirst.getText().trim();
        String string2 = this.cLast.getText().trim();
        String string3 = this.tSuff.getText().trim();
        String string4 = this.tNick.getText().trim();
        Gedcom gedcom = propertyName.getGedcom();
        if (gedcom != null) {
            switch (Options.getInstance().correctName) {
                case 2: {
                    string2 = string2.toUpperCase(gedcom.getLocale());
                    this.cLast.setText(string2);
                }
                case 1: {
                    if (string.length() <= 0) break;
                    string = Character.toString(string.charAt(0)).toUpperCase(gedcom.getLocale()) + string.substring(1);
                    this.cFirst.setText(string);
                }
            }
        }
        propertyName.setName(string, string2, string3, this.cAll.isSelected());
        propertyName.setNick(string4);
        this.setPropertyImpl(propertyName);
    }

    public void setPropertyImpl(Property property) {
        PropertyName propertyName = (PropertyName)property;
        if (propertyName == null) {
            this.sameLastNames = new Property[0];
            this.cLast.setValues(PropertyName.getLastNames(this.getRoot().getGedcom(), true));
            this.cLast.setText("");
            this.cFirst.setValues(PropertyName.getFirstNames(this.getRoot().getGedcom(), true));
            this.cFirst.setText("");
            this.tSuff.setText("");
            this.tNick.setText("");
        } else {
            this.sameLastNames = propertyName.getSameLastNames();
            this.cLast.setValues(propertyName.getLastNames(true));
            this.cLast.setText(propertyName.getLastName());
            this.cFirst.setValues(propertyName.getFirstNames(true));
            this.cFirst.setText(propertyName.getFirstName());
            this.tSuff.setText(propertyName.getSuffix());
            this.tNick.setText(propertyName.getNick());
        }
        this.cAll.setVisible(false);
        this.cAll.setSelected(false);
    }
}

