/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import genj.edit.AdvancedEditor;
import genj.edit.BasicEditor;
import genj.edit.Editor;
import genj.edit.Images;
import genj.edit.Options;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.UnitOfWork;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.util.swing.DialogHelper;
import genj.view.ContextProvider;
import genj.view.ToolBar;
import genj.view.View;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditView
extends View
implements ContextProvider {
    static final Logger LOG = Logger.getLogger("genj.edit");
    private static final Registry REGISTRY = Registry.get(EditView.class);
    static final Resources RESOURCES = Resources.get(EditView.class);
    private Mode mode = new Mode();
    private OK ok = new OK();
    private Cancel cancel = new Cancel();
    private Callback callback = new Callback();
    private boolean isIgnoreSetContext = false;
    private boolean isChangeSource = false;
    private Editor editor;
    private JPanel buttons = new JPanel(new FlowLayout(2));
    private ToolBar toolbar;
    private Gedcom gedcom;

    public EditView() {
        super(new BorderLayout());
        ButtonHelper buttonHelper = new ButtonHelper().setInsets(0).setContainer(this.buttons);
        buttonHelper.create(this.ok).setFocusable(false);
        buttonHelper.create(this.cancel).setFocusable(false);
        this.setLayout(new BorderLayout());
        this.add("South", this.buttons);
        this.mode.setSelected(REGISTRY.get("advanced", false));
    }

    private void setEditor(Editor editor) {
        ViewContext viewContext = null;
        if (editor != null) {
            viewContext = this.editor != null ? this.editor.getContext() : null;
            this.commit();
        }
        if (this.editor != null) {
            this.editor.removeChangeListener(this.ok);
            this.editor.removeChangeListener(this.cancel);
            this.editor.setContext(new Context());
            this.remove(this.editor);
            this.editor = null;
        }
        this.editor = editor;
        if (this.editor != null) {
            this.add((Component)this.editor, "Center");
            if (viewContext != null) {
                this.editor.setContext(viewContext);
            }
            this.editor.addChangeListener(this.ok);
            this.editor.addChangeListener(this.cancel);
        }
        this.revalidate();
        this.repaint();
    }

    public ViewContext getContext() {
        return this.editor != null ? this.editor.getContext() : null;
    }

    public void commit() {
        this.commit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(boolean bl) {
        if (!this.ok.isEnabled()) {
            return;
        }
        if (!this.getTopLevelAncestor().isVisible()) {
            return;
        }
        if (bl && !Options.getInstance().isAutoCommit) {
            JCheckBox jCheckBox = new JCheckBox(RESOURCES.getString("confirm.autocomit"));
            jCheckBox.setFocusable(false);
            int n = DialogHelper.openDialog(RESOURCES.getString("confirm.keep.changes"), 3, new JComponent[]{new JLabel(RESOURCES.getString("confirm.keep.changes")), jCheckBox}, (Action[])Action2.yesNo(), (Object)this);
            if (n != 0) {
                this.ok.setEnabled(false);
                this.cancel.setEnabled(false);
                this.buttons.setVisible(false);
                return;
            }
            Options.getInstance().isAutoCommit = jCheckBox.isSelected();
        }
        try {
            this.isChangeSource = true;
            this.isIgnoreSetContext = true;
            if (this.gedcom.isWriteLocked()) {
                this.editor.commit();
            } else {
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        EditView.this.editor.commit();
                    }
                });
            }
        }
        catch (Throwable throwable) {
            LOG.log(Level.WARNING, "error committing editor", throwable);
        }
        finally {
            this.isChangeSource = false;
            this.isIgnoreSetContext = false;
            this.ok.setEnabled(false);
            this.cancel.setEnabled(false);
            this.buttons.setVisible(false);
        }
    }

    public void setContext(Context context, boolean bl) {
        if (this.isIgnoreSetContext) {
            return;
        }
        if (context.getGedcom() != this.gedcom && this.gedcom != null) {
            this.gedcom.removeGedcomListener(this.callback);
            this.gedcom = null;
        }
        if (context.getGedcom() == null) {
            this.setEditor(null);
            this.populate(this.toolbar);
            this.ok.setEnabled(false);
            this.cancel.setEnabled(false);
            this.buttons.setVisible(false);
            return;
        }
        if (context.getGedcom() != this.gedcom) {
            this.gedcom = context.getGedcom();
            this.gedcom.addGedcomListener(this.callback);
        }
        this.commit();
        if (context.getEntities().size() == 1) {
            if (this.editor == null) {
                if (this.mode.isSelected()) {
                    this.setEditor(new AdvancedEditor(context.getGedcom(), this));
                } else {
                    this.setEditor(new BasicEditor(context.getGedcom(), this));
                }
            }
            this.editor.setContext(context);
        } else if (this.editor != null) {
            this.editor.setContext(new Context(context.getGedcom()));
        }
        this.ok.setEnabled(false);
        this.cancel.setEnabled(false);
        this.buttons.setVisible(false);
        this.populate(this.toolbar);
    }

    public void populate(ToolBar toolBar) {
        this.toolbar = toolBar;
        if (toolBar == null) {
            return;
        }
        toolBar.beginUpdate();
        if (this.editor != null) {
            for (Action action : this.editor.getActions()) {
                toolBar.add(action);
            }
        }
        toolBar.addSeparator();
        toolBar.add(new JToggleButton(this.mode));
        toolBar.endUpdate();
    }

    public Dimension getPreferredSize() {
        return new Dimension(256, 480);
    }

    public Entity getEntity() {
        return this.editor.getContext().getEntity();
    }

    private class Callback
    extends GedcomListenerAdapter {
        private Callback() {
        }

        public void gedcomWriteLockAcquired(Gedcom gedcom) {
            if (!EditView.this.isChangeSource) {
                EditView.this.commit(false);
            }
        }

        public void gedcomWriteLockReleased(Gedcom gedcom) {
            if (EditView.this.editor != null && !EditView.this.isChangeSource) {
                ViewContext viewContext = EditView.this.editor.getContext();
                EditView.this.editor.setContext(new Context());
                EditView.this.editor.setContext(viewContext);
                EditView.this.populate(EditView.this.toolbar);
            }
        }
    }

    private class Cancel
    extends Action2
    implements ChangeListener {
        private Cancel() {
            this.setText(Action2.TXT_CANCEL);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditView.this.ok.setEnabled(false);
            EditView.this.cancel.setEnabled(false);
            EditView.this.buttons.setVisible(false);
            ViewContext viewContext = EditView.this.editor.getContext();
            EditView.this.editor.setContext(new Context());
            EditView.this.editor.setContext(viewContext);
            EditView.this.populate(EditView.this.toolbar);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.setEnabled(true);
            EditView.this.buttons.setVisible(true);
            EditView.this.buttons.revalidate();
        }
    }

    private class OK
    extends Action2
    implements ChangeListener {
        private OK() {
            this.setText(Action2.TXT_OK);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditView.this.commit(false);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.setEnabled(true);
            EditView.this.buttons.setVisible(true);
            EditView.this.buttons.revalidate();
        }
    }

    private class Mode
    extends Action2 {
        private Mode() {
            this.setImage(Images.imgView);
            this.setTip(RESOURCES, "action.mode");
            super.setSelected(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setSelected(this.isSelected());
        }

        public boolean setSelected(boolean bl) {
            REGISTRY.put("advanced", bl);
            if (EditView.this.getContext() != null) {
                EditView.this.setEditor(bl ? new AdvancedEditor(EditView.this.getContext().getGedcom(), EditView.this) : new BasicEditor(EditView.this.getContext().getGedcom(), EditView.this));
            }
            EditView.this.populate(EditView.this.toolbar);
            return super.setSelected(bl);
        }
    }
}

