/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.util.Resources;
import genj.util.swing.NestedBlockLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ChoosePropertyBean
extends JComponent {
    private static final Resources RESOURCES = Resources.get(ChoosePropertyBean.class);
    private JRadioButton rbChoose;
    private JRadioButton rbCustom;
    private JTextField tfCustom;
    private JList lChoose;
    private JTextPane tpInfo;
    private List<ActionListener> listeners = new CopyOnWriteArrayList<ActionListener>();
    private Callback callback = new Callback();

    public ChoosePropertyBean(Property property) {
        MetaProperty[] metaPropertyArray = property.getNestedMetaProperties(5);
        this.init(metaPropertyArray, true);
    }

    public ChoosePropertyBean(MetaProperty[] metaPropertyArray) {
        this.init(metaPropertyArray, false);
    }

    private void init(MetaProperty[] metaPropertyArray, boolean bl) {
        Arrays.sort(metaPropertyArray, this.callback);
        this.setLayout(new NestedBlockLayout("<col><label1/><row><tags/><info gx=\"1\" gy=\"1\"/></row><label2/><tag/></col>"));
        this.rbChoose = new JRadioButton(RESOURCES.getString("choose.known"), metaPropertyArray.length > 0);
        this.rbChoose.setEnabled(metaPropertyArray.length > 0);
        this.rbChoose.addItemListener(this.callback);
        this.rbChoose.setAlignmentX(0.0f);
        if (bl) {
            this.add(this.rbChoose);
        } else {
            this.add(new JLabel(RESOURCES.getString("choose.known")));
        }
        this.lChoose = new JList<MetaProperty>(metaPropertyArray);
        this.lChoose.setVisibleRowCount(4);
        this.lChoose.setEnabled(metaPropertyArray.length > 0);
        this.lChoose.setCellRenderer(new MetaDefRenderer());
        this.lChoose.addListSelectionListener(this.callback);
        this.lChoose.addMouseListener(this.callback);
        this.add(new JScrollPane(this.lChoose));
        this.tpInfo = new JTextPane();
        this.tpInfo.setText("");
        this.tpInfo.setEditable(false);
        this.tpInfo.setPreferredSize(new Dimension(256, 256));
        this.add(new JScrollPane(this.tpInfo));
        this.rbCustom = new JRadioButton(RESOURCES.getString("choose.new"), metaPropertyArray.length == 0);
        this.rbCustom.addItemListener(this.callback);
        this.rbCustom.setAlignmentX(0.0f);
        if (bl) {
            this.add(this.rbCustom);
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbChoose);
        buttonGroup.add(this.rbCustom);
        this.tfCustom = new JTextField();
        this.tfCustom.setEnabled(metaPropertyArray.length == 0);
        this.tfCustom.setAlignmentX(0.0f);
        if (bl) {
            this.add(this.tfCustom);
        }
        if (metaPropertyArray.length > 0) {
            this.lChoose.setSelectedIndex(0);
        }
    }

    public void setSingleSelection(boolean bl) {
        this.lChoose.setSelectionMode(bl ? 0 : 2);
    }

    public String[] getSelectedTags() {
        String[] stringArray;
        String[] stringArray2 = null;
        if (this.rbChoose.isSelected()) {
            Object[] objectArray = this.lChoose.getSelectedValues();
            stringArray2 = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray2[i] = ((MetaProperty)objectArray[i]).getTag();
            }
            return stringArray2;
        }
        String string = this.tfCustom.getText();
        if (string != null) {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = string;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Callback
    extends MouseAdapter
    implements ItemListener,
    ListSelectionListener,
    Comparator<MetaProperty> {
        private Callback() {
        }

        @Override
        public int compare(MetaProperty metaProperty, MetaProperty metaProperty2) {
            return metaProperty.getName().compareTo(metaProperty2.getName());
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                ActionEvent actionEvent = new ActionEvent(ChoosePropertyBean.this, 0, null);
                for (ActionListener actionListener : ChoosePropertyBean.this.listeners) {
                    actionListener.actionPerformed(actionEvent);
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == ChoosePropertyBean.this.rbChoose) {
                ChoosePropertyBean.this.lChoose.setEnabled(true);
                ChoosePropertyBean.this.tfCustom.setEnabled(false);
                ChoosePropertyBean.this.lChoose.requestFocusInWindow();
            }
            if (itemEvent.getSource() == ChoosePropertyBean.this.rbCustom) {
                ChoosePropertyBean.this.lChoose.clearSelection();
                ChoosePropertyBean.this.lChoose.setEnabled(false);
                ChoosePropertyBean.this.tfCustom.setEnabled(true);
                ChoosePropertyBean.this.tfCustom.requestFocusInWindow();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object[] objectArray = ChoosePropertyBean.this.lChoose.getSelectedValues();
            if (objectArray == null || objectArray.length == 0) {
                ChoosePropertyBean.this.tpInfo.setText("");
                return;
            }
            MetaProperty metaProperty = (MetaProperty)objectArray[objectArray.length - 1];
            ChoosePropertyBean.this.tpInfo.setText(metaProperty.getInfo());
            if (!ChoosePropertyBean.this.rbChoose.isSelected()) {
                ChoosePropertyBean.this.rbChoose.doClick();
            }
        }
    }

    class MetaDefRenderer
    extends DefaultListCellRenderer {
        MetaDefRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            MetaProperty metaProperty = (MetaProperty)object;
            this.setText(metaProperty.getName() + " (" + metaProperty.getTag() + ")");
            this.setIcon(metaProperty.getImage());
            return this;
        }
    }
}

